package com.idenfy.idenfySdk.CoreSdkInitialization

import android.os.Parcel
import android.os.Parcelable
import android.view.View

class IdenfyResultsSubtitleUISettings() : Parcelable {
    var isVisibleOnSuccess = false
    var isVisibleOnError = false
    var isVisibleOnLoading = false

    var errorSubtitle: String? = null
    var successSubtitle: String? = null
    var loadingSubtitle: String? = null

    var visibilitySetAsGone = false;
    var visibilitySetAsInvisible = true;

    constructor(parcel: Parcel) : this() {
        isVisibleOnSuccess = parcel.readByte() != 0.toByte()
        isVisibleOnError = parcel.readByte() != 0.toByte()
        isVisibleOnLoading = parcel.readByte() != 0.toByte()
        errorSubtitle = parcel.readString()
        successSubtitle = parcel.readString()
        loadingSubtitle = parcel.readString()
        visibilitySetAsGone = parcel.readByte() != 0.toByte()
        visibilitySetAsInvisible = parcel.readByte() != 0.toByte()
    }

    fun setSubtitleAsGone() {
        visibilitySetAsGone = true;
        visibilitySetAsInvisible = false;
    }

    fun setSubtitleAsInvisible() {
        visibilitySetAsGone = false;
        visibilitySetAsInvisible = true;
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeByte(if (isVisibleOnSuccess) 1 else 0)
        parcel.writeByte(if (isVisibleOnError) 1 else 0)
        parcel.writeByte(if (isVisibleOnLoading) 1 else 0)
        parcel.writeString(errorSubtitle)
        parcel.writeString(successSubtitle)
        parcel.writeString(loadingSubtitle)
        parcel.writeByte(if (visibilitySetAsGone) 1 else 0)
        parcel.writeByte(if (visibilitySetAsInvisible) 1 else 0)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<IdenfyResultsSubtitleUISettings> {
        override fun createFromParcel(parcel: Parcel): IdenfyResultsSubtitleUISettings {
            return IdenfyResultsSubtitleUISettings(parcel)
        }

        override fun newArray(size: Int): Array<IdenfyResultsSubtitleUISettings?> {
            return arrayOfNulls(size)
        }
    }


}