package com.idenfy.idenfySdk.di

import android.app.Application
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.Repository.RepositoryKotlin
import com.idenfy.idenfySdk.Repository.RepositoryKotlinProvider
import com.idenfy.idenfySdk.backgrounduploading.data.datasource.BackgroundUploadingDataSource
import com.idenfy.idenfySdk.backgrounduploading.data.repository.BackgroundUploadingRepositoryImpl
import com.idenfy.idenfySdk.backgrounduploading.datasource.BackgroundUploadingDataSourceImpl
import com.idenfy.idenfySdk.backgrounduploading.domain.usecase.BackgroundCameraPhotosHolderUseCase
import com.idenfy.idenfySdk.backgrounduploading.domain.repository.BackgroundUploadingRepository
import io.reactivex.disposables.CompositeDisposable

class DIProvider(val application: Application, val apiServiceProvider: APIServiceProvider = APIServiceProvider) {
    fun getBackgroundUploadingUseCase(compositeDisposable: CompositeDisposable) : BackgroundCameraPhotosHolderUseCase
    {
        return BackgroundCameraPhotosHolderUseCase(backgroundUploadingRepository,
                application.applicationContext);
    }

    private val backgroundUploadingDataSource: BackgroundUploadingDataSource by lazy {
        BackgroundUploadingDataSourceImpl(apiServiceProvider.getAPIService())
    }


    private val backgroundUploadingRepository: BackgroundUploadingRepository by lazy {
        BackgroundUploadingRepositoryImpl(backgroundUploadingDataSource, apiServiceProvider.getAPIService())
    }
    fun getIdenfyController() :IdenfyController
    {
        return IdenfyController.getInstance();
    }
    fun getRepositoryKotlin() : RepositoryKotlin
    {
        return RepositoryKotlinProvider.getInstance(getIdenfyController(), application, apiServiceProvider.getAPIService());
    }

}