package com.idenfy.idenfySdk.UI.CustomViews;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

import com.idenfySdk.R;
import com.idenfy.idenfysdk.core.utils.ui.DpToPixelConverter;

public class OvalFace extends View {
    private static final float RADIUS = 200;

    private Paint mBackgroundPaint;
    private float mCx = -1;
    private float mCy = -1;

    private int mTutorialColor = getResources().getColor(R.color.idenfyTransparentCameraOverlay);
    private RectF oval1;
    private RectF ovalStroke;
    Paint strokePaint;
    int layoutWidth;
    int layoutHeight;
    private int paddingDefault = DpToPixelConverter.dpToPx(5);

    public OvalFace(Context context) {
        super(context);
        init();
    }

    public OvalFace(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public OvalFace(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
        draw();
    }

    private void draw() {
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public OvalFace(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }


    @Override
    protected void onSizeChanged(int xNew, int yNew, int xOld, int yOld) {
        super.onSizeChanged(xNew, yNew, xOld, yOld);


        if (layoutHeight != yNew || layoutWidth != xNew) {
            layoutHeight = yNew;
            layoutWidth = xNew;
            oval1 = new RectF(0, DpToPixelConverter.dpToPx(30), layoutWidth, layoutHeight);
            ovalStroke = new RectF(-paddingDefault,
                    -paddingDefault + DpToPixelConverter.dpToPx(30),
                    layoutWidth + paddingDefault,
                    layoutHeight + paddingDefault
            );
        }
    }

    private void init() {
        setWillNotDraw(false);
        setLayerType(LAYER_TYPE_HARDWARE, null);

        mBackgroundPaint = new Paint();
        mBackgroundPaint.setColor(Color.RED);
        mBackgroundPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        strokePaint = new Paint();
        strokePaint.setStyle(Paint.Style.STROKE);
        strokePaint.setColor(getResources().getColor(R.color.idenfyFaceBorderColor));
        strokePaint.setStrokeWidth(DpToPixelConverter.dpToPx(2));

    }


    @Override
    protected void onDraw(Canvas canvas) {
        canvas.drawColor(mTutorialColor);
        float cX = canvas.getWidth() / 2.0f;
        float cY = canvas.getHeight() / 2.0f;
        canvas.scale(0.75f, 0.65f, cX, cY);
        canvas.drawOval(ovalStroke, strokePaint);
        canvas.drawOval(oval1, mBackgroundPaint);

    }
}