package com.idenfy.idenfySdk.uicomponents;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;

import com.idenfySdk.R;

public class IDenfyButton extends AppCompatButton {
    public IDenfyButton(Context context) {
        super(context);
    }

    public IDenfyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        applyCustomFont(context, attrs, null, null);
    }

    public IDenfyButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        applyCustomFont(context, attrs, null, null);
    }

    //Method is called to set the font programmatically
    public void setCustomFont(Context context, String fontName, Boolean hasUnderLine) {
        applyCustomFont(context, null, fontName, hasUnderLine);
    }

    private void applyCustomFont(Context context, AttributeSet attrs, String fontName, Boolean hasUnderline) {
        try {
            Typeface face;
            String customFont = getCustomFont(context, attrs);

            if (fontName != null) {
                face = Typeface.createFromAsset(context.getAssets(), "fonts/" + fontName);
                this.setTypeface(face);
            } else if (customFont != null) {
                face = Typeface.createFromAsset(context.getAssets(), "fonts/" + customFont);
                this.setTypeface(face);
            }
            if (hasUnderline != null) {
                this.setPaintFlags(this.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
            } else if (hasUnderline(context, attrs)) {
                this.setPaintFlags(this.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getCustomFont(Context context, AttributeSet attrs) {
        TypedArray ta = null;

        try {
            ta = context.obtainStyledAttributes(attrs, R.styleable.IDenfyButton, 0, 0);
            return ta.getString(R.styleable.IDenfyButton_customfont);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (ta != null) {
                ta.recycle();
            }
        }
        return null;
    }

    private boolean hasUnderline(Context context, AttributeSet attrs) {
        TypedArray ta = null;

        try {
            ta = context.obtainStyledAttributes(attrs, R.styleable.IDenfyButton, 0, 0);
            return ta.getBoolean(R.styleable.IDenfyButton_underline, false);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (ta != null) {
                ta.recycle();
            }
        }
        return false;
    }
}
