package com.idenfy.idenfySdk.initialagreement.ui.views

import android.annotation.SuppressLint
import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.net.Uri
import android.os.Bundle
import android.support.constraint.ConstraintLayout
import android.support.design.widget.Snackbar
import android.support.v4.content.ContextCompat
import android.support.v7.widget.AppCompatButton
import android.support.v7.widget.AppCompatImageView
import android.text.Html
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import android.widget.TextView

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.initialagreement.domain.InitialAgreementDataModel
import com.idenfy.idenfySdk.initialagreement.ui.viewmodels.InitialAgreementViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country
import com.idenfy.idenfySdk.helpers.enums.FontEnum
import com.idenfySdk.R
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp


class InitialAgreementFragmnet : ViewLifecycleFragment(), CountriesSelectionFragment.OnCountrySelected {
    override fun onCountrySelected(country: Country) {

    }

    lateinit var cameraViewModel: CameraViewModel
    lateinit var initialAgreementViewModel: InitialAgreementViewModel
    private var mListener: OnFragmentInteractionListener? = null
    private var countriesSelectionFragment: CountriesSelectionFragment? = null
    lateinit var bottomCountriesArrow: AppCompatImageView
    private val COUNTRIES_SELECTION_DIALOG_FRAGMENT = "COUNTRIES_SELECTION_DIALOG_FRAGMENT"

    lateinit var countriesSelectionButton: ConstraintLayout

    lateinit var checkBox: CheckBox
    lateinit var checkBox2: CheckBox
    private var rootView: View? = null
    lateinit var termsAndConditions: TextView
    lateinit var issuingCountry: TextView

    lateinit var submitOkButton: AppCompatButton

    var initialAgreementDataModel: InitialAgreementDataModel? = null

    lateinit var countrySelectionText : TextView
    lateinit var countryIconDrawable: AppCompatImageView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)
        initialAgreementViewModel = ViewModelProviders.of(this).get(InitialAgreementViewModel::class.java)

    }

    val initialAgreementViewModelObserver = Observer<InitialAgreementDataModel>
    { viewData ->
        if (viewData == null) {
            return@Observer
        }
        initialAgreementDataModel = viewData

        countriesSelectionButton.isEnabled = viewData.isCountrySelectionEnabled
        submitOkButton.isEnabled = viewData.isStartSessionButtonEnabled
        checkBox.isChecked = viewData.isCheckBox1Enabled
        checkBox2.isChecked = viewData.isCheckBox2Enabled
        handleSubmitButton(viewData.isStartSessionButtonActive)
        if (!viewData.isCountrySelectionEnabled)
            bottomCountriesArrow.visibility = View.GONE
        if (viewData.selectedCountryFromList != null) {
            setupCountryValue(viewData.selectedCountryFromList!!)
        }
        if (viewData.selectedCountryFromPartnerInfo != null) {
            issuingCountry.text = resources.getText(R.string.select_your_document_issuing_country_message_predifined)
            setupCountryValue(viewData.selectedCountryFromPartnerInfo!!)
        }

    }

    @SuppressLint("RestrictedApi")
    fun handleSubmitButton(buttonEnabled: Boolean) {
        if (buttonEnabled) {
            submitOkButton.setBackgroundColor(resources.getColor(R.color.idenfyColorAccent))
            submitOkButton.supportBackgroundTintList = ContextCompat.getColorStateList(context!!,
                    R.color.idenfyColorAccent)
        } else {
            submitOkButton.setBackgroundColor(resources.getColor(R.color.colorAccentIdenfyDarkgrey))
            submitOkButton.supportBackgroundTintList = ContextCompat.getColorStateList(context!!,
                    R.color.colorAccentIdenfyDarkgrey)
        }
    }

    var dismissCountryDialogObserver = Observer<Boolean> {
        if (it == null)
            return@Observer
        if (it) {
            countriesSelectionFragment = activity?.supportFragmentManager?.findFragmentByTag(COUNTRIES_SELECTION_DIALOG_FRAGMENT) as? CountriesSelectionFragment
            countriesSelectionFragment?.dismiss()
        }
    }

    private fun setupCountryValue(response: Country) {
        countrySelectionText.text = response.name
        countryIconDrawable.visibility = View.VISIBLE
        countryIconDrawable.setImageDrawable(resources.getDrawable(response.resId))
    }

    @SuppressLint("RestrictedApi")
    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        countryIconDrawable.visibility = View.GONE
        (activity as CameraPreviewActivity).toolbarTitle?.text = resources.getString(R.string.start_identity_verification)
        InitialAgreementRepositoryImp.initialAgreementDataModel.value?.isStartSessionButtonEnabled = true;
        InitialAgreementRepositoryImp.initialAgreementDataModel = InitialAgreementRepositoryImp.initialAgreementDataModel
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            submitOkButton.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            checkBox.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT)
            checkBox2.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT)
            countrySelectionText.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            issuingCountry.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            termsAndConditions.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
        }
        countriesSelectionButton.setOnClickListener {
            val fm = activity?.getSupportFragmentManager()
            val fragment = fm?.findFragmentByTag(COUNTRIES_SELECTION_DIALOG_FRAGMENT)
            if (fragment == null) {
                val ft = fm?.beginTransaction()
                countriesSelectionFragment = CountriesSelectionFragment.newInstance()
                countriesSelectionFragment!!.setTargetFragment(this@InitialAgreementFragmnet,
                        5)
                countriesSelectionFragment!!.show(ft, COUNTRIES_SELECTION_DIALOG_FRAGMENT)
            }
        }
        if (activity != null) {
            val builder = SpannableStringBuilder()
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    resources.getString(com.idenfySdk.R.string.initial_text_part) + " "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    resources.getString(com.idenfySdk.R.string.initial_text_part_2
                    ) + " "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    resources.getString(com.idenfySdk.R.string.initial_text_part_3
                    ) + " "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    resources.getString(com.idenfySdk.R.string.initial_text_part_4
                    ) + " "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    resources.getString(com.idenfySdk.R.string.initial_text_part_5
                    ) + " "))
            checkBox.text = builder
        }

        observeInitialAgreementDataViewModel()
        observeCountriesSelectionDialog()

        checkBox2.setOnCheckedChangeListener { buttonView, isChecked ->
            initialAgreementViewModel.initialAgreementDataModelLiveData.value?.isCheckBox2Enabled = isChecked
            initialAgreementViewModel.updateInitialAgreementDataModelLiveData(initialAgreementViewModel.initialAgreementDataModelLiveData.value)

        }
        checkBox.setOnCheckedChangeListener { buttonView, isChecked ->
            initialAgreementViewModel.initialAgreementDataModelLiveData.value?.isCheckBox1Enabled = isChecked;
            initialAgreementViewModel.updateInitialAgreementDataModelLiveData(initialAgreementViewModel.initialAgreementDataModelLiveData.value)
        }
        submitOkButton.setOnClickListener(object : View.OnClickListener {
            override fun onClick(v: View) {
                if (initialAgreementViewModel.initialAgreementDataModelLiveData.value!!.isStartSessionButtonActive) {
                    cameraViewModel.startSession()
                    createRequestForSettingCountry(initialAgreementViewModel.initialAgreementDataModelLiveData.value!!)
                    cameraViewModel.repository.idenfyInternalSettings.isInitialViewClosed = true
                    cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(false)
                } else {

                    val mySnackbar = initialAgreementViewModel.initialAgreementDataModelLiveData.value!!.errorMessageId?.let { resources.getText(it) }?.let {
                        Snackbar.make(rootView!!,
                                it, Snackbar.LENGTH_SHORT)
                    }
                    mySnackbar?.show()

                }
            }
        })
    }

    private fun observeInitialAgreementDataViewModel() {
        initialAgreementViewModel.initialAgreementDataModelLiveData.observe(viewLifecycleOwner!!, initialAgreementViewModelObserver)

    }

    private fun observeCountriesSelectionDialog() {
        cameraViewModel.getDismissCountryDialogLiveData().observe(viewLifecycleOwner!!, dismissCountryDialogObserver)
    }

    private fun createRequestForSettingCountry(dataViewModel: InitialAgreementDataModel) {
        if (dataViewModel.selectedCountryFromPartnerInfo != null) {
            cameraViewModel.repository.setCountryTriggerDone()
            return
        }
        cameraViewModel.setCountryForDocument(dataViewModel.selectedCountryFromList!!)

    }

    private fun setColoredSpan(color: ForegroundColorSpan, string: String): SpannableString {
        val spanStr = SpannableString(string)
        spanStr.setSpan(color, 0, spanStr.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        return spanStr
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        checkBox = view.findViewById(R.id.checkBox)
        termsAndConditions = view.findViewById(R.id.terms_and_conditions)
        issuingCountry = view.findViewById(R.id.select_your_document_issuing_country)
        checkBox.setTextColor(ContextCompat.getColor(activity!!, com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor))
        checkBox2 = view.findViewById(R.id.checkBox2)
        checkBox2.text = Html.fromHtml(getString(R.string.first_checkbox))
        submitOkButton = view.findViewById(R.id.submitButton)
        countriesSelectionButton = view.findViewById(R.id.countries_button_selection)
        bottomCountriesArrow = view.findViewById(R.id.countries_selection_arrow)
        countrySelectionText = view.findViewById(R.id.countries_selection_country)
        countryIconDrawable = view.findViewById(R.id.country_icon_drawable)

    }

    override fun onDestroyView() {
        super.onDestroyView()
        if ((activity as CameraPreviewActivity).toolbarTitle != null)
            (activity as CameraPreviewActivity).toolbarTitle?.setText(R.string.idenfy_default_toolbar_title)
        cameraViewModel.setDismissCountryDialogMutableLiveData(true)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_initial_agreement_view, container,
                false)
        return rootView
    }


    override fun onPause() {
        super.onPause()
    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)
        if (context is OnFragmentInteractionListener) {
            mListener = context
        } else {
            throw RuntimeException(context!!.toString() + " must implement OnDocumentScanningFeatureListener")
        }
    }

    override fun onDetach() {
        super.onDetach()
        mListener = null
    }

    interface OnFragmentInteractionListener {
        fun onFragmentInteraction(uri: Uri)
    }
}// Required empty public constructor
