package com.idenfy.idenfySdk.UI.UIHelpers;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.preview.Frame;
import io.fotoapparat.preview.FrameProcessor;

public class DocumentsCameraSessionFrameProcessor implements FrameProcessor {

    public DocumentsCameraSessionFrameProcessor(FragmentActivity fragmentActivity) {
        weakContext = new WeakReference<>(fragmentActivity);
    }

    public interface OnPictureListener {
        void OnPictureTaken(Bitmap bitmap, int rotation, String encoded);
    }

    public interface onSessionListener {
        void OnPictureTaken(byte[] bitmap, int rotation, String encoded);
    }

    private OnPictureListener listener = null;
    private onSessionListener sessionListener = null;
    private AtomicBoolean takePicture  = new AtomicBoolean(false);
    private AtomicBoolean takeBackgroundPicture = new AtomicBoolean(false);
    private AtomicBoolean takingPicture = new AtomicBoolean(false);
    private static WeakReference<FragmentActivity> weakContext;

    @Override
    public void process(final @NonNull Frame frame) {
        if (weakContext.get() != null) {
            if (takeBackgroundPicture.get()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapPhotoCropper.cropPhoto(frame.getImage(), frame.getSize().width, frame.getSize().height, weakContext.get(), 10);
                byte[] compressed = BitmapPhotoCropper.compressBitmap(bitmap, 10, 480f, 640f);
                if (sessionListener != null) {
                    sessionListener.OnPictureTaken(compressed, frame.getRotation(), "");
                    sessionListener = null;
                }
            }
            if (takePicture.get()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapPhotoCropper.cropPhoto(frame.getImage(), frame.getSize().width, frame.getSize().height, weakContext.get(), 100);

                if (listener != null) {
                    takeBackgroundPicture.set(false);
                    listener.OnPictureTaken(bitmap, frame.getRotation(), "");
                    listener = null;
                }
            }
        }
        takePicture.set(false);
        takingPicture.set(false);
    }


//    public void takePicture(OnPictureListener onPictureListener) {
//        takePicture.set(true);
//    }
//    public void takeBackgroundPicture(onSessionListener onSessionListener) {
//        takeBackgroundPicture.set(true);
//    }

    public void takePicture(OnPictureListener listener) {
            this.listener = listener;
            takePicture.set(true);
    }

    public void takeBackgroundPicture(onSessionListener listener) {
        this.sessionListener = listener;
        takeBackgroundPicture.set(true);
    }


    public void setListeners(OnPictureListener listener, onSessionListener onPictureListener)
    {
        this.listener = listener;
        this.sessionListener = onPictureListener;

    }

}