package com.idenfy.idenfySdk.Repository

import android.app.Application
import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData
import android.util.Log
import com.google.gson.GsonBuilder
import com.google.gson.JsonElement
import com.google.gson.JsonParser
import com.idenfy.docscanning.networking.models.DocDataKeyResponse
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyUserFlowController
import com.idenfy.idenfySdk.Networking.*
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country
import com.idenfy.idenfySdk.helpers.SingleLiveEvent
import com.idenfy.idenfySdk.presentation.InitialLoadingDataViewModel
import com.idenfy.idenfysdk.core.extensions.rxextensions.retryWhenError
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfysdk.core.internal.settings.IdenfyInternalSettings
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentType
import com.idenfy.idenfysdk.core.models.documentTypeData.Step
import com.idenfy.idenfysdk.core.networking.models.requestBodies.*
import com.idenfy.idenfysdk.core.networking.models.responseBodies.CountryCode
import com.idenfy.idenfysdk.core.networking.models.responseBodies.PartnerInfo
import com.idenfy.idenfysdk.core.security.VigenereCipher
import io.reactivex.Observable
import io.reactivex.Single
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.functions.Function5
import io.reactivex.schedulers.Schedulers
import io.reactivex.subjects.ReplaySubject
import okhttp3.MediaType
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.HttpException
import java.io.File
import kotlin.collections.ArrayList
import kotlin.collections.LinkedHashMap

class RepositoryKotlin(idenfyController: IdenfyController, application: Application, val apiService: APIService) {

    //initialization
    var application: Application? = application

    //variables
    private var partnerInfo: PartnerInfo = PartnerInfo()
    private var authTokenRequest: AuthTokenRequest = AuthTokenRequest()

    fun returnAuthTokenREquest(): AuthTokenRequest {
        return authTokenRequest
    }

    //Observables
    lateinit var setCountryObservable: Observable<ResponseBody>

    //triggers
    lateinit var startSessionSubjectTrigger: ReplaySubject<Boolean>
    lateinit var setDcumentTypeSubjectTrigger: ReplaySubject<Boolean>
    lateinit var zoomSDKSubjectTrigger: ReplaySubject<Boolean>
    lateinit var setDcumentIssuingCountryTrigger: ReplaySubject<Boolean>
    lateinit var facePhotoUploaedTrigger: ReplaySubject<Boolean>
    lateinit var docScanningUploadedTrigger: ReplaySubject<Boolean>
    lateinit var allPhotosUploadedTrigger: ReplaySubject<Boolean>
    lateinit var allPresignedModelTrigger: ReplaySubject<Boolean>
    var initialDataHasLoadedMutableLiveData = MutableLiveData<Boolean>()
    var countriesListMutableLiveData = MutableLiveData<Resource<List<Country>>>()

    val initialLoadingDataViewModel = MutableLiveData<com.idenfy.idenfysdk.core.networking.Resource<InitialLoadingDataViewModel>>()

    fun returnInitialLoadingDataViewModel(): MutableLiveData<com.idenfy.idenfysdk.core.networking.Resource<InitialLoadingDataViewModel>> {
        return initialLoadingDataViewModel
    }

    fun setupAuthTokenRequest(authToken: String) {
        this.authTokenRequest = AuthTokenRequest(authToken)
    }

    fun deInit() {
        initialDataHasLoadedMutableLiveData.postValue(false)
        countriesListMutableLiveData.postValue(com.idenfy.idenfySdk.Networking.Resource.loading(null))
        initialLoadingDataViewModel.value = com.idenfy.idenfysdk.core.networking.Resource.loading(null)
        idenfyInternalSettings = IdenfyInternalSettings()
    }

    fun fetchDocumentTypes(): Single<List<DocumentType>> {
        return apiService.getDocumentsTypesObservable(authTokenRequest.getAuthToken())
    }

    fun fetchGetCountryByIp(): Single<CountryCode> {
        return apiService.countryByIPAdObservable
    }

    fun getPartnerInfo(): PartnerInfo? {
        return partnerInfo
    }

    //TRIGGERS INIT
    fun setupDocumentTypeTrigger() {
        setDcumentTypeSubjectTrigger = ReplaySubject.create()
    }

    fun setupInitialTriggers() {
        setDcumentIssuingCountryTrigger = ReplaySubject.create()
        startSessionSubjectTrigger = ReplaySubject.create()
    }

    fun startSessionTriggerDone() {
        if (!startSessionSubjectTrigger.hasValue())
            startSessionSubjectTrigger.onNext(true)
    }

    fun setDocumentTypeTriggerDone() {

        setDcumentTypeSubjectTrigger.onNext(true)
    }

    fun setCountryTriggerDone() {
        setDcumentIssuingCountryTrigger.onNext(true)
    }

    fun setDocScanningTriggerDone() {
        docScanningUploadedTrigger.onNext(true)
    }

    fun setAllPhotosUploadedTriggerDone() {
        allPhotosUploadedTrigger.onNext(true)
    }

    fun setAllPresignedModelsGot() {
        allPresignedModelTrigger.onNext(true)
    }

    var idenfyErrorIdentifierLiveData = SingleLiveEvent<String>()

    fun returnIdenfyErrorIdentifierLiveData(): SingleLiveEvent<String> {
        return idenfyErrorIdentifierLiveData
    }

    fun getIdenfyErrorIdentifier(): LiveData<String> {
        return idenfyErrorIdentifierLiveData
    }

    internal var idenfyInternalSettings = IdenfyInternalSettings()

    fun setIdenfyInternalSettings(idenfyInternalSettings: IdenfyInternalSettings) {
        this.idenfyInternalSettings = idenfyInternalSettings
    }

    fun getIdenfyInternalSettings(): IdenfyInternalSettings {
        return this.idenfyInternalSettings
    }

    fun setPartnerInfo(partnerInfo: PartnerInfo) {
        if (partnerInfo.getCountry() != null) {
            IdenfyUserFlowController.onIssuingCountrySelected(partnerInfo.country)
            setCountryTriggerDone()
        }

        this.partnerInfo = partnerInfo
    }

    fun fetchPartnerInfoSingle(): Single<PartnerInfo> {
        return apiService.getPartnerInfoSingle(authTokenRequest)
    }

    fun startSession(authToken: String, compositeDisposable: CompositeDisposable) {
        idenfyInternalSettings.isSessionsStarted = true
        val authTokenRequest = AuthTokenRequest(authToken)
        compositeDisposable.add(apiService.startSessionObservable(authTokenRequest).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .take(1)
                .subscribe({
                    startSessionTriggerDone()
                }, { throwable -> handleErrorInstance(throwable) }))
    }

    fun checkLiveness(livenessCheck: com.idenfy.idenfyliveness.LivenessCheck, compositeDisposable: CompositeDisposable) {

        compositeDisposable.add(facePhotoUploaedTrigger
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .concatMap { response ->
                    RetrofitFactoryKotlinOptional.makeRetrofitService()
                            .checkLivenessObservable(livenessCheck)
                            .retryWhenError(5, 1, false)
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                }.subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .take(1)
                .subscribe({ success ->
                    zoomSDKSubjectTrigger.onNext(true)
                }, { throwable -> handleErrorInstance(throwable) }))
    }

    fun setIssuingCountry(countrySetRequest: CountrySetRequest, compositeDisposable: CompositeDisposable) {
        setCountryObservable = apiService
                .setIssuingCountryObservable(countrySetRequest)
        compositeDisposable.add(setCountryObservable
                .retryWhenError(5, 1, false)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ success ->
                    IdenfyUserFlowController.onIssuingCountrySelected(countrySetRequest.country)
                    setCountryTriggerDone()
                }, { throwable -> handleErrorInstance(throwable) }))
    }

    fun startObservingUploads(stepList: List<String>) {
        zoomSDKSubjectTrigger = ReplaySubject.create()
        docScanningUploadedTrigger = ReplaySubject.create()
        facePhotoUploaedTrigger = ReplaySubject.create()
        allPhotosUploadedTrigger = ReplaySubject.create()
        allPresignedModelTrigger = ReplaySubject.create()
        responseList = arrayListOf()
        hashCodesList = arrayListOf()

        if (!shouldSetupLiveness(stepList)) {
            zoomSDKSubjectTrigger.onNext(true)
        }
        if (!shouldSetupDocScanning(stepList)) {
            setDocScanningTriggerDone()
        }

    }

    fun observeThenToStartProcessing(): Observable<Boolean> {
        return Observable.zip(setDcumentTypeSubjectTrigger, setDcumentIssuingCountryTrigger, zoomSDKSubjectTrigger,
                allPhotosUploadedTrigger, docScanningUploadedTrigger,
                Function5<Boolean, Boolean, Boolean, Boolean, Boolean, Boolean> { setDcumentTypeSubjectTrigger, setDcumentIssuingCountryTrigger,
                                                                                  zoomSDKSubjectTrigger, allPhotosUploadedTrigger, docScanningTrigger ->
                    indicate(setDcumentTypeSubjectTrigger, setDcumentIssuingCountryTrigger,
                            zoomSDKSubjectTrigger, allPhotosUploadedTrigger, docScanningTrigger)
                })
    }

    private fun indicate(setDcumentTypeSubjectTrigger: Boolean, setDcumentIssuingCountryTrigger: Boolean,
                         zoomSDKSubjectTrigger: Boolean, allPhotosUploadedTrigger: Boolean, docScanningTrigger: Boolean): Boolean {
        if (setDcumentTypeSubjectTrigger && setDcumentIssuingCountryTrigger && zoomSDKSubjectTrigger &&
                allPhotosUploadedTrigger && docScanningTrigger) {
            return true
        }
        return false
    }


    //ERROR HANDLING
    fun handleErrorInstance(error: Throwable) {
        if (error is HttpException) {
            try {
                val errorCode = error.code()
                val errorBody = error.response().errorBody()
                handleError(errorCode, errorBody)
            } catch (e: Exception) {
                idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER)
            }

        } else {
            idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER)
        }
    }

    fun handleError(code: Int, errorBody: ResponseBody?) {
        if (code >= 300 && code < 500) {
            val parser = JsonParser()
            var mJson: JsonElement? = null
            try {
                mJson = parser.parse(errorBody?.string())
                val gson = GsonBuilder().setLenient().create()
                val errorResponse = gson.fromJson(mJson, IdenfyErrorResponse::class.java)
                idenfyErrorIdentifierLiveData.postValue(errorResponse.identifier)
            } catch (ex: Exception) {
                idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER)
            }

        } else if (code >= 500) {
            idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.IDENFY_SERVER_ERROR_IDENTIFIER)
        }
    }

    fun shouldSetupLiveness(stepList: List<String>): Boolean {
        if (!partnerInfo.getZoomLiveliness()) {
            return false
        }
        return stepList.contains(Step.FACE.name)
    }

    fun shouldSetupDocScanning(stepList: List<String>): Boolean {
        if (!partnerInfo.mobileAutoDocScanning) {
            return false
        }
        return stepList.contains(Step.FRONT.name)

    }


    //Sets document type
    fun setupDocument(documentTypeRequest: DocumentTypeRequest, compositeDisposable: CompositeDisposable, hasPartnerEnabledZoom: Boolean) {
        compositeDisposable.add(startSessionSubjectTrigger
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .concatMap { response ->
                    apiService
                            .setDocumentTypeObservable(documentTypeRequest)
                            .retryWhenError(5, 1, false)
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                }.subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ success ->
                    if (documentTypeRequest.documentType != null)
                        IdenfyUserFlowController.onDocumentSelected(documentTypeRequest.documentType!!)
                    setDocumentTypeTriggerDone()
                }, { throwable ->
                    handleErrorInstance(throwable)
                })
        )
    }

    fun getS3UploadData(compositeDisposable: CompositeDisposable, s3RequestData: S3RequestData, image: File, base64: String, stepList: List<String>) {
        compositeDisposable.add(startSessionSubjectTrigger
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe {
                    if (it) {
                        apiService.getS3UploadData(s3RequestData)
                                .retryWhenError(5, 1, false)
                                .subscribeOn(Schedulers.io())
                                .observeOn(AndroidSchedulers.mainThread())
                                .subscribe({ presignedUrlModel ->
                                    formData(compositeDisposable, presignedUrlModel, stepList, image, base64, s3RequestData.step)
                                }, { error -> handleErrorInstance(error) }
                                )
                    }
                })
    }


    fun uploadDocumentPhoto(compositeDisposable: CompositeDisposable,
                            url: String,
                            linkedHashMap: LinkedHashMap<String, RequestBody>,
                            checkList: List<String>,
                            image: File,
                            base64: String,
                            step: String) {

        val hascode = linkedHashMap.hashCode()
        hashCodesList.add(hascode)
        linkedHashMap.put("file", RequestBody.create(MediaType.parse("image/*"), image))
        val observable = apiService.uploadPhotoToS3(linkedHashMap, url)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .map {
                    if (it.raw()!=null && !it.raw().isSuccessful) {
                        throw HttpException(it)
                    }
                    it
                }
                .retryWhenError(5, 1, true)
                .subscribe({

                    response ->
                    if (response.raw().code() in 200..300)
                        getUploadedPhotoResponse(response, checkList, hascode, step)
                    else uploadDocumentPhotoLegacy(compositeDisposable, checkList, base64, step)


                }, { error ->
                    uploadDocumentPhotoLegacy(compositeDisposable, checkList, base64, step)
                })


        compositeDisposable.add(observable)
    }

    fun uploadDocumentPhotoLegacy(compositeDisposable: CompositeDisposable,
                                  checkList: List<String>,
                                  base64: String,
                                  step: String) {

        val hascode = base64.hashCode()
        hashCodesList.add(hascode)
        val streamPost = StreamPost(authTokenRequest.authToken, base64, step)
        val observable = apiService.streamPhotoNewObservable(streamPost)
                .retryWhenError(5, 1, false)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ success ->
                    getUploadedPhotoResponse(success, checkList, hascode, step)
                }, { throwable ->
                    handleErrorInstance(throwable)
                })

        compositeDisposable.add(observable)
    }


    private var responseList = ArrayList<Any>()
    var hashCodesList = ArrayList<Int>()
    fun getUploadedPhotoResponse(response: Any, checkList: List<String>, hascode: Int, step: String) {

        if (!hashCodesList.contains(hascode)) {
            return
        }
        responseList.add(response)

        if (step.equals(Step.FACE.name, ignoreCase = true)) {
            facePhotoUploaedTrigger.onNext(true)
        }
        if (responseList.size == checkList.size) {
            setAllPhotosUploadedTriggerDone()
        }
    }

    fun formData(compositeDisposable: CompositeDisposable, presignedUrlModel: PresignedUrlModel, stepList: List<String>, image: File, base64: String, step: String) {
        uploadDocumentPhoto(compositeDisposable,
                presignedUrlModel.url,
                getPresignedUrlModelHashMap(presignedUrlModel)!!,
                stepList, image, base64, step)
    }


    fun getPresignedUrlModelHashMap(presignedUrlModel: PresignedUrlModel?): LinkedHashMap<String, RequestBody>? {
        if (presignedUrlModel != null) {
            val requestBodyHashMap = LinkedHashMap<String, RequestBody>()

            requestBodyHashMap.put("Content-Type", RequestBody.create(MediaType.parse("text/plain"), "image/png"))
            requestBodyHashMap.put("key", RequestBody.create(MediaType.parse("text/plain"), presignedUrlModel.fields.key))
            requestBodyHashMap.put("AWSAccessKeyId", RequestBody.create(MediaType.parse("text/plain"),
                    presignedUrlModel.fields.AWSAccessKeyId))
            requestBodyHashMap.put("signature", RequestBody.create(MediaType.parse("text/plain"), presignedUrlModel.fields.signature))
            requestBodyHashMap.put("policy", RequestBody.create(MediaType.parse("text/plain"), presignedUrlModel.fields.policy))

            return requestBodyHashMap;

        } else {
            return null;
        }
    }

    fun uploadDocReadingData(SDKLifecycleDisposable: CompositeDisposable, data: String, salt: String) {
        SDKLifecycleDisposable.add(getDocDataKey()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .flatMap { docDataKeyResponse ->
                    com.idenfy.docscanning.networking.RetrofitFactory.makeRetrofitService().uploadDocReadingInfo(docDataKeyResponse.est,
                            authTokenRequest.authToken,
                            RequestBody.create(MediaType.parse("text/plain"),
                                    createData(data, docDataKeyResponse.est,
                                            authTokenRequest.authToken, salt)))
                            .retryWhenError(5, 1, false)
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                }.subscribe({ uploadedDocReadingData ->
                    setDocScanningTriggerDone()
                }, { throwable ->
                    handleErrorInstance(throwable)
                }))
    }

    private fun createData(docData: String, est: String, authToken: String, salt: String): String {
        var salt = salt
        salt = est + salt + authToken

        var encrypted = VigenereCipher.encrypt(docData, salt)
        return encrypted
    }

    private fun getDocDataKey(): Observable<DocDataKeyResponse> {
        return com.idenfy.docscanning.networking.RetrofitFactory.makeRetrofitService().getUploadingDocReadingKeys()
    }
}



