package com.idenfy.idenfySdk.Networking

import com.google.gson.GsonBuilder
import com.idenfySdk.BuildConfig
import okhttp3.CertificatePinner
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

object RetrofitFactoryKotlin {
    const val testApi = "http://34.246.55.6/"
    const val productionApi = "https://ivs.idenfy.com/"

    val gson = GsonBuilder()
            .setLenient()
            .create()

    val interceptor = HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)

    private fun makeCertificatePinner(hostname:String): CertificatePinner{
        return CertificatePinner.Builder()
                .add(hostname, BuildConfig.ROOT_PIN)
                .add(hostname, BuildConfig.INTERMEDIATE_PIN)
                .add(hostname, BuildConfig.LEAF_PIN)
                .add(hostname, BuildConfig.ROOT_CA_0)
                .add(hostname, BuildConfig.ROOT_CA_1)
                .add(hostname, BuildConfig.ROOT_CA_2)
                .add(hostname, BuildConfig.ROOT_CA_3)
                .add(hostname, BuildConfig.ROOT_CA_4)
                .add(hostname, BuildConfig.ROOT_CA_5)
                .add(hostname, BuildConfig.ROOT_CA_6)
                .add(hostname, BuildConfig.ROOT_CA_7)
                .build()
    }
    private fun makeOkHttpClient(): OkHttpClient {
        val client = OkHttpClient.Builder()
                .connectTimeout(300, TimeUnit.SECONDS)
                .writeTimeout(300, TimeUnit.SECONDS)
                .readTimeout(300, TimeUnit.SECONDS)
        if (BuildConfig.DEBUG) {
            client.addInterceptor(interceptor)
        } else {
            client.certificatePinner(makeCertificatePinner("ivs.idenfy.com"))
        }
        client.retryOnConnectionFailure(true)
                .addNetworkInterceptor { chain ->
                    val request = chain.request().newBuilder().addHeader("Connection", "close").build()
                    chain.proceed(request)
                }


        return client.build()
    }

    fun makeRetrofitService(): APIService {
        val retrofitBuilder = Retrofit.Builder();
        if (BuildConfig.DEBUG) {
            retrofitBuilder.baseUrl(testApi)
        } else {
            retrofitBuilder.baseUrl(productionApi)
        }
        retrofitBuilder.client(makeOkHttpClient())
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .addConverterFactory(GsonConverterFactory.create(gson))
        return retrofitBuilder.build().create(APIService::class.java)
    }
}