package com.idenfy.idenfySdk.UI.MainActivity;

import android.Manifest;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDelegate;

import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyIdentificationResultsSettings;
import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentTypeClass;
import com.idenfy.idenfySdk.Models.Step;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.RetrofitFactory;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.UI.AuthenticationResultView.AuthenticationResultFragment;
import com.idenfy.idenfySdk.UI.CameraView.DocumentsCameraSessionFragment;
import com.idenfy.idenfySdk.UI.CameraView.FaceCameraSessionFragment;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResultFragment;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.FacePhotoResultFragment;
import com.idenfy.idenfySdk.UI.InitialAgreementView.InitialAgreementFragmnet;
import com.idenfy.idenfySdk.UI.SplashScreenFragment.SplashScreenFragment;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.DocumentWrapper;
import com.idenfy.idenfySdk.helpers.ErrorsHelper;
import com.idenfy.idenfySdk.helpers.IdenfyIdentificationStatus;
import com.idenfy.idenfySdk.helpers.LoggingHelper;
import com.idenfy.idenfySdk.helpers.ResultsFormattingHelper;
import com.idenfy.idenfySdk.helpers.enums.AuthentificationResult;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class CameraPreviewActivity extends AppCompatActivity implements
        AuthenticationResultFragment.OnAuthenticationResultFragmentClosed,
        DocumentsCameraSessionFragment.OnCameraClosedFragment, InitialAgreementFragmnet.OnFragmentInteractionListener,
        AuthenticationResultFragment.RetakeStepsListListener,
        SplashScreenFragment.OnFragmentInteractionListener, DocumentsRecyclerViewAdapter.onItemClickListener {

    private CameraViewModel cameraViewModel;
    private LivenessesViewModel livenessesViewModel;
    private DocumentTypeClass selectedDocument;
    private RecyclerView recyclerView;
    private TextView toolbarTitle;
    private TextView selectDocumentType;
    private String authneticationResultResponse = "authenticationResultResponseLiveData";
    private String idenfyError = "idenfyError";
    private String partherInfoKey = "parthnerInfo";
    private String documentsListKey = "documentsListKey";
    private String settings = "settings";
    private boolean cameraPermissionWasRequested = false;


    private void fetchCountriesList() {
        cameraViewModel.fetchCountriesList();
    }

    private String AUTH_FRAGMENT = "AuthenticationFragment";
    private int REQUEST_PERMISSIONS_CAMERA = 44444;
    private static final String DOCUMENT_PHOTO_RESULT_FRAGMENT = "DOCUMENT_PHOTO_RESULT_FRAGMENT";
    private static final String FACE_CAMERA_SESSION_FRAGMENT = "FACE_CAMERA_SESSION_FRAGMENT";
    private static final String FACE_PHOTO_RESULT_FRAGMENT = "FACE_CAMERA_RESULT_FRAGMENT";
    private String SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment";
    private String CAMERA_NEW_FRAGMENT = "DocumentsCameraSessionFragment";
    private String INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment";
    private int delay = 700;
    private boolean mReturningWithResult;
    public static final String loadingLiveDataAuthTokenKey = "AuthToken";
    public static final String loadingLiveDataFirstCountryKey = "FirstCountry";

    private Integer idenfyErrorDelayClosing = 1000; //1000
    private Integer idenfySuccessDelayClosing = 1200; //1200

    private boolean isDocumentItemPressed;
    private boolean isOnPausedCalled = false;
    private boolean wasPermissionRequested = false;

    private Handler successHandler = new Handler();
    private Handler errorHandler = new Handler();
    private Handler authenticationResultsHandler = new Handler();
    private Handler splashScreenLoading = new Handler();

    private AppCompatImageView backButton;

    private ResultsFormattingHelper resultsFormattingHelper = new ResultsFormattingHelper();


    private void addAuthenticationResultFragment() {
        Fragment auth = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (auth == null) {
            FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
            AuthenticationResultFragment authenticationResultFragment = new AuthenticationResultFragment();
            transaction.add(R.id.newMain, authenticationResultFragment, AUTH_FRAGMENT);
            transaction.replace(R.id.newMain, authenticationResultFragment, AUTH_FRAGMENT);
            transaction.setCustomAnimations(android.R.anim.fade_in, android.R.anim.fade_out);
            transaction.commit();
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        livenessesViewModel = ViewModelProviders.of(this).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(this).get(CameraViewModel.class);

        if (cameraViewModel.isViewModelCreated) {
            if (savedInstanceState != null) {
                cameraViewModel.isRecyclerViewEnabled = true;
            } else {
                cameraViewModel.isRecyclerViewEnabled = false;
            }
            removeAllFragmentsForRestarting();

        } else {
            if (cameraViewModel.getAuthenticationResultFragmentLiveData().getValue() != null && cameraViewModel.getAuthenticationResultFragmentLiveData().getValue()) {
                atomicBoolean.set(false);
                authenticationResultsHandler.removeCallbacksAndMessages(null);
            }

            cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
            cameraViewModel.setaddFacePhotoResultFragment(false);
            cameraViewModel.setAddFaceCameraFragment(false);
            cameraViewModel.setAddCameraFragment(false);
        }


        restoreAppAfterDeath(savedInstanceState);

        //NON UI RELATED

        observeCountriesList();
        observeProccessUploadCompletion();
        //UI initialization
        setContentView(R.layout.activity_main_new);
        initializeUI(savedInstanceState);
        //Observation

        observeCameraFragment();
        observeFaceCameraFragment();

        observeAuthenticationResultFragment();
        observeInitialAgreementFragment();
        observeSdkInitialLoading();
        observeSDKResponse();
        observeDocumentsTypes();
        observeAddDocumentPhotoResultFragmenr();
        observeFacePhotoResultFragment();


        cameraViewModel.observeIdenfyError().observe(this, error ->
        {
            if (error != null)
                cameraViewModel.idenfyError.postValue(error);
        });

        //ZoomObservation
        if (livenessesViewModel.getLivenessHelper() != null) {

            observeZoomSuccessResults();
            observeIsPartnerSelectedZoom();
            observeZoomSuccessResponse();
            observeZoomErrorOccured();
        }

    }

    private void observeFacePhotoResultFragment() {
        cameraViewModel.getAddDocumentFacePhotoResultFragment().observe(this, response ->
        {
            if (response) {
                addFacePhotoResultFragment();
            } else {
                removeFacePhotoResultFragment();
            }

        });
    }

    private void observeFaceCameraFragment() {
        cameraViewModel.getFaceCameraFragmentLiveData().observe(this, response ->
        {
            if (response != null) {
                if (response) {

                    addFaceCameraFragment();
                } else {
                    removeFaceCameraFragment();
                }
            }
        });
    }

    public void addFaceCameraFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT);
        if (fragment == null) {
            {
                FaceCameraSessionFragment cameraNewFragment = new FaceCameraSessionFragment();
                getSupportFragmentManager().
                        beginTransaction().
                        replace(R.id.newMain, cameraNewFragment, FACE_CAMERA_SESSION_FRAGMENT)
                        .commit();
            }
        }
    }

    public void addFacePhotoResultFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT);
        if (fragment == null) {
            FacePhotoResultFragment cameraNewFragment = new FacePhotoResultFragment();
            getSupportFragmentManager().
                    beginTransaction().
                    add(R.id.newMain, cameraNewFragment, FACE_PHOTO_RESULT_FRAGMENT)
                    .commit();
        }
    }

    public void removeFaceCameraFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT);
        if (fragment != null) {
            getSupportFragmentManager().
                    beginTransaction().
                    remove(fragment)
                    .commit();
        }
    }

    public void removeFacePhotoResultFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT);
        if (fragment != null) {
            getSupportFragmentManager().
                    beginTransaction().
                    remove(fragment)
                    .commit();
        }
    }


    private void observeZoomErrorOccured() {
        livenessesViewModel.getZoomErrorOccured().observe(this, response ->
        {
            if (response != null) {
                livenessesViewModel.getLivenessHelper().zoomErrorOccured.setValue(null);
                cameraViewModel.setIdenfyError(new IdenfyError(new IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                        getApplication().getResources()
                                .getString(R.string.IDENFY_FACE_LIVENESS_MESSAGE)),
                        true, 1200));

            }
        });

    }

    private void observeAddDocumentPhotoResultFragmenr() {
        cameraViewModel.addDocumentPhotoResultFragment.observe(this, response ->
        {
            if (response) {
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT);
                if (fragment == null) {
                    DocumentPhotoResultFragment documentPhotoResultFragment = new DocumentPhotoResultFragment();
                    getSupportFragmentManager().beginTransaction().add(R.id.newMain, documentPhotoResultFragment, DOCUMENT_PHOTO_RESULT_FRAGMENT).commit();
                }
            } else {
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT);
                if (fragment != null)
                    getSupportFragmentManager().beginTransaction().remove(fragment).commit();
            }
        });
    }

    private void observeZoomSuccessResults() {
        livenessesViewModel.getZoomSessionResponse().observe(this, response ->
        {
            if (response != null && response.first) {
                livenessesViewModel.getLivenessHelper().zoomSessionResponse.setValue(null);
                cameraViewModel.isZoomLivenessCheckOccured = true;
                cameraViewModel.checkLiveness(response.second);
                cameraViewModel.decideWhichSaveBitmap(cameraViewModel.savedFacePhotoBitmap, cameraViewModel.getUploadDocumentPhotoType());
                cameraViewModel.saveFileToServer(cameraViewModel.getUploadDocumentPhotoType(), cameraViewModel.currentDocumentClass.getCurrentStepPosition());
            } else {
                cameraViewModel.setaddFacePhotoResultFragment(false);
            }
        });
    }

    private void observeZoomSuccessResponse() {
        livenessesViewModel.getLivenessHelper().zoomSessionSuccess.observe(this, response ->
        {
            if (response != null && response) {
                livenessesViewModel.getLivenessHelper().zoomSessionSuccess.setValue(null);
                cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.loading(null));
                cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
            }
        });

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == RESULT_OK) {
            if (requestCode == livenessesViewModel.getLivenessHelper().REQUEST_CODE_VERIFICATION) {

                livenessesViewModel.getLivenessHelper().handleZoomResults(IdenfyController.getInstance().getSettings().getToken(), data);
            }
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (IdenfyController.getInstance().getSettings().getCustomLocale() != null) {
            Configuration config = this.getResources().getConfiguration();
            Locale locale = new Locale(IdenfyController.getInstance().getSettings().getCustomLocale());
            Locale.setDefault(locale);
            config.locale = locale;
            this.getBaseContext().getResources().updateConfiguration(config,
                    this.getBaseContext().getResources().getDisplayMetrics());
        } else {
            this.getBaseContext().getResources().updateConfiguration(newConfig,
                    this.getBaseContext().getResources().getDisplayMetrics());
        }
    }


    private void observeIsPartnerSelectedZoom() {
        cameraViewModel.getPartnerInfoLiveData().observe(this, response ->
        {
            if (response != null && response.status == Status.SUCCESS) {
                if (response.data != null) {
                    {
                    }
                    if (response.data.getZoomLiveliness()) {
                        cameraViewModel.hasPartnerEnabledZoom = true;
                        setupZoomLiveness();
                    }


                }
            }
        });
    }

    public void setupZoomLiveness() {

        if (livenessesViewModel.getLivenessHelper() != null) {
            livenessesViewModel.getLivenessHelper().preloadZoomResources(this);
            livenessesViewModel.getLivenessHelper().initialiazeZoomSdk(this, ContextCompat.getColor(this,
                    R.color.idenfyColorPrimary), ContextCompat.getColor(this,
                    R.color.idenfyColorAccent), R.drawable.idenfy_logo, SharedPrivateKey, "dcoAJszvM4HYA1py8LfYM6Gdr1CQSKkH",
                    IdenfyController.getInstance().getSettings().getIdenfyUISettings().getIdenfyLivenessUISettings());
        }
    }

    private static final String SharedPrivateKey =
            "-----BEGIN PUBLIC KEY-----\n" +
                    "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyzEyODb/p3inHAP5S4kp\n" +
                    "BTcwOdM39eI7Fmw4e1ZFako+cBTbkoSdfyHQjguVr2LPHe/bhzFZ1E5X/hdoUHd+\n" +
                    "rBQUtVu9mCAgDoBOgknDqej/5iXSR3o4UL7WdiIsr7pEWbFnTRSH8hcygBC1F4oh\n" +
                    "lshUbrGczhfCpx19L9OP7e5/jisTltVWYN4JHY/Jk4lw9qes+B7ds8DSny4xKHv3\n" +
                    "B0Ebc9SXoYB1b/ibfrlYYKtZGFhbuLEMxuNuzt9o/cj6INykiNVXkI9xBGJIRor3\n" +
                    "N8s4z8wdAkU/TBzwmKh1NC0sWDPynt6YfU5Gtdi5RSFnBdD9joDhCSCYEZ4eqXXz\n" +
                    "rwIDAQAB\n" +
                    "-----END PUBLIC KEY-----\n";


    private void setupRestoredValues() {

        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings.getCustomFontPath() != null) {

            Typeface customFont = null;
            try {
                customFont = Typeface.createFromAsset(getApplicationContext().getAssets(), idenfySettings.getCustomFontPath());
                idenfySettings.setCustomTypeface(customFont);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

    }

    private void observeInitialAgreementFragment() {
        cameraViewModel.addInitialAgreementFragmentLiveData().observe(this, canAdd ->
        {
            if (canAdd != null) {
                if (canAdd) {
                    if (toolbarTitle != null)
                        toolbarTitle.setText(getResources().getString(R.string.start_identity_verification));
                    addInitialAgrrementFragment();

                } else {

                    removeInitialAgrrementFragment();
                    if (toolbarTitle != null)
                        toolbarTitle.setText("iDenfy");
                }
            }
        });
    }

    public void removeCameraFragment() {
        Fragment cameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        if (cameraFragment != null) {
            LoggingHelper.FrgamentsInfo("removingCameraFragment");
            getSupportFragmentManager().beginTransaction().remove(cameraFragment).commit();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        LoggingHelper.onStart(CameraPreviewActivity.class.getSimpleName());


    }

    @Override
    protected void onResume() {
        super.onResume();

        if (atomicBoolean.get()) {
            authenticationResultsHandler.postDelayed(runnable, 3000);
        }

    }


    public void startCheckingForAuthenticationResultsNew() {
        AuthTokenRequest streamPost = new AuthTokenRequest();
        streamPost.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<AuthenticationResultResponseInternal> authenticationResultResponseCall =
                RetrofitFactory.create().checkAuthenticationStatus(streamPost);

        authenticationResultResponseCall.enqueue(new Callback<AuthenticationResultResponseInternal>() {

            @Override
            public void onResponse(@NonNull Call<AuthenticationResultResponseInternal> call, @NonNull Response<AuthenticationResultResponseInternal> response) {
                if (response.isSuccessful()) {

                    AuthenticationResultResponseInternal authenticationResultResponse = response.body();
                    if (authenticationResultResponse != null) {
                        if (authenticationResultResponse.getProcessingStatus() == null) {
                            atomicBoolean.set(false);

                            authenticationResultsHandler.removeCallbacksAndMessages(null);
                            cameraViewModel.setIdenfyError((new IdenfyError(
                                    new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                            .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                            getApplication().getResources()
                                                    .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                    true)));
                            return;

                        }

                        if (!authenticationResultResponse.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
                            if (!ifHandlerRunning.get()) {
                                authenticationResultsHandler.postDelayed(runnable, 3000);
                                ifHandlerRunning.set(true);
                            }
                        } else {
                            cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.success(authenticationResultResponse));
                            if (authenticationResultResponse.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
                                atomicBoolean.set(false);
                                authenticationResultsHandler.removeCallbacksAndMessages(null);

                            }
                        }
                    } else {
                        atomicBoolean.set(false);
                        authenticationResultsHandler.removeCallbacksAndMessages(null);
                        cameraViewModel.setIdenfyError(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                    }


                } else {
                    atomicBoolean.set(false);
                    authenticationResultsHandler.removeCallbacksAndMessages(null);
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                mJson = parser.parse(errorBody.string());
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                cameraViewModel.setIdenfyError(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                cameraViewModel.setIdenfyError(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        cameraViewModel.setIdenfyError(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }


            @Override
            public void onFailure(@NonNull Call<AuthenticationResultResponseInternal> call, @NonNull Throwable t) {

                cameraViewModel.setIdenfyError(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));

            }
        });
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
        if (mReturningWithResult) {
            if (this.selectedDocument != null) {
                observeIfCanSetupCameraFragment();
                cameraViewModel.setDocumentType(this.selectedDocument);
                mReturningWithResult = false;
            }
        }
    }

    @Override
    protected void onStop() {
        authenticationResultsHandler.removeCallbacksAndMessages(null);
        super.onStop();

        LoggingHelper.onStop(CameraPreviewActivity.class.getSimpleName());

    }

    private void removeFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment == null) {
            removeFragmentsForRestarting();
            isOnPausedCalled = false;
            cameraViewModel.isRecyclerViewEnabled = true;
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (cameraViewModel.isViewModelCreated) {
            cameraViewModel.isViewModelCreated = false;
        }
        LoggingHelper.logInfo("onPause", CameraPreviewActivity.class.getSimpleName());
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment == null) {
            if (!isOnPausedCalled) {
                isOnPausedCalled = true;
            }
            if (cameraPermissionWasRequested) {
            }
            if (getApplicationContext() != null)
                deleteCache(getApplicationContext());

        }
        removeFragment();


    }


    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (cameraViewModel.getIdenfyError().getValue() != null) {
            IdenfyError idenfyError = cameraViewModel.getIdenfyError().getValue();
            outState.putParcelable(this.idenfyError, idenfyError);

        }
        Resource<AuthenticationResultResponseInternal> authenticationResultResponse = cameraViewModel.authenticationResultResponseLiveData.getValue();
        if (authenticationResultResponse != null) {
            if (authenticationResultResponse.data != null) {
                outState.putParcelable(authneticationResultResponse, authenticationResultResponse.data);
            }
        }
        outState.putParcelable(settings, IdenfyController.getInstance().getSettings());
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onDestroy() {
        if (recyclerView != null) {
            recyclerView.setAdapter(null);
            recyclerView.setLayoutManager(null);
            recyclerView.addItemDecoration(null);
            recyclerView = null;
        }

        if (errorHandler != null)
            errorHandler.removeCallbacksAndMessages(null);
        if (splashScreenLoading != null) {
            splashScreenLoading.removeCallbacksAndMessages(null);
        }
        if (successHandler != null)
            successHandler.removeCallbacksAndMessages(null);
        if (authenticationResultsHandler != null) {
            authenticationResultsHandler.removeCallbacksAndMessages(null);
        }
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        if (item.getItemId() == android.R.id.home) {
            onBackPressed(); // close this activity and return to preview activity (if there is any)
        }
        return true;
    }

    Toolbar toolbar;

    private void initializeUI(Bundle savedInstanceState) {
        toolbarTitle = findViewById(R.id.toolbar_title);
        selectDocumentType = findViewById(R.id.select_document_type);
        appBarLayout = findViewById(R.id.app_bar_layout);
        if (toolbarTitle != null)
            toolbarTitle.setText(R.string.toolbar_menu_title);

        backButton = findViewById(R.id.backImage);
        if (backButton != null)
            backButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
        if (cameraViewModel.isViewModelCreated) {
            addSplashScreenFragment();
        }
        toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        Objects.requireNonNull(getSupportActionBar()).setElevation(4);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        getSupportActionBar().setTitle("");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_NOSENSOR);
        setTheme(R.style.IdenfyTheme);
        initRecyclerView();
        setupCustomDesign();
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });


    }

    private void setupCustomDesign() {
        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings != null) {
            setupFonts();
            enableActionBar(idenfySettings.getActionBarEnabled());
        }
    }

    private void enableActionBar(Boolean isActionBarEnabled) {
        appBarLayout.setVisibility(isActionBarEnabled ? View.VISIBLE : View.GONE);

    }

    private void setupFonts() {
        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings != null) {
            if (selectDocumentType != null)
                selectDocumentType.setTypeface((idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)));
            if (toolbarTitle != null)
                toolbarTitle.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
        }
    }

    private void addSplashScreenFragment() {
        Fragment authenticationResultFragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
        if (authenticationResultFragment == null) {
            LoggingHelper.FrgamentsInfo("addingSplash");
            SplashScreenFragment cameraNewFragment = new SplashScreenFragment();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.newMain, cameraNewFragment, SPLASH_SCREEN_FRAGMENT)
                    .commit();
        }
    }

    private void observeCountriesList() {
        cameraViewModel.getCountryFromIPLiveDataAndDecideToShowFragment().observe(this, response ->
        {
            cameraViewModel.getCountriesListMutableLiveData().observe(this, countriesList ->
            {
                if (response != null) {
                    Country firstCountry = null;
                    int sameIndex = 0;
                    if (response.status == Status.SUCCESS) {
                        if (countriesList != null && countriesList.status == Status.SUCCESS) {

                            for (int i = 0; i < Objects.requireNonNull(countriesList.data).size(); i++) {
                                if (countriesList.data.get(i).getCountryISO().
                                        equalsIgnoreCase(response.data)) {
                                    firstCountry = countriesList.data.get(i);
                                    sameIndex = i;

                                }
                                if (firstCountry != null) {
                                    countriesList.data.add(0, firstCountry);
                                    countriesList.data.remove(sameIndex + 1);
                                    break;
                                }
                            }
                            cameraViewModel.setCountriesList(countriesList);
                        }
                    }
                    if (response.status == Status.ERROR) {
                        if (countriesList != null)
                            cameraViewModel.setCountriesList(countriesList);
                    }
                }
            });
        });
    }


    private boolean checkIfNewVersionOfInitialization() {
        if (IdenfyController.getInstance().getSettings().isWithStaticListener()) {
            return true;
        }
        return false;
    }

    private boolean isSavedInstance;

    private void restoreAppAfterDeath(Bundle savedInstanceState) {

        if (savedInstanceState != null) {
            setupCustomLocale();
            isSavedInstance = true;
            if (!cameraViewModel.isViewModelCreated) {
                return;
            }
            if (savedInstanceState.getParcelable(idenfyError) != null) {
                IdenfyError idenfyError = savedInstanceState.getParcelable(this.idenfyError);
                if (idenfyError != null) {
                    if (IdenfyController.getInstance().getSettings().isWithActivityResults()) {
                        Intent intent = new Intent();
                        intent.putExtra(IdenfyController.ON_ERROR, idenfyError.getIdenfyErrorResponse());
                        setResult(IdenfyController.ERROR_CODE, intent);
                        finish();
                    } else if (checkIfNewVersionOfInitialization()) {

                        IdenfyController.idenfyError = idenfyError.getIdenfyErrorResponse();
                        deleteCache(CameraPreviewActivity.this);
                        finish();
                    }
                }

            }
            if (savedInstanceState.getParcelable(authneticationResultResponse) != null) {
                AuthenticationResultResponseInternal authenticationResultResponse = savedInstanceState.getParcelable(authneticationResultResponse);
                if (authenticationResultResponse != null && authenticationResultResponse.getIdentificationStatus().equalsIgnoreCase(IdenfyIdentificationStatus.APPROVED.getStatus())) {
                    cameraViewModel.setIdentificationSuccessResponse(authenticationResultResponse);
                } else {
                    cameraViewModel.savedIdentificationResultResponse = authenticationResultResponse;
                }

            }
            if (savedInstanceState.getParcelable(settings) != null) {
                IdenfyController.getInstance().setSettings(Objects.requireNonNull(savedInstanceState.getParcelable(settings)));
                if (IdenfyController.getInstance().getSettings().isWithActivityResults()) {
                    initialRequests(true, savedInstanceState);
                } else if (checkIfNewVersionOfInitialization()) {
                    initialRequests(true, savedInstanceState);
                } else if (!checkIfNewVersionOfInitialization()) {
                    deleteCache(this);
                    finish();
                }
            }

        } else {
            isSavedInstance = false;
            initialRequests(false, savedInstanceState);
        }
    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {

            atomicBoolean.set(true);
            ifHandlerRunning.set(false);
            startCheckingForAuthenticationResultsNew();
        }
    };
    AtomicBoolean atomicBoolean = new AtomicBoolean(false);
    AtomicBoolean ifHandlerRunning = new AtomicBoolean(false);

    private void observeProccessUploadCompletion() {
        cameraViewModel.getStartedProcessingLiveData().observe(this, uploadCompleted ->
        {
            if (uploadCompleted != null) {
                if (uploadCompleted.status == Status.SUCCESS)

                    atomicBoolean.set(true);
                if (!ifHandlerRunning.get()) {
                    authenticationResultsHandler.postDelayed(runnable, 9000);
                    ifHandlerRunning.set(true);
                }
            }
        });
    }

    private void setupCustomLocale() {
        if (IdenfyController.getInstance().getSettings().getCustomLocale() != null) {
            Configuration config = this.getResources().getConfiguration();
            Locale locale = new Locale(IdenfyController.getInstance().getSettings().getCustomLocale());
            Locale.setDefault(locale);
            config.locale = locale;
            this.getBaseContext().getResources().updateConfiguration(config,
                    this.getBaseContext().getResources().getDisplayMetrics());
        }
    }

    private void initialRequests(boolean isSavedInstance, Bundle savedInstanceState) {
        setupCustomLocale();
        if (!cameraViewModel.isViewModelCreated) {
            return;
        }
        if (IdenfyController.getInstance().getSettings() == null) {
            IdenfyController.exitCode = new ExitCode(1);
            deleteCache(CameraPreviewActivity.this);
            finish();
            return;
        }
        setupRestoredValues();
        fetchCountriesList();
        cameraViewModel.fetchDocumentTypes();
        cameraViewModel.fetchPartnerInfo();
        cameraViewModel.fetchCountryByIp();
        if (isSavedInstance) {
        } else {
            cameraViewModel.setDeviceTypeForAPI();
        }
        if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment()) {
        } else {
            if (isSavedInstance) {
                cameraViewModel.getRepository().setCountryTriggerDone();
                cameraViewModel.getRepository().startSessionTriggerDone();
                cameraViewModel.startSessionMutableLIveData.setValue(Resource.success(null));
            } else {
//                cameraViewModel.getRepository().startSessionTriggerDone();
//                cameraViewModel.getRepository().setCountryTriggerDone();
//                cameraViewModel.startSessionMutableLIveData.postValue(Resource.success(true));
               cameraViewModel.startSession();
                if (IdenfyController.getInstance().getSettings().getIssuingCountry() != null) {
                    cameraViewModel.setCountryForDocumentRequest(IdenfyController.getInstance().getSettings().getIssuingCountry());
                }
                cameraViewModel.setCountrySelectionAvailabilityMutableLiveData(false);
            }
        }


    }


    private void observeCameraFragment() {
        cameraViewModel.getAddCameraFragment().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    if (aBoolean) {
                        if (cameraViewModel.getDocumentTypeMutableLiveData().getValue() != null &&
                                cameraViewModel.getDocumentTypeMutableLiveData().getValue() != UploadDocumentPhotoType.FACE_PHOTO)
                            addCameraFragment();

                    } else {
                        removeCameraFragment();
                    }
            }
        });
    }

    private void observeAuthenticationResultFragment() {
        cameraViewModel.getAuthenticationResultFragmentLiveData().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (response) {
                        CameraPreviewActivity.this.addAuthenticationResultFragment();
                    } else {
                        removeAuthenticationResultFragment();
                    }
                }
            }
        });
    }


    private void observeSdkInitialLoading() {
        cameraViewModel.mainLoadingMediatorLiveData.observe(this, response ->
        {
            if (response != null && response.status == Status.SUCCESS) {


                if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment()) {
                    if ((response.data != null) && response.data.containsKey(loadingLiveDataAuthTokenKey)
                            && response.data.get(loadingLiveDataAuthTokenKey)
                            && response.data.containsKey(loadingLiveDataFirstCountryKey) &&
                            response.data.get(loadingLiveDataFirstCountryKey) && response.data.containsKey("DocumentTypes")
                            && response.data.get("DocumentTypes")) {
                        if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                            cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                        cameraViewModel.setInitialLoadingDataHasLoaded(true);
                        removeSplashScreenFragment();


                    }
                } else {
                    if (isSavedInstance) {
                        if (response.data != null &&
                                response.data.containsKey(loadingLiveDataAuthTokenKey) &&
                                response.data.get(loadingLiveDataAuthTokenKey) && response.data.containsKey("DocumentTypes")
                                && response.data.get("DocumentTypes") && response.data.containsKey(loadingLiveDataFirstCountryKey) &&
                                response.data.get(loadingLiveDataFirstCountryKey)) {
                            if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                                cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                            cameraViewModel.setInitialLoadingDataHasLoaded(true);
                            removeSplashScreenFragment();
                        }
                    } else {
                        if (response.data != null &&
                                response.data.containsKey(loadingLiveDataAuthTokenKey) &&
                                response.data.get(loadingLiveDataAuthTokenKey) && response.data.containsKey("DocumentTypes")
                                && response.data.get("DocumentTypes") && response.data.containsKey(loadingLiveDataFirstCountryKey)
                                && response.data.get(loadingLiveDataFirstCountryKey)
                                && response.data.containsKey(cameraViewModel.startSessionLoadingKey) &&
                                response.data.get(cameraViewModel.startSessionLoadingKey)) {
                            if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                                cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                            cameraViewModel.setInitialLoadingDataHasLoaded(true);
                            removeSplashScreenFragment();
                        }
                    }

                }

            }
        });
    }

    private void handleIdenfyError(IdenfyError error) {

        if (cameraViewModel.savedIdentificationResultResponse != null) {
            cameraViewModel.setIdentificationSuccessResponse(cameraViewModel.savedIdentificationResultResponse);
            return;
        }
        if (error == null) {
            return;
        }
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfyIdentificationResultsSettings idenfyIdentificationResultsSettings = IdenfyController.getInstance().getSettings().getIdenfyIdentificationResultsSettings();
            if (!idenfyIdentificationResultsSettings.isErrorResultsViewVisible()) {
                IdenfyErrorResponse idenfyErrorResponse = error.getIdenfyErrorResponse();
                Intent intent = new Intent();
                intent.putExtra(IdenfyController.ON_ERROR, idenfyErrorResponse);
                setResult(IdenfyController.ERROR_CODE, intent);
                deleteCache(CameraPreviewActivity.this);
                finish();
                return;
            }
        }
        if (error.getSeconds() != 0) {
            idenfyErrorDelayClosing = error.getSeconds();
        }
        if (error.getTerminateWithoutWaitingResult()) {
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
        }


        errorHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (cameraViewModel.savedIdentificationResultResponse != null) {
                    cameraViewModel.setIdentificationSuccessResponse(cameraViewModel.savedIdentificationResultResponse);
                    return;
                }

                if (IdenfyController.getInstance().getSettings().isWithActivityResults()) {
                    IdenfyErrorResponse idenfyErrorResponse = error.getIdenfyErrorResponse();
                    Intent intent = new Intent();
                    intent.putExtra(IdenfyController.ON_ERROR, idenfyErrorResponse);
                    setResult(IdenfyController.ERROR_CODE, intent);
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                } else if (checkIfNewVersionOfInitialization()) {
                    IdenfyController.idenfyError = error.getIdenfyErrorResponse();
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                } else if (!checkIfNewVersionOfInitialization()) {
                    AuthentificationResult result = AuthentificationResult.ERROR;
                    result.message = error.getIdenfyErrorResponse().getMessage();
                    IdenfyController.getInstance().mListener.onAutentification(result);
                    finish();
                }
            }

        }, idenfyErrorDelayClosing);
    }

    private void observeSDKResponse() {
        cameraViewModel.getIdenfyError().observe(this, this::handleIdenfyError);
        cameraViewModel.identificationSuccessResponse.observe(this, response ->
        {
            if (response != null) {

                if (IdenfyController.getInstance().getSettings() != null) {
                    IdenfyIdentificationResultsSettings idenfyIdentificationResultsSettings = IdenfyController.getInstance().getSettings().getIdenfyIdentificationResultsSettings();
                    if (!idenfyIdentificationResultsSettings.isSuccessResultsViewVisible()) {
                        Intent intent = new Intent();

                        intent.putExtra(IdenfyController.ON_AUTHENTICATION_RESULT, resultsFormattingHelper.getFormattedAuthenticationResponse(response));
                        setResult(IdenfyController.AUTHENTICATION_RESULT_CODE, intent);
                        deleteCache(CameraPreviewActivity.this);
                        finish();
                        return;
                    }
                }
                successHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (IdenfyController.getInstance().getSettings().isWithActivityResults()) {
                            Intent intent = new Intent();
                            intent.putExtra(IdenfyController.ON_AUTHENTICATION_RESULT, resultsFormattingHelper.getFormattedAuthenticationResponse(response));
                            setResult(IdenfyController.AUTHENTICATION_RESULT_CODE, intent);
                            deleteCache(CameraPreviewActivity.this);
                            finish();
                            return;
                        } else if (checkIfNewVersionOfInitialization()) {
                            IdenfyController.authenticationResultResponse = resultsFormattingHelper.getFormattedAuthenticationResponse(response);
                            deleteCache(CameraPreviewActivity.this);
                            finish();
                            return;
                        } else if (!checkIfNewVersionOfInitialization()) {
                            deleteCache(CameraPreviewActivity.this);
                            IdenfyController.getInstance().mListener.onAutentification(AuthentificationResult.SUCCESS);
                            finish();
                            return;
                        }
                    }

                }, idenfySuccessDelayClosing);
            }
        });
    }

    private void showsnackBar(String message) {
        Snackbar mySnackbar = Snackbar.make(findViewById(R.id.newMain),
                message, Snackbar.LENGTH_SHORT);
        mySnackbar.show();
    }

    private void removeInitialAgrrementFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (fragment != null) {
            cameraViewModel.isRecyclerViewEnabled = true;
            LoggingHelper.FrgamentsInfo("removingInitialAgre");
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }

    }


    private void removeSplashScreenFragment() {


        splashScreenLoading.postDelayed(new Runnable() {
            @Override
            public void run() {
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
                if (fragment != null) {
                    if (IdenfyController.getInstance().getSettings() != null)
                        if (!IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                            cameraViewModel.isRecyclerViewEnabled = true;
                    LoggingHelper.FrgamentsInfo("removingsplash");
                    getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
                }
            }
        }, 300);

    }

    private void addInitialAgrrementFragment() {
        Fragment initialAgreementFragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (initialAgreementFragment == null) {
            LoggingHelper.FrgamentsInfo("addingInitial");
            InitialAgreementFragmnet cameraNewFragment = new InitialAgreementFragmnet();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.setupContainer, cameraNewFragment, INITIAL_AGREEMENT_FRAGMENT)
                    .commit();
        }
    }


    AlertDialog restartAuthenticationDialog;

    private void showRestartAuhenticationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.start_over_alert_title);
        builder.setMessage(R.string.start_over_alert_message);
        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });
        builder.setNegativeButton(getResources().getString(R.string.yes_alert_button),
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        cameraViewModel.clearCompositiveDisposable();
                        cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.loading(null));
                        removeAllFragmentsForRestarting();
                        cameraViewModel.isRecyclerViewEnabled = true;
                        dialog.dismiss();
                    }
                });
        restartAuthenticationDialog = builder.create();
        restartAuthenticationDialog.show();
        restartAuthenticationDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
        restartAuthenticationDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }

    private void removeFragmentsForRestarting() {
        cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
        cameraViewModel.setAddCameraFragment(false);

    }

    private void removeAllFragmentsForRestarting() {
        cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
        cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false);
        cameraViewModel.setaddFacePhotoResultFragment(false);
        cameraViewModel.setAddFaceCameraFragment(false);
        cameraViewModel.setAddCameraFragment(false);
    }

    AlertDialog closeAppAlertDialog;

    private void showCloseAppAlertDialog() {


        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.abort_identification_alert_title);
        builder.setMessage(R.string.abort_identification_alert_message);

        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });

        builder.setNegativeButton(R.string.yes_alert_button, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                if (cameraViewModel.savedIdentificationResultResponse != null) {
                    cameraViewModel.setIdentificationSuccessResponse(cameraViewModel.savedIdentificationResultResponse);
                    return;
                }
                if (IdenfyController.getInstance().getSettings().isWithActivityResults()) {
                    Intent intent = new Intent();
                    ExitCode exitCode = new ExitCode(1);
                    intent.putExtra(IdenfyController.ON_USER_EXIT, (Parcelable) exitCode);
                    setResult(IdenfyController.USER_EXIT_CODE, intent);
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                } else if (checkIfNewVersionOfInitialization()) {
                    ExitCode exitCode = new ExitCode(1);
                    IdenfyController.exitCode = new ExitCode(1);
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                    dialog.dismiss();
                } else if (!IdenfyController.getInstance().getSettings().isWithStaticListener()) {
                    deleteCache(CameraPreviewActivity.this);
                    IdenfyController.getInstance().mListener.onAutentification(AuthentificationResult.CANCEL);
                    finish();
                }
            }
        });
        closeAppAlertDialog = builder.create();
        closeAppAlertDialog.show();
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }


    public boolean getCameraPermission() {
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            cameraPermissionWasRequested = true;
            requestCameraPermission();
            return false;
        } else {
            return true;
        }
    }


    private void requestCameraPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                Manifest.permission.CAMERA)) {
            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                    new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        } else {

            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        }
    }

    public static void deleteCache(Context context) {
    }

    AppBarLayout appBarLayout;

    private void initRecyclerView() {
        recyclerView = findViewById(R.id.documentsRecyclerView);
        final Context context = CameraPreviewActivity.this;
        LinearLayoutManager manager = new LinearLayoutManager(this);
        recyclerView.setLayoutManager(manager);
    }

    private void observeDocumentsTypes() {
        cameraViewModel.getDocumentTypes().observe(this, response ->
        {
            if (response != null) {
                DocumentsRecyclerViewAdapter adapter = new DocumentsRecyclerViewAdapter(
                        response, this, this,
                        (IdenfyController.getInstance().getSettings().getIdenfyFont(FontEnum.DEFAULT)));

                recyclerView.setAdapter(adapter);
            }
        });
    }


    private boolean addCameraFragment() {
        boolean isFragmentNew = false;

        Fragment fragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        if (fragment == null) {
            //  LoggingHelper.FrgamentsInfo("addingCamera");
            isFragmentNew = true;
            DocumentsCameraSessionFragment documentsCameraSessionFragment = new DocumentsCameraSessionFragment();
            getSupportFragmentManager().
                    beginTransaction().replace(R.id.newMain, documentsCameraSessionFragment, CAMERA_NEW_FRAGMENT)
                    .commit();
        }
        return isFragmentNew;
    }


    public void selectDocument(DocumentTypeClass document) {
        selectedDocument = document;
        if (getCameraPermission()) {
            observeIfCanSetupCameraFragment();
            cameraViewModel.setDocumentType(document);


        } else {
            isDocumentItemPressed = false;
            if (wasPermissionRequested) {
                showsnackBar(getResources().getString(R.string.provide_permissions_manually));
            }
        }
    }

    private void observeIfCanSetupCameraFragment() {
        cameraViewModel.getSetDocumentTypeResponseMutableLiveData().observe(this, responseBodyResource -> {
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.LOADING) {

                } else if (responseBodyResource.status == Status.SUCCESS) {
                    cameraViewModel.setCurrentDocumentLiveData(this.selectedDocument);

                    setupFlowOfUploadings(cameraViewModel.currentDocumentClass);

                    setupViewToGetPhoto();

                } else if (responseBodyResource.status == Status.ERROR) {
                }

            }
        });

    }

    public void setupFlowOfUploadings(DocumentTypeClass documentTypeClass) {
        cameraViewModel.currentDocumentClass.resetCurrentStep();
        cameraViewModel.setupUploadStatuses(documentTypeClass);
        if (documentTypeClass.getUploadPhotoStep() == UploadDocumentPhotoType.FACE_PHOTO) {
            cameraViewModel.setIsBackFotoapparatCamera(false);
        } else {
            cameraViewModel.setIsBackFotoapparatCamera(true);
        }
        cameraViewModel.setDocumentInfo(setupInitialDocument(documentTypeClass));
    }


    private DocumentWrapper setupInitialDocument(DocumentTypeClass document) {

        UploadDocumentPhotoType uploadDocumentPhotoType = cameraViewModel.getUploadDocumentPhotoType();
        DocumentWrapper documentWrapper = new DocumentWrapper(
                uploadDocumentPhotoType,
                true, false,
                false,
                true,
                false,
                false,
                false,
                true,
                false
                , false,
                true
                , true
        );
        return documentWrapper;
    }

    private void setupViewToGetPhoto() {
        cameraViewModel.setAddCameraFragment(true);
        isDocumentItemPressed = false;
    }

    public void removeAuthenticationResultFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment != null) {
            LoggingHelper.FrgamentsInfo("removingAuth");
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }
    }

    private boolean isIdentificationRestartReady() {
        return cameraViewModel.authenticationResultResponseLiveData.getValue() != null &&
                cameraViewModel.authenticationResultResponseLiveData.getValue().data != null &&
                cameraViewModel.authenticationResultResponseLiveData.getValue().status != Status.LOADING &&
                cameraViewModel.authenticationResultResponseLiveData.getValue().data.getProcessingStatus() != null &&
                cameraViewModel.authenticationResultResponseLiveData.getValue().data.getProcessingStatus().
                        equalsIgnoreCase("FINISHED");
    }

    @Override
    public void onBackPressed() {

        Fragment fragmentAuth = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        Fragment cameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        Fragment splashScreenFragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
        Fragment documentPhotoResultFragment = getSupportFragmentManager().findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT);
        Fragment facePhotoResultFragment = getSupportFragmentManager().findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT);
        Fragment faceSessionFragment = getSupportFragmentManager().findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT);
        if (fragmentAuth != null) {
            if (isIdentificationRestartReady()) {
                showRestartAuhenticationDialog();
            }
            return;
        }
        if (documentPhotoResultFragment != null) {
            showRestartAuhenticationDialog();
            return;
        }
        if (facePhotoResultFragment != null) {
            showRestartAuhenticationDialog();
            return;
        }
        if (faceSessionFragment != null) {
            showRestartAuhenticationDialog();
            return;
        }
        if (cameraFragment != null) {
            showRestartAuhenticationDialog();
            return;
        }
        if (splashScreenFragment != null) {
            return;
        }
        showCloseAppAlertDialog();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_PERMISSIONS_CAMERA) {
            if (permissions.length > 0) {
                if (permissions[0].equals(Manifest.permission.CAMERA)
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mReturningWithResult = true;

                } else {
                    wasPermissionRequested = true;
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                                Manifest.permission.CAMERA)) {
                            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                                    new String[]{Manifest.permission.CAMERA},
                                    REQUEST_PERMISSIONS_CAMERA);
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onAuthenticationResultFragmentClosed(boolean closed) {
        removeAuthenticationResultFragment();

    }

    @Override
    public void onCameraNewFragmentClosed(boolean wasSucess) {
        onBackPressed();
    }

    @Override
    public void onFragmentInteraction(Uri uri) {

    }

    @Override
    public void onRetakeStepsList(Boolean value) {
        cameraViewModel.isRecyclerViewEnabled = false;
        cameraViewModel.handleRetakeSteps(cameraViewModel.savedIdentificationResultResponse.getRetakeSteps());
        cameraViewModel.retakeOccured = true;
        setupFlowOfUploadings(cameraViewModel.currentDocumentClass);
        cameraViewModel.clearCompositiveDisposable();
        cameraViewModel.startObservingUploads(cameraViewModel.currentDocumentClass.getUploadPhotoStepList());
        cameraViewModel.observeThenToStartProocessing();
        cameraViewModel.triggerDocumentAsSelected();
        if (cameraViewModel.currentDocumentClass.getUploadPhotoStepList().get(0) == Step.face) {
            cameraViewModel.setAddFaceCameraFragment(true);
            cameraViewModel.authenticationFragmentOpenMutableLiveData.setValue(false);
        } else {

            cameraViewModel.setAddCameraFragment(true);
            cameraViewModel.authenticationFragmentOpenMutableLiveData.setValue(false);
        }
    }

    public boolean areFragmentsShown() {
        boolean areFragmentsShown = false;
        Fragment faceCameraFragemnt = getSupportFragmentManager().findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT);
        Fragment facePhotoResultFragment = getSupportFragmentManager().findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT);
        Fragment documentCameraFragment = getSupportFragmentManager().findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT);
        Fragment documentssessionCameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        Fragment authentication = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (faceCameraFragemnt != null || facePhotoResultFragment != null
                || documentCameraFragment != null || documentssessionCameraFragment != null || authentication != null) {
            areFragmentsShown = true;
        }
        return areFragmentsShown;
    }

    @Override
    public void onClick(DocumentTypeClass type) {
        {
            if (cameraViewModel.isRecyclerViewEnabled) {
                if (areFragmentsShown()) {
                    return;
                }
                if (!isDocumentItemPressed) {
                    isDocumentItemPressed = true;
                    cameraViewModel.retakeOccured = false;
                    CameraPreviewActivity.this.selectDocument(type);
                }
            }
        }

    }


}

