package com.idenfy.idenfySdk.UI.AuthenticationResultView

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.net.Uri
import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v4.app.FragmentActivity
import android.support.v4.content.ContextCompat
import android.support.v7.app.AlertDialog
import android.support.v7.app.AppCompatDelegate
import android.support.v7.widget.AppCompatImageView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView

import com.bumptech.glide.Glide
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyIdentificationResultsSettings
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyResultsSubtitleUISettings
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment
import com.idenfy.idenfySdk.Models.DocumentTypeEnum
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.Networking.Status
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.ErrorMessage
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.helpers.IdenfyIdentificationStatus
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel
import com.idenfy.idenfySdk.helpers.ErrorsHelper
import com.idenfy.idenfySdk.helpers.LoggingHelper
import com.idenfy.idenfySdk.helpers.enums.FontEnum
import com.idenfySdk.R

import java.util.Locale
import java.util.Objects


/**
 * A simple [Fragment] subclass.
 * Activities that contain this fragment must implement the
 * [OnFragmentInteractionListener] interface
 * to handle interaction events.
 * Use the [AuthenticationResultFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
//   HorizontalStepView horizontalStepView;

class AuthenticationResultFragment : ViewLifecycleFragment() {

    // TODO: Rename and change types of parameters
    private var mParam1: String? = null
    private var mParam2: String? = null

    private var mFragmentClosedListener: OnAuthenticationResultFragmentClosed? = null
    private var retakeStepsListListener: RetakeStepsListListener? = null
    private var cameraViewModel: CameraViewModel? = null
    private var buttonClicked: Boolean = false
    private var btnClose: Button? = null

    internal var backPhotoPlaceHolder: ImageView? = null
    internal var frontPhotoPlaceHolder: ImageView? = null
    internal var facePhotoPlaceHolder: ImageView? = null
    internal var backProgressBar: ProgressBar? = null
    internal var faceProgressBar: ProgressBar? = null
    internal var frontProgressBar: ProgressBar? = null
    internal var customLoadingProgressSpinner: ImageView? = null
    internal var customResultsImageView: AppCompatImageView? = null
    private var authenticationStatusTextView: TextView? = null
    private var descriptionTextView: TextView? = null
    private var materialProgressBar: ProgressBar? = null
    private var tvFrontInfo: TextView? = null
    private var tvBackInfo: TextView? = null
    private var tvFaceInfo: TextView? = null

    private var identificationStatusSubtitle: TextView? = null

    var rewievingStatusDialog: AlertDialog? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)
        super.onCreate(savedInstanceState)
        if (arguments != null) {
            mParam1 = arguments!!.getString(ARG_PARAM1)
            mParam2 = arguments!!.getString(ARG_PARAM2)
        }
    }

    var authenticationResultsObserver = Observer<Resource<AuthenticationResultResponseInternal>> { response ->

        if (response != null) {
            if (response.status == Status.LOADING) {
                handleSubtitle(response.status, IdenfyController.getInstance().settings.idenfyUISettings.idenfyIdentificationResultsUISettings.idenfyResultsSubtitleUISettings)
                startProgressIndicators()
            } else if (response!!.status == Status.SUCCESS) {

                if (response!!.data != null) {
                    handleStepsLoading(response!!.data!!)
                    if (response!!.data!!.getProcessingStatus() != null && response!!.data!!.getProcessingStatus().equals("FINISHED", ignoreCase = true)) {

                        cameraViewModel!!.savedIdentificationResultResponse = response!!.data
                        if (!response!!.data!!.getIdentificationStatus().equals(IdenfyIdentificationStatus.REVIEWING.status, ignoreCase = true))
                            handleFinishedLoading(response!!.data!!)
                        if (materialProgressBar != null)
                            materialProgressBar!!.visibility = View.INVISIBLE
                        if (response!!.data!!.getIdentificationStatus() != null) {
                            handleIdentificationStatus(response!!.data!!, IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings, IdenfyController.getInstance().settings.idenfyUISettings.idenfyIdentificationResultsUISettings.idenfyResultsSubtitleUISettings)
                        }

                    }
                }
            }
        }

    }
    var idenfyErrorObserver =
            Observer<IdenfyError> { response ->

                if (response != null) {
                    if (IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                        showIdenfyError(ErrorsHelper.getErrrorMessageFromIdentifier(Objects.requireNonNull<FragmentActivity>(activity), response!!.getIdenfyErrorResponse().getIdentifier()))
                    }
                }

            }


    private fun initializeUI(view: View) {
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder)
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar)
        customLoadingProgressSpinner = view.findViewById(R.id.custom_loading_spinner)
        customResultsImageView = view.findViewById(R.id.custom_results_image_view)
        tvBackInfo = view.findViewById(R.id.back_photo_text_view)
        tvFrontInfo = view.findViewById(R.id.front_document_text_view)
        tvFaceInfo = view.findViewById(R.id.face_photo_text_view)
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder)
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder)
        authenticationStatusTextView = view.findViewById(R.id.titleTextView)
        descriptionTextView = view.findViewById(R.id.descriptionTextView)
        backProgressBar = view.findViewById(R.id.progressBarBack)
        faceProgressBar = view.findViewById(R.id.progressBarFace)
        frontProgressBar = view.findViewById(R.id.progressBarFront)
        btnClose = view.findViewById(R.id.btnClose)
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder)
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar)
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder)
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder)
        authenticationStatusTextView = view.findViewById(R.id.titleTextView)
        descriptionTextView = view.findViewById(R.id.descriptionTextView)
        backProgressBar = view.findViewById(R.id.progressBarBack)
        faceProgressBar = view.findViewById(R.id.progressBarFace)
        frontProgressBar = view.findViewById(R.id.progressBarFront)
        if (faceProgressBar != null)
            faceProgressBar!!.visibility = View.VISIBLE
        btnClose = view.findViewById(R.id.btnClose)
        btnClose!!.visibility = View.INVISIBLE
    }


    private fun observeAuthenticationResponse() {
        cameraViewModel!!.authenticationResultResponseLiveData.observe(viewLifecycleOwner!!, authenticationResultsObserver)
    }

    private fun handleFinishedLoading(data: AuthenticationResultResponseInternal) {
        if (data.retakeSteps.front == null) {
            if (frontProgressBar != null) {
                if (frontProgressBar!!.visibility == View.VISIBLE) {
                    frontProgressBar!!.visibility = View.INVISIBLE
                }
                if (frontPhotoPlaceHolder != null)
                    frontPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
            }
        }
        if (data.retakeSteps.back == null) {
            if (backProgressBar != null) {
                if (backProgressBar!!.visibility == View.VISIBLE) {
                    backProgressBar!!.visibility = View.INVISIBLE
                }
                if (backPhotoPlaceHolder != null)
                    backPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)

            }
        }
        if (data.retakeSteps.face == null) {
            if (faceProgressBar != null) {
                if (faceProgressBar!!.visibility == View.VISIBLE) {
                    faceProgressBar!!.visibility = View.INVISIBLE
                }
                if (facePhotoPlaceHolder != null)
                    facePhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
            }
        }

    }

    private fun handleIdentificationStatus(response: AuthenticationResultResponseInternal, idenfyIdentificationResultsSettings: IdenfyIdentificationResultsSettings, idenfyResultsSubtitleUISettings: IdenfyResultsSubtitleUISettings) {
        if (response.identificationStatus.equals(IdenfyIdentificationStatus.APPROVED.status, ignoreCase = true)) {
            if (idenfyIdentificationResultsSettings.isSuccessResultsViewVisible) {
                handleSubtitle(Status.SUCCESS, idenfyResultsSubtitleUISettings)
                showSuccess("")
            }
            cameraViewModel!!.setIdentificationSuccessResponse(response)
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.DENIED.status, ignoreCase = true)) {
            val sDefSystemLanguage = Locale.getDefault().language
            if (response.errorMessage != null) {
                if (idenfyIdentificationResultsSettings.isRetryErrorResultsViewVisible) {
                    handleSubtitle(Status.ERROR, idenfyResultsSubtitleUISettings)
                    handleErrorMessage(sDefSystemLanguage, response.errorMessage, response)
                } else {
                    cameraViewModel!!.setIdentificationSuccessResponse(response)
                }
            }
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.SUSPECTED.status, ignoreCase = true)) {
            if (idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                authenticationStatusTextView!!.setText(R.string.data_failed)
                handleSubtitle(Status.SUCCESS, idenfyResultsSubtitleUISettings)
            }
            cameraViewModel!!.setIdentificationSuccessResponse(response)
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.REVIEWING.status, ignoreCase = true)) {
            showCloseAppAlertDialog(response)
        } else {
            cameraViewModel!!.savedIdentificationResultResponse = null
            if (idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                handleSubtitle(Status.ERROR, idenfyResultsSubtitleUISettings)
                authenticationStatusTextView!!.setText(R.string.data_failed)
            }
            cameraViewModel!!.setIdenfyError(IdenfyError(IdenfyErrorResponse(activity!!.application.applicationContext.resources
                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                    activity!!.application.resources
                            .getString(R.string.MALFORMED_JSON_MESSAGE))))

        }

    }

    private fun showCloseAppAlertDialog(response: AuthenticationResultResponseInternal) {

        if (activity == null) {
            return
        }
        val builder = AlertDialog.Builder(activity!!)

        builder.setTitle(activity!!.resources.getString(R.string.manual_reviewing_informion_title))
        builder.setMessage(activity!!.resources.getString(R.string.manual_reviewing_information_message))

        builder.setPositiveButton(activity!!.resources.getString(R.string.thank_repeat)) { dialog, which ->
            makeProgressBarsInvisible()
            cameraViewModel!!.identificationSuccessResponse.value = response
            dialog.dismiss()
        }
        rewievingStatusDialog = builder.create()
        rewievingStatusDialog?.show()
        rewievingStatusDialog?.setCancelable(false)
        rewievingStatusDialog?.getButton(AlertDialog.BUTTON_POSITIVE)?.setTextColor(resources.getColor(R.color.idenfyColorAccent))
    }

    private fun observeIdenfyError() {
        cameraViewModel!!.getIdenfyError().observe(viewLifecycleOwner!!, idenfyErrorObserver)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        var view: View? = null

        if (!IdenfyController.getInstance().settings.isCustomIdentificationLayout) {

            if (cameraViewModel!!.currentDocumentClass == null) {
                view = inflater.inflate(R.layout.authentication_resut_with_steps_id, container, false)
            } else {
                if (cameraViewModel!!.currentDocumentClass.documentTypeEnum == DocumentTypeEnum.PASSPORT || cameraViewModel!!.currentDocumentClass.documentTypeEnum == DocumentTypeEnum.DRIVER_LICENSE) {
                    view = inflater.inflate(R.layout.authentication_resut_with_steps_passport, container, false)
                } else {
                    view = inflater.inflate(R.layout.authentication_resut_with_steps_id, container, false)
                }
            }
        } else {
            view = inflater.inflate(R.layout.fragment_identification_results_custom_view, container, false)
            identificationStatusSubtitle = view.findViewById(R.id.idenfy_identification_results_subtitle)
        }
        initializeUI(view!!)
        return view
    }


    private fun handleStepsLoading(data: AuthenticationResultResponseInternal) {
        if (data.retakeSteps.front != null && !data.retakeSteps.front) {

            if (frontProgressBar != null)
                frontProgressBar!!.visibility = View.INVISIBLE
            if (frontPhotoPlaceHolder != null)
                frontPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        }
        if (data.retakeSteps.front != null && data.retakeSteps.front!!) {
            if (frontProgressBar != null)
                frontProgressBar!!.visibility = View.INVISIBLE
            if (frontPhotoPlaceHolder != null)
                frontPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_success)
        }
        if (data.retakeSteps.face != null && !data.retakeSteps.face) {
            if (faceProgressBar != null)
                faceProgressBar!!.visibility = View.INVISIBLE
            if (facePhotoPlaceHolder != null)
                facePhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        }
        if (data.retakeSteps.face != null && data.retakeSteps.face!!) {
            if (faceProgressBar != null)
                faceProgressBar!!.visibility = View.INVISIBLE
            if (facePhotoPlaceHolder != null)
                facePhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_success)
        }
        if (data.retakeSteps.back != null && !data.retakeSteps.back) {
            if (backProgressBar != null)
                backProgressBar!!.visibility = View.INVISIBLE
            if (backPhotoPlaceHolder != null)
                backPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        }
        if (data.retakeSteps.back != null && data.retakeSteps.back!!) {
            if (backProgressBar != null)
                backProgressBar!!.visibility = View.INVISIBLE
            if (backPhotoPlaceHolder != null)
                backPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_success)
        }

    }

    fun handleSubtitle(status: Status, subtitleUISettings: IdenfyResultsSubtitleUISettings) {
        if (status == Status.LOADING) {

            identificationStatusSubtitle?.text = subtitleUISettings.loadingSubtitle
            if (subtitleUISettings.isVisibleOnLoading)
                identificationStatusSubtitle?.visibility = View.VISIBLE
            else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        } else if (status == Status.SUCCESS) {
            identificationStatusSubtitle?.text = subtitleUISettings.successSubtitle
            if (subtitleUISettings.isVisibleOnSuccess) {
                identificationStatusSubtitle?.visibility = View.VISIBLE
            } else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        } else if (status == Status.ERROR) {
            identificationStatusSubtitle?.text = subtitleUISettings.errorSubtitle
            if (subtitleUISettings.isVisibleOnError)
                identificationStatusSubtitle?.visibility = View.VISIBLE
            else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        }
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        observeAuthenticationResponse()
        observeIdenfyError()
        cameraViewModel!!.setNextButtonVisibility(true)
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            descriptionTextView!!.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            authenticationStatusTextView!!.typeface = idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)
            if (tvBackInfo != null)
                tvBackInfo!!.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            if (tvFrontInfo != null)
                tvFrontInfo!!.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            if (tvFaceInfo != null)
                tvFaceInfo!!.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)

        }
    }

    fun startProgressIndicators() {
        if (customLoadingProgressSpinner != null) {
            if (IdenfyController.getInstance().settings.customResultsViewSpinner != null) {
                try {
                    Glide.with(Objects.requireNonNull<FragmentActivity>(activity))
                            .load(IdenfyController.getInstance().settings.customResultsViewSpinner)
                            .into(customLoadingProgressSpinner!!)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        if (backProgressBar != null) {
            backProgressBar!!.visibility = View.VISIBLE
        }
        if (frontProgressBar != null)
            frontProgressBar!!.visibility = View.VISIBLE
        if (faceProgressBar != null)
            faceProgressBar!!.visibility = View.VISIBLE


    }

    fun showSuccess(response: String) {
        authenticationStatusTextView!!.text = resources.getString(R.string.data_approved)
        cameraViewModel!!.setAuthenticationSuccessForClosing(true)
        if (customResultsImageView != null && customLoadingProgressSpinner != null) {
            customLoadingProgressSpinner!!.visibility = View.INVISIBLE
            customResultsImageView!!.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull<FragmentActivity>(activity), R.drawable.ic_checked))

        }
    }

    override fun onStart() {
        super.onStart()
        LoggingHelper.FrgamentsInfo("onStartAuthenticationResults")
    }

    override fun onStop() {
        super.onStop()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }

    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.FrgamentsInfo("onDestroyidentificationResultsFragment")
    }
    override fun onDestroyView() {
        super.onDestroyView()
    }

    fun showError(response: String, authenticationResultResponse: AuthenticationResultResponseInternal) {

        if (customResultsImageView != null)
            customResultsImageView!!.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull<FragmentActivity>(activity), R.drawable.ic_idenfy_spinner_error))
        if (customLoadingProgressSpinner != null)
            customLoadingProgressSpinner!!.visibility = View.INVISIBLE

        btnClose!!.visibility = View.VISIBLE
        btnClose!!.setText(R.string.thank_repeat)
        authenticationStatusTextView!!.setText(R.string.data_failed)
        descriptionTextView!!.visibility = View.VISIBLE
        descriptionTextView!!.text = response
        btnClose!!.setOnClickListener(View.OnClickListener {
            buttonClicked = true
            if (!IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings.isRetryingIdentificationAvailable) {
                cameraViewModel!!.setIdentificationSuccessResponse(authenticationResultResponse)
                return@OnClickListener
            }
            if (authenticationResultResponse.attemptsLeft.equals("0", ignoreCase = true)) {
                if (activity != null)
                    cameraViewModel!!.setIdenfyError(IdenfyError(IdenfyErrorResponse(activity!!.resources
                            .getString(R.string.TOO_MANY_REATTEMPTS_IDENTIFIER),
                            activity!!.resources
                                    .getString(R.string.TOKEN_NOT_VALID_MESSAGE)),
                            false))
                return@OnClickListener
            } else {
                if (retakeStepsListListener != null) {
                    retakeStepsListListener!!.onRetakeStepsList(true)
                }
            }
        })
    }

    private fun makeProgressBarsInvisible() {
        if (backProgressBar != null)
            backProgressBar!!.visibility = View.INVISIBLE
        if (frontProgressBar != null)
            frontProgressBar!!.visibility = View.INVISIBLE
        if (faceProgressBar != null)
            faceProgressBar!!.visibility = View.INVISIBLE
    }

    fun showIdenfyError(response: String) {
        if (customResultsImageView != null)
            customResultsImageView!!.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull<FragmentActivity>(activity), R.drawable.ic_pause_button))
        if (customLoadingProgressSpinner != null)
            customLoadingProgressSpinner!!.visibility = View.INVISIBLE
        makeProgressBarsInvisible()
        btnClose!!.visibility = View.INVISIBLE
        if (materialProgressBar != null)
            materialProgressBar!!.visibility = View.INVISIBLE
        if (facePhotoPlaceHolder != null)
            facePhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        if (backPhotoPlaceHolder != null)
            backPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        if (frontPhotoPlaceHolder != null)
            frontPhotoPlaceHolder!!.setImageResource(R.drawable.ic_idenfy_spinner_error)
        authenticationStatusTextView!!.setText(R.string.data_failed)
        descriptionTextView!!.visibility = View.VISIBLE
        descriptionTextView!!.text = response
    }

    override fun onPause() {
        super.onPause()
    }

    private fun handleErrorMessage(sDefSystemLanguage: String, errorMessage: ErrorMessage, response: AuthenticationResultResponseInternal) {
        when (sDefSystemLanguage) {
            "en" -> showError(errorMessage.en, response)
            "lt" -> showError(errorMessage.lt, response)
            "ru" -> showError(errorMessage.ru, response)
            "pl" -> showError(errorMessage.pl, response)
            else -> showError(errorMessage.en, response)
        }
    }

    override fun onAttach(context: Context?) {
        if (context is OnAuthenticationResultFragmentClosed) {
            mFragmentClosedListener = context
        }
        if (context is RetakeStepsListListener) {
            retakeStepsListListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }


    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     *
     *
     * See the Android Training lesson [Communicating with Other Fragments](http://developer.android.com/training/basics/fragments/communicating.html) for more information.
     */
    interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        fun onFragmentInteraction(uri: Uri)
    }

    interface OnAuthenticationResultFragmentClosed {
        // TODO: Update argument type and name
        fun onAuthenticationResultFragmentClosed(closed: Boolean)
    }

    interface RetakeStepsListListener {
        // TODO: Update argument type and name
        fun onRetakeStepsList(value: Boolean?)
    }

    companion object {
        // TODO: Rename parameter arguments, choose names that match
        // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
        private val ARG_PARAM1 = "param1"
        private val ARG_PARAM2 = "param2"

        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param param1 Parameter 1.
         * @param param2 Parameter 2.
         * @return A new instance of fragment AuthenticationResultFragment.
         */
        // TODO: Rename and change types and number of parameters
        fun newInstance(param1: String, param2: String): AuthenticationResultFragment {
            val fragment = AuthenticationResultFragment()
            val args = Bundle()
            args.putString(ARG_PARAM1, param1)
            args.putString(ARG_PARAM2, param2)
            fragment.arguments = args
            return fragment
        }
    }
}// Required empty public constructor
