package com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class AuthenticationResultResponseInternal implements Parcelable {
    @SerializedName("processingStatus")
    @Expose
    private String processingStatus;
    @SerializedName("attemptsLeft")
    @Expose
    private String attemptsLeft;
    @SerializedName("documentSupported")
    @Expose
    private String documentSupported;
    @SerializedName("identificationStatus")
    @Expose
    private String identificationStatus;
    @SerializedName("countryMatch")
    @Expose
    private String countryMatch;
    @SerializedName("errorMessage")
    @Expose
    private ErrorMessage errorMessage;
    @SerializedName("mrzFound")
    @Expose
    private String mrzFound;
    @SerializedName("retakeSteps")
    @Expose
    private RetakeSteps retakeSteps;
    @SerializedName("zoomLiveliness")
    @Expose
    private String zoomLiveliness;

    protected AuthenticationResultResponseInternal(Parcel in) {
        processingStatus = in.readString();
        attemptsLeft = in.readString();
        documentSupported = in.readString();
        identificationStatus = in.readString();
        countryMatch = in.readString();
        errorMessage = in.readParcelable(ErrorMessage.class.getClassLoader());
        mrzFound = in.readString();
        retakeSteps = in.readParcelable(RetakeSteps.class.getClassLoader());
        zoomLiveliness = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(processingStatus);
        dest.writeString(attemptsLeft);
        dest.writeString(documentSupported);
        dest.writeString(identificationStatus);
        dest.writeString(countryMatch);
        dest.writeParcelable(errorMessage, flags);
        dest.writeString(mrzFound);
        dest.writeParcelable(retakeSteps, flags);
        dest.writeString(zoomLiveliness);
    }

    @Override
    public String toString() {
        return "AuthenticationResultResponseInternal{" +
                "processingStatus='" + processingStatus + '\'' +
                ", attemptsLeft='" + attemptsLeft + '\'' +
                ", documentSupported='" + documentSupported + '\'' +
                ", identificationStatus='" + identificationStatus + '\'' +
                ", countryMatch='" + countryMatch + '\'' +
                ", errorMessage=" + errorMessage +
                ", mrzFound='" + mrzFound + '\'' +
                ", retakeSteps=" + retakeSteps +
                ", zoomLiveliness='" + zoomLiveliness + '\'' +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AuthenticationResultResponseInternal> CREATOR = new Creator<AuthenticationResultResponseInternal>() {
        @Override
        public AuthenticationResultResponseInternal createFromParcel(Parcel in) {
            return new AuthenticationResultResponseInternal(in);
        }

        @Override
        public AuthenticationResultResponseInternal[] newArray(int size) {
            return new AuthenticationResultResponseInternal[size];
        }
    };

    public String getProcessingStatus() {
        return processingStatus;
    }

    public void setProcessingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
    }

    public String getAttemptsLeft() {
        return attemptsLeft;
    }

    public void setAttemptsLeft(String attemptsLeft) {
        this.attemptsLeft = attemptsLeft;
    }

    public String getDocumentSupported() {
        return documentSupported;
    }

    public void setDocumentSupported(String documentSupported) {
        this.documentSupported = documentSupported;
    }

    public String getIdentificationStatus() {
        return identificationStatus;
    }

    public void setIdentificationStatus(String identificationStatus) {
        this.identificationStatus = identificationStatus;
    }

    public String getCountryMatch() {
        return countryMatch;
    }

    public void setCountryMatch(String countryMatch) {
        this.countryMatch = countryMatch;
    }

    public ErrorMessage getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getMrzFound() {
        return mrzFound;
    }

    public void setMrzFound(String mrzFound) {
        this.mrzFound = mrzFound;
    }

    public RetakeSteps getRetakeSteps() {
        return retakeSteps;
    }

    public void setRetakeSteps(RetakeSteps retakeSteps) {
        this.retakeSteps = retakeSteps;
    }

    public String getZoomLiveliness() {
        return zoomLiveliness;
    }

    public void setZoomLiveliness(String zoomLiveliness) {
        this.zoomLiveliness = zoomLiveliness;
    }


}