package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;

import com.idenfy.idenfyliveness.IdenfyLivenessHelper;


public class IdenfyUISettings implements Parcelable {

    private Integer customResultsViewSpinner = null;
    private boolean isActionBarEnabled = true;
    private String customFontPath;

    private com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings;

    private IdenfyIdentificationResultsUISettings idenfyIdentificationResultsUISettings = new IdenfyIdentificationResultsUISettings();


    protected IdenfyUISettings(Parcel in) {
        if (in.readByte() == 0) {
            customResultsViewSpinner = null;
        } else {
            customResultsViewSpinner = in.readInt();
        }
        isActionBarEnabled = in.readByte() != 0;
        customFontPath = in.readString();
        idenfyIdentificationResultsUISettings = in.readParcelable(IdenfyIdentificationResultsUISettings.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (customResultsViewSpinner == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(customResultsViewSpinner);
        }
        dest.writeByte((byte) (isActionBarEnabled ? 1 : 0));
        dest.writeString(customFontPath);
        dest.writeParcelable(idenfyIdentificationResultsUISettings, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IdenfyUISettings> CREATOR = new Creator<IdenfyUISettings>() {
        @Override
        public IdenfyUISettings createFromParcel(Parcel in) {
            return new IdenfyUISettings(in);
        }

        @Override
        public IdenfyUISettings[] newArray(int size) {
            return new IdenfyUISettings[size];
        }
    };

    public Integer getCustomResultsViewSpinner() {
        return customResultsViewSpinner;
    }

    public void setCustomResultsViewSpinner(Integer customResultsViewSpinner) {
        this.customResultsViewSpinner = customResultsViewSpinner;
    }

    public boolean isActionBarEnabled() {
        return isActionBarEnabled;
    }

    public void setActionBarEnabled(boolean actionBarEnabled) {
        isActionBarEnabled = actionBarEnabled;
    }

    public void setIdenfyLivenessUISettings(com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings) {
        this.idenfyLivenessUISettings = idenfyLivenessUISettings;
        this.idenfyLivenessUISettings.setLightDarkModeEnabled(false);
        this.idenfyLivenessUISettings = idenfyLivenessUISettings;
    }

    public IdenfyIdentificationResultsUISettings getIdenfyIdentificationResultsUISettings() {
        return idenfyIdentificationResultsUISettings;
    }

    public String getCustomFontPath() {
        return customFontPath;
    }

    public void setCustomFontPath(String customFontPath) {
        this.customFontPath = customFontPath;
    }

    private IdenfyUISettings(IdenfyUIBuilder idenfyUIBuilder) {
        customResultsViewSpinner = idenfyUIBuilder.customResultsViewSpinner;
        isActionBarEnabled = idenfyUIBuilder.isActionBarEnabled;
        customFontPath = idenfyUIBuilder.customFontPath;
        if (idenfyUIBuilder.idenfyIdentificationResultsUISettings != null)
            idenfyIdentificationResultsUISettings = idenfyUIBuilder.idenfyIdentificationResultsUISettings;
    }

    public com.idenfy.idenfyliveness.IdenfyLivenessUISettings getIdenfyLivenessUISettings() {
        return idenfyLivenessUISettings;
    }

    IdenfyUISettings() {

    }

    public static class IdenfyUIBuilder {
        private boolean optionalResultsChecking = false;
        private boolean setupAgreementFragment = true;
        private Typeface font;
        private Typeface fontBold;
        private String customFontPath;
        private Integer customBackgroundPath = -1;
        private Integer customResultsViewSpinner = null;
        private boolean isActionBarEnabled = true;
        private com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings;
        private IdenfyIdentificationResultsUISettings idenfyIdentificationResultsUISettings;


        public IdenfyUIBuilder withTypefacePath(String pathOfTypeface) {
            this.customFontPath = pathOfTypeface;
            return this;
        }

        public IdenfyUIBuilder withCustomLoadingView(Integer customLoadingView) {
            this.customResultsViewSpinner = customLoadingView;
            return this;
        }

        public IdenfyUIBuilder withLivenessUISettings(com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings) {
            this.idenfyLivenessUISettings = idenfyLivenessUISettings;
            return this;
        }


        public IdenfyUIBuilder withAppBarLayoutEnabled(boolean isActionBarEnabled) {
            this.isActionBarEnabled = isActionBarEnabled;
            return this;
        }

        public IdenfyUIBuilder withCustomIdentificationResultsUISettings(IdenfyIdentificationResultsUISettings identificationResultsUISettings) {
            this.idenfyIdentificationResultsUISettings = identificationResultsUISettings;
            return this;
        }

        public IdenfyUISettings build() {
            IdenfyUISettings idenfyUISettings = new IdenfyUISettings(this);
            try {
                Class.forName("com.idenfy.idenfyliveness.IdenfyLivenessUISettings");
                if (idenfyLivenessUISettings != null)
                    idenfyUISettings.setIdenfyLivenessUISettings(idenfyLivenessUISettings);
            } catch (Throwable var2) {
            }
            return idenfyUISettings;
        }

    }
}


