package com.idenfy.idenfySdk.helpers

import android.app.Activity
import android.app.PendingIntent.getActivity
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType
import com.idenfySdk.R

class IdentificationStepsTitlesHelper {
    fun getPhotoResultTitleText(documentType: UploadDocumentPhotoType, activity: Activity): String {
        var photoResultTitleText: String? = null

        when (documentType) {
            UploadDocumentPhotoType.ID_CARD_FRONT -> photoResultTitleText = activity.getResources().getString(R.string.show_pictured_document_bottom_passport_text)
            UploadDocumentPhotoType.PASSPORT -> photoResultTitleText = activity.getResources().getString(R.string.show_pictured_document_bottom_passport_text)
            UploadDocumentPhotoType.ID_CARD_BACK -> photoResultTitleText = activity.getResources().getString(R.string.show_pictured_document_bottom_card_back_text)
            UploadDocumentPhotoType.FACE_PHOTO -> photoResultTitleText = activity.getResources().getString(R.string.document_face_photo_result)
            else -> photoResultTitleText = activity.getResources().getString(R.string.show_pictured_document_information_text_default)
        }
        return photoResultTitleText.toString()
    }
}
