package com.idenfy.idenfySdk.UI.InitialAgreementView;

import android.annotation.SuppressLint;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatImageView;
import android.text.Html;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountriesSelectionFragment;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link InitialAgreementFragmnet.OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link InitialAgreementFragmnet#newInstance} factory method to
 * create an instance of this fragment.
 */
public class InitialAgreementFragmnet extends ViewLifecycleFragment {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;
    ArrayList<Country> countriesList;
    ConstraintLayout countriesSpinnerLayout;
    CameraViewModel cameraViewModel;
    AppCompatButton countriesSelectionButton;

    private OnFragmentInteractionListener mListener;
    protected SparseArray<ArrayList<Country>> mCountriesMap = new SparseArray<ArrayList<Country>>();
    private CountriesSelectionFragment countriesSelectionFragment;
    private String countryFromIdString;
    private AppCompatButton submitOkButton;
    private AppCompatImageView bottomCountriesArrow;
    private String COUNTRIES_SELECTION_DIALOG_FRAGMENT = "COUNTRIES_SELECTION_DIALOG_FRAGMENT";

    CheckBox checkBox, checkBox2;
    private View rootView;
    TextView termsAndConditions, issuingCountry;


    public InitialAgreementFragmnet() {
        // Required empty public constructor
    }

    // TODO: Rename and change types and number of parameters
    public static InitialAgreementFragmnet newInstance(String param1, String param2) {
        InitialAgreementFragmnet fragment = new InitialAgreementFragmnet();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        cameraViewModel = ViewModelProviders.of(getActivity()).get(CameraViewModel.class);
        cameraViewModel.setInitialAgreementButtonAvailability(false);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    private void handleCountryNameAndFlagUI() {
        cameraViewModel.getSelectedCountryLiveData().observe(this, response ->
        {
            if (response != null) {
                setupCountryValue(response);
            }

        });
    }

    private void setupCountryValue(Country response) {
        countriesSelectionButton.setCompoundDrawablesWithIntrinsicBounds(response.getResId(), 0, 0, 0);
        countriesSelectionButton.setText(response.getName());
        cameraViewModel.countrySelected = true;
        if (cameraViewModel.checkBoxChecked && cameraViewModel.
                check2BoxChecked)
            cameraViewModel.setInitialAgreementButtonAvailability(true);
        else
            cameraViewModel.setInitialAgreementButtonAvailability(false);
    }

    @SuppressLint("RestrictedApi")
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            submitOkButton.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            checkBox.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT)));
            checkBox2.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT)));
            countriesSelectionButton.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            issuingCountry.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            termsAndConditions.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
        }
        observeCountriesSelectionAvailability();
        countriesSelectionButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FragmentManager fm = Objects.requireNonNull(getActivity()).getSupportFragmentManager();
                Fragment fragment = fm.findFragmentByTag(COUNTRIES_SELECTION_DIALOG_FRAGMENT);
                if (fragment == null) {
                    FragmentTransaction ft = fm.beginTransaction();
                    countriesSelectionFragment = CountriesSelectionFragment.newInstance();
                    countriesSelectionFragment.setTargetFragment(InitialAgreementFragmnet.this,
                            5);
                    countriesSelectionFragment.show(ft, COUNTRIES_SELECTION_DIALOG_FRAGMENT);
                }
            }

        });
        if (getActivity() != null) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_2
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_3
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementButtonColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_4
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor)),
                    getResources().getString(com.idenfySdk.R.string.initial_text_part_5
                    )));
            checkBox.setText(builder);
        }

//        Resource<String> countryFromIdResource = cameraViewModel.getCountryFromIPLiveDataAndDecideToShowFragment().getValue();
//        if (countryFromIdResource != null && countryFromIdResource.status == Status.SUCCESS) {
//            countryFromIdString = countryFromIdResource.data;
//        }
        countriesList = new ArrayList<>();

        handleCountryNameAndFlagUI();
        //TODO changed owners livedara
        cameraViewModel.getInitialAgreementButtonAvailability().observe(getViewLifecycleOwner(), isAvailable ->
        {
            if (isAvailable != null) {
                if (isAvailable) {
                    submitOkButton.setEnabled(true);
                    submitOkButton.setBackgroundColor(getResources().getColor(R.color.idenfyColorAccent));
                    submitOkButton.setSupportBackgroundTintList(ContextCompat.getColorStateList(getContext(),
                            R.color.idenfyColorAccent));
                } else {
                    submitOkButton.setBackgroundColor(getResources().getColor(R.color.colorAccentIdenfyDarkgrey));
                    submitOkButton.setSupportBackgroundTintList(ContextCompat.getColorStateList(getContext(),
                            R.color.colorAccentIdenfyDarkgrey));
                }
            }
        });
        cameraViewModel.getDismissCountryDialogLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (response) {
                    countriesSelectionFragment = (CountriesSelectionFragment) getActivity().getSupportFragmentManager().findFragmentByTag(COUNTRIES_SELECTION_DIALOG_FRAGMENT);
                    if (countriesSelectionFragment != null) {
                        countriesSelectionFragment.dismiss();
                        countriesSelectionFragment = null;
                    } else {
                    }
                }
            }


        });
        cameraViewModel.getInitialFragmentClosingLiveData().observe(getViewLifecycleOwner(), responseBodyResource ->
        {
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.SUCCESS) {
                    cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(false);
                }
            }
        });
        checkBox2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                cameraViewModel.check2BoxChecked = isChecked;
                if (cameraViewModel.checkBoxChecked && cameraViewModel.countrySelected && cameraViewModel.
                        check2BoxChecked)
                    cameraViewModel.setInitialAgreementButtonAvailability(true);
                else
                    cameraViewModel.setInitialAgreementButtonAvailability(false);
            }
        });
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                cameraViewModel.checkBoxChecked = isChecked;
                if (cameraViewModel.checkBoxChecked && cameraViewModel.countrySelected && cameraViewModel.
                        check2BoxChecked)
                    cameraViewModel.setInitialAgreementButtonAvailability(true);
                else
                    cameraViewModel.setInitialAgreementButtonAvailability(false);
            }
        });
        submitOkButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Boolean isAvailable = cameraViewModel.getInitialAgreementButtonAvailability().getValue();
                {
                    if (isAvailable != null) {

                        if (isAvailable) {
                            IdenfyController.getInstance().getSettings().setSetupAgreementFragment(false);
                            createRequestForSettingCountry();
                            cameraViewModel.startSession();
                        } else {
                            if (!cameraViewModel.countrySelected) {
                                Snackbar mySnackbar = Snackbar.make(rootView,
                                        R.string.select_your_document_issuing_country_message, Snackbar.LENGTH_SHORT);
                                mySnackbar.show();
                            } else {
                                if (!checkBox.isSelected() || !checkBox2.isSelected()) {
                                    Snackbar mySnackbar = Snackbar.make(rootView,
                                            R.string.agree_with_terms_of_service_message, Snackbar.LENGTH_SHORT);
                                    mySnackbar.show();
                                }
                            }
                        }
                    }
                }
            }
        });
        observePartnerInfo();
    }

    private void observePartnerInfo() {
        cameraViewModel.getPartnerInfoLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null && response.data != null && response.status == Status.SUCCESS) {

                if (response.data.getCountry() != null) {
                    cameraViewModel.setCountrySelectionAvailabilityMutableLiveData(false);
                    bottomCountriesArrow.setVisibility(View.INVISIBLE);
                    cameraViewModel.getCountriesListMutableLiveData().observe(getViewLifecycleOwner(), countriesList ->
                    {
                        for (Country country : Objects.requireNonNull(Objects.requireNonNull(cameraViewModel.getCountriesListMutableLiveData().getValue()).data)) {
                            if (country.getCountryISO().
                                    equalsIgnoreCase(response.data.getCountry())) {
                                setupCountryValue(country);
                            }
                        }
                    });

                } else {
                    cameraViewModel.setCountrySelectionAvailabilityMutableLiveData(true);
                }
                if (response.data.getCountriesBlacklist() != null && !response.data.getCountriesBlacklist().isEmpty()) {
                    cameraViewModel.getCountriesListMutableLiveData().observe(getViewLifecycleOwner(), countriesList ->
                    {

                        if (countriesList != null && countriesList.data != null) {
                            List<Country> blackListed = new ArrayList<>();
                            for (String s : response.data.getCountriesBlacklist()) {
                                Country country = new Country(s);
                                blackListed.add(country);
                            }
                            countriesList.data.removeAll(blackListed);
                            cameraViewModel.setCountriesList(countriesList);
                        }
                    });
                }
            }
        });
    }


    private void createRequestForSettingCountry() {
        cameraViewModel.getPartnerInfoLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (response.status == Status.SUCCESS) {
                    if (response.data != null) {
                        if (response.data.getCountry() != null) {

                            // cameraViewModel.setCountryForDocument(response.data.getCountry());
                        } else {
                            cameraViewModel.setCountryForDocument(cameraViewModel.getSelectedCountryLiveData().getValue());
                        }
                    }
                } else {
                    cameraViewModel.setCountryForDocument(cameraViewModel.getSelectedCountryLiveData().getValue());
                }
            }
        });

    }

    private void observeCountriesSelectionAvailability() {
        cameraViewModel.getCountrySelectionAvailabilityMutableLiveData().observe(getViewLifecycleOwner(), isAvailable ->
        {
            if (isAvailable != null) {
                if (!isAvailable) {
                    countriesSelectionButton.setEnabled(false);
                    issuingCountry.setText(getResources().getString(R.string.select_your_document_issuing_country_message_predifined));
                }
            }
        });
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        checkBox = view.findViewById(R.id.checkBox);
        termsAndConditions = view.findViewById(R.id.terms_and_conditions);
        issuingCountry = view.findViewById(R.id.select_your_document_issuing_country);
        checkBox.setTextColor(ContextCompat.getColor(getActivity(), com.idenfySdk.R.color.idenfyInitialAgreementTitlesTextColor));
        checkBox2 = view.findViewById(R.id.checkBox2);
        checkBox2 = view.findViewById(R.id.checkBox2);
        checkBox2.setText(Html.fromHtml(getString(R.string.first_checkbox)));
        submitOkButton = view.findViewById(R.id.submitButton);
        countriesSelectionButton = view.findViewById(R.id.countries_button_selection);
        countriesSpinnerLayout = view.findViewById(R.id.countries_spinner_layout);
        bottomCountriesArrow = view.findViewById(R.id.countries_selection_arrow);

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        cameraViewModel.setDismissCountryDialogMutableLiveData(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.fragment_initial_agreement_view, container,
                false);
        return rootView;
    }

    // TODO: Rename method, update argument and hook method into UI event
    public void onButtonPressed(Uri uri) {
        if (mListener != null) {
            mListener.onFragmentInteraction(uri);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }
}
