package com.idenfy.idenfySdk.UI.DocumentPhotoResultView;


import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.ErrorsHelper;
import com.idenfy.idenfySdk.helpers.IdentificationStepsTitlesHelper;
import com.idenfy.idenfySdk.helpers.LoggingHelper;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.view.CameraView;

public class FacePhotoResultFragment extends ViewLifecycleFragment {
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    CustomFrameProcessor.OnPictureListener onPictureListener;

    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button retakeButton;
    private Button nextButton;
    ImageView backImage;
    TextView backTextView;

    private TextView imageViewResultTitle;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();

    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 200;

    LivenessesViewModel livenessesViewModel;
    //View drawings values

    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public FacePhotoResultFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);

    }

    boolean isUp;
    int rootViewHeight;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        imageViewResultTitle = rootView.findViewById(R.id.document_photo_result_text_view);
        backImage = rootView.findViewById(R.id.backImage);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        retakeButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);

    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.idenfy_face_photo_result_fragment, container, false);
        initializeUI(rootView);
        return rootView;
    }


    ConstraintLayout imageViewResultConstraintLayout;


    private void observeUI() {
        cameraViewModel.getImageViewResultTitleColorMutableLiveData().observe(getViewLifecycleOwner(), new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });

        cameraViewModel.getImageViewResult().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    if (imageViewResult != null) {
                        imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });
        cameraViewModel.getImageViewResultFullSize().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewFullScreenResult != null) {
                        imageViewFullScreenResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });

        cameraViewModel.getRecreateButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    retakeButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageInfoLayout != null)
                        imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });

        cameraViewModel.getNextButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                nextButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setupCustomUI();

    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        retakeButton.setEnabled(true);
        nextButton.setEnabled(true);
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeFaceRegular = idenfySettings.getCustomRegularFont();
            Typeface typeFaceBold = idenfySettings.getCustomBoldTypeFace();
            setupCustomTypeFace(typeFaceRegular, typeFaceBold);
        }
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        IdentificationStepsTitlesHelper identificationStepsTitlesHelper = new IdentificationStepsTitlesHelper();
        if(cameraViewModel.getUploadDocumentPhotoType()!=null)
            imageViewResultTitle.setText(identificationStepsTitlesHelper.getPhotoResultTitleText(cameraViewModel.getUploadDocumentPhotoType(), getActivity()));
        cameraViewModel.getDocumentPhotoResultLiveData().observe(getViewLifecycleOwner(), response ->
        {
            show(response.getDocumentImage(), response.getUploadPhotoType(),
                    response.getRectangleRight(), response.getRectangleLeft(), response.getRectangleBottom(), response.getRectangleTop());
        });
        cameraViewModel.setNextButtonVisibility(true);
        cameraViewModel.setRecreateButtonAvailability(true);
        cameraViewModel.setNextButtonAvailability(true);
        cameraViewModel.setRecreateButtonVisibility(true);
    }


    private void observeButtonsAvailability() {
    }


    private void retakePhotoPressed(Bitmap bitmap) {
        cameraViewModel.setTakePictureButtonAvailability(true);
        cameraViewModel.setaddFacePhotoResultFragment(false);
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        recreateImage();

    }

    private Observer<Pair<Boolean, String>> observer = new Observer<Pair<Boolean, String>>() {
        @Override
        public void onChanged(@Nullable Pair<Boolean, String> response) {
            if (response.first) {
                if (canSetup.get()) {
                    nextButton.setVisibility(View.INVISIBLE);
                    retakeButton.setVisibility(View.INVISIBLE);
                    livenessesViewModel.getLivenessHelper().startActivityForResult((CameraPreviewActivity) getActivity());
                    livenessesViewModel.getZoomInitializationResult().removeObserver(observer);
                }
            } else {
                if (getActivity() != null)
                    cameraViewModel.setIdenfyError(new IdenfyError(new IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                            getActivity().getResources()
                                    .getString(R.string.IDENFY_FACE_LIVENESS_MESSAGE)),
                            true, 1200));
            }
        }
    };
    private AtomicBoolean canSetup = new AtomicBoolean(true);

    public void show(final Bitmap bitmap, UploadDocumentPhotoType type, int rectangleRight, int rectangleLeft, int rectangleBottom, int rectangleTop) {
        cameraViewModel.setShowImageLayoutVisibility(true);
        if (imageViewFullScreenResult != null) {
            cameraViewModel.setImageViewResultFullSize(true);
            imageViewFullScreenResult.setImageBitmap(bitmap);
        }
        cameraViewModel.setTextViewOfDocumentMutableLiveData(false);
        cameraViewModel.setDocumentTutorialTitleVisibility(false);

        retakeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                retakePhotoPressed(bitmap);

            }
        });

        nextButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View view) {

                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextStep(bitmap);

            }
        });
    }


    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    public void nextStep(Bitmap bitmap) {
        if (cameraViewModel.hasPartnerEnabledZoom) {
            if (livenessesViewModel.getLivenessHelper() != null) {
                cameraViewModel.savedFacePhotoBitmap = bitmap;
                livenessesViewModel.getZoomInitializationResult().observe(getViewLifecycleOwner(), observer);
                return;
            }


        }

        cameraViewModel.decideWhichSaveBitmap(bitmap, cameraViewModel.getUploadDocumentPhotoType());
        cameraViewModel.saveFileToServer(cameraViewModel.getUploadDocumentPhotoType(), cameraViewModel.currentDocumentClass.getCurrentStepPosition());
        if (cameraViewModel.checkIfItReadyToOpenResults()) {
            cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.loading(null));
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
        } else if (cameraViewModel.checkIfItReadyToOpenFaceCamera()) {
            cameraViewModel.increaseCurrentStep();
            cameraViewModel.setAddFaceCameraFragment(true);
            cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), false);
        } else {
            cameraViewModel.increaseCurrentStep();
            cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), false);
            cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
        }
    }


    public void recreateImage() {
        cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), true);
    }


    boolean shouldOpenLiveness = true;

    @Override
    public void onPause() {
        super.onPause();
        shouldOpenLiveness = false;
        canSetup.set(false);
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onStart() {
        super.onStart();
        shouldOpenLiveness = true;
    }

    @Override
    public void onResume() {
        super.onResume();
        canSetup.set(true);

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        LoggingHelper.onDestroyView(FacePhotoResultFragment.class.getSimpleName());
        imageViewFullScreenResult = null;
        imageViewResult = null;
        imageInfoLayout = null;
        cameraView = null;

        imageViewResultTitle = null;
        nextButton = null;
        retakeButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }

    public void setupCustomTypeFace(Typeface typeface, Typeface typeFaceBold)
    {
        if(typeFaceBold==null) {
            return;
        }
        backTextView.setTypeface(typeFaceBold);
        nextButton.setTypeface(typeFaceBold);
        retakeButton.setTypeface(typeFaceBold);
        imageViewResultTitle.setTypeface(typeFaceBold);
    }
    private void setupCustomUI()
    {
        if(getActivity()==null)
        {
            return;
        }
        DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                R.color.idenfyFaceResultsCameraBackArrowColor));
        backTextView.setTextColor(getResources().getColor(R.color.idenfyFaceResultsBackTextViewColor));
        imageViewResultTitle.setTextColor(getResources().getColor(R.color.idenfyFaceResultsInformationTextViewColor));
    }


    public void onBackPressed() {
        ((CameraPreviewActivity) getActivity()).onBackPressed();

    }


}
