package com.idenfy.idenfySdk.Networking;

import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountryCode;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.Networking.Models.DocumentTypeRequest;
import com.idenfy.idenfySdk.Networking.Models.PartnerInfo;
import com.idenfy.idenfySdk.Networking.Models.SetDeviceTypeForAPI;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface APIService {

    @Headers("Content-Type: application/json")
    @POST("identification/start-process")
    Call<ResponseBody> startProcess(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Call<ResponseBody> startSession(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Observable<ResponseBody> startSessionObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("document/set")
    Observable<ResponseBody> setDocumentTypeObservable(
            @Body DocumentTypeRequest rawJson
    );


    @Headers("Content-Type: application/json")
    @POST("storage/store/stream")
    Call<ResponseBody> streamPhotoNew(
            @Body StreamPost moment
    );

    @Headers("Content-Type: application/json")
    @POST("storage/store/stream")
    Observable<ResponseBody> streamPhotoNewObservable(
            @Body StreamPost moment
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Call<AuthenticationResultResponseInternal> checkAuthenticationStatus(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Observable<Response<AuthenticationResultResponseInternal>> checkAuthenticationStatusObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/check")
    Call<ResponseBody> checkAuthToken(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("partner/info")
    Call<PartnerInfo> getPartnerInfo(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/can-retry")
    Call<ResponseBody> checkIfCanRetry(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/country")
    Call<ResponseBody> setIssuingCountry(
            @Body CountrySetRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/country")
    Observable<ResponseBody> setIssuingCountryObservable(
            @Body CountrySetRequest rawJson
    );

    @GET("other/geoip-country")
    Call<CountryCode> getCountryByIPAd(
    );

    @GET("other/geoip-country")
    Observable<Response<CountryCode>> getCountryByIPAdObservable(
    );

    @GET("document/list")
    Call<List<DocumentType>> getDocumentsTypes(
            @Query("authToken") String auhToken
    );


    @Headers("Content-Type: application/json")
    @POST("document/set")
    Call<ResponseBody> setDocumentType(
            @Body Map<String, String> rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/platform")
    Call<SetDeviceTypeForAPI> setDeviceTypeForAPI(
            @Body SetDeviceTypeForAPI deviceTypeForAPI
    );


}
