package com.idenfy.idenfySdk.UI.DocumentPhotoResultView;


import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.UI.CustomViews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.LoggingHelper;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.view.CameraView;

public class DocumentPhotoResultFragment extends ViewLifecycleFragment {

    public static final String TAG = DocumentPhotoResultFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    CustomFrameProcessor.OnPictureListener onPictureListener;

    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button retakeButton;
    private Button nextButton;
    ImageView backImage;
    TextView backTextView;

    private TextView imageViewResultTitle;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();

    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 200;

    LivenessesViewModel livenessesViewModel;
    //View drawings values

    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public DocumentPhotoResultFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);

    }

    boolean isUp;
    int rootViewHeight;

    View topIvShoulder;
    View faceShoulderOverlay;
    View bottomIvShoulder;
    RelativeLayout customShapes;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        imageViewResultTitle = rootView.findViewById(R.id.document_photo_result_text_view);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        customShapes.setVisibility(View.VISIBLE);
        backImage = rootView.findViewById(R.id.backImage);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        retakeButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        cameraViewModel.setNextButtonVisibility(true);
        cameraViewModel.setRecreateButtonAvailability(true);
        cameraViewModel.setNextButtonAvailability(true);
        cameraViewModel.setRecreateButtonVisibility(true);

    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.idenfy_document_photo_result_fragment, container, false);
        initializeUI(rootView);
        return rootView;
    }


    ConstraintLayout imageViewResultConstraintLayout;


    private void observeUI() {
        cameraViewModel.getImageViewResultTitleMutableLiveData().observe(getViewLifecycleOwner(), new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                if (imageViewResultTitle != null)
                    imageViewResultTitle.setText(s);
            }
        });
        cameraViewModel.getImageViewResult().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    if (imageViewResult != null) {
                        //imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });

        cameraViewModel.getRecreateButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    retakeButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageInfoLayout != null)
                        imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });

        cameraViewModel.getNextButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                nextButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setupLayoutUI();
        setupCustomUI();


    }


    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    private Bitmap currentImage;

    private void setupLayoutUI() {

    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        retakeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                retakePhotoPressed(currentImage);

            }
        });
        nextButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View view) {
                nextButton.setEnabled(false);
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextButtonHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {

                        nextStep(currentImage);
                    }

                }, BUTTON_DELAY_FOR_UX);
            }
        });

        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getCustomRegularFont();
            Typeface typeFaceBold = idenfySettings.getCustomBoldTypeFace();
            setupCustomTypeFace(typeface, typeFaceBold);
        }
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        cameraViewModel.getDocumentPhotoResultLiveData().observe(getViewLifecycleOwner(), response ->
        {
            currentImage = response.getDocumentImage();

            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                customViewHolder.changeTransparentBackgroundVisibility(false);
                customViewHolder.setValuesForRectangle(response.getRectangleLeft(),
                        response.getRectangleTop(),
                        response.getRectangleRight(),
                        response.getRectangleBottom());
                customViewHolder.invalidate();
            }
            show(response.getDocumentImage(), response.getUploadPhotoType(),
                    response.getRectangleRight(), response.getRectangleLeft(), response.getRectangleBottom(), response.getRectangleTop());
        });

    }

    private View getCustomShape() {
        if (customShapes != null)
            if (!(customShapes.getChildAt(0) == null)) {
                return customShapes.getChildAt(0);
            }
        return null;
    }

    private void observeButtonsAvailability() {
        cameraViewModel.getNextButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    nextButton.setEnabled(response);

                }
            }
        });
        cameraViewModel.getRecreateButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    retakeButton.setEnabled(aBoolean);
            }
        });
    }


    private void retakePhotoPressed(Bitmap bitmap) {
        cameraViewModel.setNextButtonAvailability(false);
        cameraViewModel.setRecreateButtonAvailability(false);
        cameraViewModel.setTakePictureButtonAvailability(true);
        cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
        recreateButtonHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                recreateImage();
            }

        }, BUTTON_DELAY_FOR_UX);
    }

    public void show(final Bitmap bitmap, UploadDocumentPhotoType type, int rectangleRight, int rectangleLeft, int rectangleBottom, int rectangleTop) {
        cameraViewModel.setImageViewResultTitleMutableLiveData(type);
        cameraViewModel.setImageViewResult(true);
        if (imageViewResult != null) {
            imageViewResult.setVisibility(View.VISIBLE);
            ViewGroup.LayoutParams params = imageViewResult.getLayoutParams();
            params.width = rectangleRight - rectangleLeft;
            params.height = rectangleBottom - rectangleTop;
            imageViewResult.setLayoutParams(params);
            imageViewResult.setImageBitmap(bitmap);
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    public void nextStep(Bitmap bitmap) {


        cameraViewModel.decideWhichSaveBitmap(bitmap, cameraViewModel.getUploadDocumentPhotoType());
        cameraViewModel.saveFileToServer(cameraViewModel.getUploadDocumentPhotoType(), cameraViewModel.currentDocumentClass.getCurrentStepPosition());
        if (cameraViewModel.checkIfItReadyToOpenResults()) {
            cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.loading(null));
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
        } else {
            cameraViewModel.increaseCurrentStep();
            cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), false);
            if (cameraViewModel.checkIfItReadyToOpenFaceCamera()) {
                cameraViewModel.setAddFaceCameraFragment(true);
            } else {
                cameraViewModel.addDocumentPhotoResultFragment.setValue(false);
            }
        }
    }


    public void recreateImage() {
        cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), false);
    }

    boolean shouldOpenLiveness = true;

    @Override
    public void onPause() {
        super.onPause();
        shouldOpenLiveness = false;


    }

    @Override
    public void onStop() {
        super.onStop();
        LoggingHelper.onStop(DocumentPhotoResultFragment.class.getSimpleName());


    }

    @Override
    public void onStart() {
        super.onStart();
        shouldOpenLiveness = true;
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        LoggingHelper.onDestroyView(DocumentPhotoResultFragment.class.getSimpleName());
        imageViewFullScreenResult = null;
        imageViewResult = null;
        imageInfoLayout = null;
        cameraView = null;
        imageViewResultTitle = null;
        nextButton = null;
        retakeButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }


    public void onBackPressed() {
        ((CameraPreviewActivity) getActivity()).onBackPressed();

    }
    public void setupCustomTypeFace(Typeface typeface, Typeface typeFaceBold)
    {
        if(typeFaceBold==null) {
            return;
        }
        backTextView.setTypeface(typeFaceBold);
        nextButton.setTypeface(typeFaceBold);
        retakeButton.setTypeface(typeFaceBold);
        imageViewResultTitle.setTypeface(typeFaceBold);
    }
    private void setupCustomUI()
    {
        if(getActivity()==null)
        {
            return;
        }
        backTextView.setTextColor(getResources().getColor(R.color.idenfyDocumentsResultsBackTextViewColor));
        DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                R.color.idenfyDocumentsResultsCameraBackArrowColor));
        imageViewResultTitle.setTextColor(getResources().getColor(R.color.idenfyDocumentsResultsInformationTextViewColor));
    }


}
