package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.LoggingHelper;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfySdk.R;

import java.util.Objects;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.front;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

public class FaceCameraSessionFragment extends ViewLifecycleFragment {

    public static final String TAG = FaceCameraSessionFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    LivenessesViewModel livenessesViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    CustomFrameProcessor.OnPictureListener onPictureListener;
    private AppCompatImageButton takePictureButton;
    private CustomFrameProcessor frameProcessor;

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    ImageView backImage;
    TextView backTextView;


    private CameraConfiguration cameraConfiguration;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    //Logic values
    UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 50;
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;

    // private ConstraintLayout slidingConstraintLayout;


    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public FaceCameraSessionFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (getActivity() != null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            setFotoapparatCameraSettings(frameProcessor);
        }
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
    }


    private void setFotoapparatCameraSettings(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }
    View topIvShoulder;
    View faceShoulderOverlay;
    View bottomIvShoulder;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title);


    }

    ConstraintLayout previewHolder;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.idenfy_face_camera_preview_session_fragment, container, false);
        previewHolder = rootView.findViewById(R.id.previewHolder);
        initializeUI(rootView);
        //SHOULDER_FACE_OVERLAY
        View faceOverlay = LayoutInflater.from(getActivity()).inflate(R.layout.shoulders_face_overlay, container, false);
        topIvShoulder = faceOverlay.findViewById(R.id.top_iv_shoulder);
        faceShoulderOverlay = faceOverlay.findViewById(R.id.face_shoulder_overlay);
        bottomIvShoulder = faceOverlay.findViewById(R.id.bottom_iv_shoulder);
        previewHolder.addView(faceOverlay, 4);

        return rootView;
    }

    private void observeDocumentType() {

        cameraViewModel.getDocumentTypeMutableLiveData().observe(getViewLifecycleOwner(), new Observer<UploadDocumentPhotoType>() {
            @Override
            public void onChanged(@Nullable UploadDocumentPhotoType response) {

                if (response != null) {
                    currentUploadDocumentPhotoType = response;
                    setupDocumentTitle(response);
                    setupDocumentView(response);
                    setupDocumentOverlayString(response);

                }
            }
        });
    }


    ConstraintLayout imageViewResultConstraintLayout;

    private void setupDocumentOverlayString(UploadDocumentPhotoType uploadDocumentPhotoType) {
        if (documentBorderTextView == null) {
            return;
        }
        switch (uploadDocumentPhotoType) {
            case ID_CARD_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));
                break;
            case ID_CARD_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case PASSPORT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));

        }

    }

    private void setupDocumentTitle(UploadDocumentPhotoType response) {
        Integer titleId;
        documentTitleTutorial.setVisibility(View.VISIBLE);
        if (documentTitleTutorial != null) {
            if (response != UploadDocumentPhotoType.OTHER_BACK && response != UploadDocumentPhotoType.OTHER_FRONT)
                documentTitleTutorial.setText(getDocumentInformationTitle(response));
            else {
                if (response == UploadDocumentPhotoType.OTHER_BACK)
                    documentTitleTutorial.setText(getDefaultTitle(getResources().getString(R.string.document_tutorial_title_default_part_1_back
                    )));
                if (response == UploadDocumentPhotoType.OTHER_FRONT) {
                    documentTitleTutorial.setText(getDefaultTitle(getResources().getString(R.string.document_tutorial_title_default_part_1_front
                    )));
                }
            }
        }
    }

    public String getDocumentInformationTitle(UploadDocumentPhotoType uploadDocumentPhotoType) {
        String titleName = "";
        switch (uploadDocumentPhotoType) {
            case PASSPORT:
                titleName = getResources().getString(R.string.document_type_text);
                break;
            case ID_CARD_FRONT:
                titleName = getResources().getString(R.string.document_type_id_card_front);
                break;
            case ID_CARD_BACK:
                titleName = getResources().getString(R.string.document_type_id_card_back);
                break;
            case FACE_PHOTO:
                titleName = getResources().getString(R.string.document_face_photo);
                break;


        }
        return titleName;
    }

    private void observeUI() {
        cameraViewModel.getActionButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        cameraViewModel.setTakePictureButtonAvailability(true);
        setupCustomUI();


    }

    public void setupDocumentView(@Nullable UploadDocumentPhotoType document) {
        DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                R.color.idenfyFaceSessionCameraBackArrowColor));
        backTextView.setTextColor(getResources().getColor(R.color.idenfyFaceSessionBackTextViewColor));
        setupImageView(document);


    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
    }

    private void setupCustomUI()
    {
        if (documentTitleTutorial != null && getActivity()!=null)
            documentTitleTutorial.setTextColor(ContextCompat.getColor(getActivity(), R.color.idenfyFaceCameraSessionInformationTextViewColor));
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD);
            backTextView.setTypeface(typeface);
            documentTitleTutorial.setTypeface(typeface);

        }

        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();

        observeButtonsAvailability();
        observeDocumentType();
        cameraViewModel.setTakePictureButtonAvailability(true);


    }

    private void observeButtonsAvailability() {

        cameraViewModel.getTakePictureButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupImageView(UploadDocumentPhotoType uploadDocumentPhotoType) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
        final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
        int horizontalMargin = (int) (parent.getWidth());
        int verticalMargin = (int) (parent.getHeight());
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        imageView.setLayoutParams(params);
        isShouldersViewVisibile(true);

    }

    private void isShouldersViewVisibile(Boolean visible) {
        topIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
        faceShoulderOverlay.setVisibility(visible ? View.VISIBLE : View.GONE);
        bottomIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
    }


    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                takePictureHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (getActivity() != null) {
                            takePicture();
                        }
                    }

                }, BUTTON_DELAY_FOR_UX);

            }
        });


    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new CustomFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (getActivity() != null) {
            requireActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    Bitmap result = BitmapPhotoCropper.
                            cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                    UploadDocumentPhotoType.FACE_PHOTO);
                    DocumentPhotoResult uploadDocumentPhotoType = new DocumentPhotoResult(result, cameraViewModel.getCurrentDocumentStep(), currentUploadDocumentPhotoType,
                            rectangleRight, rectangleLeft, rectangleTop, rectangleBottom);
                    cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType);
                    cameraViewModel.setaddFacePhotoResultFragment(true);
                }
            });


        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    private Integer setupTitles(UploadDocumentPhotoType uploadDocumentPhotoType) {
        Integer titleName = -1;
        switch (uploadDocumentPhotoType) {
            case PASSPORT:
                titleName = R.string.document_type_text;
                break;
            case ID_CARD_FRONT:
                titleName = R.string.document_type_id_card_front;
                break;
            case ID_CARD_BACK:
                titleName = R.string.document_type_id_card_back;
                break;
            case FACE_PHOTO:
                titleName = R.string.document_face_photo;
                break;
            default:
        }
        return titleName;
    }

    private SpannableStringBuilder getDefaultTitle(String docPart) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (getActivity() == null) {
            builder.append("");
            return builder;
        }
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_0
                )));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)), " " + docPart + " "));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_2
                )));
        return builder;
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    @Override
    public void onPause() {
        super.onPause();
        fotoapparat.stop();
    }

    @Override
    public void onStop() {
        super.onStop();
        LoggingHelper.onStop(FaceCameraSessionFragment.class.getSimpleName());
    }


    @Override
    public void onStart() {
        super.onStart();
        setupCamera();
        LoggingHelper.onStart(FaceCameraSessionFragment.class.getSimpleName());

    }

    @Override
    public void onResume() {
        super.onResume();
        cameraViewModel.setTakePictureButtonAvailability(true);
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (fotoapparat != null) {
                    fotoapparat.start();
                }

            }
        }, 20);


    }

    @Override
    public void onDestroyView() {
        LoggingHelper.onDestroyView(FaceCameraSessionFragment.class.getSimpleName());
        super.onDestroyView();
        cameraView = null;
        fotoapparat = null;
        backTextView = null;
        imageInfoLayout = null;
        documentTitleTutorial = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        takePictureHandler.removeCallbacksAndMessages(null);
    }

    public void setupCamera() {
        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            fotoapparat = Fotoapparat
                    .with(getActivity())
                    .into(cameraView)
                    .previewScaleType(ScaleType.CenterCrop)
                    .previewResolution(highestResolution())
                    .lensPosition(front())
                    .focusMode(firstAvailable(
                            continuousFocusPicture(),
                            continuousFocusVideo(),
                            autoFocus(),
                            fixed()
                    ))
                    .photoResolution(ResolutionSelectorsKt.highestResolution())
                    .frameProcessor(new CustomFrameProcessor(getActivity()))
                    .cameraErrorCallback(new CameraErrorListener() {
                        @Override
                        public void onError(@NonNull CameraException e) {
                            cameraViewModel.setAddFaceCameraFragment(false);
                        }
                    })
                    .build();

        }

    }

    public void onBackPressed() {
        ((CameraPreviewActivity) getActivity()).onBackPressed();

    }


}

