package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.UI.CustomViews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraDisplayHelpers;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.LoggingHelper;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.configuration.UpdateConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.parameter.FocusMode;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.parameter.camera.CameraParameters;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.result.WhenDoneListener;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;
import io.fotoapparat.view.FocusView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

public class DocumentsCameraSessionFragment extends ViewLifecycleFragment {

    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    LivenessesViewModel livenessesViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    CustomFrameProcessor.OnPictureListener onPictureListener;
    private FocusView fotoapparatFocusView;
    private View customFocusView;
    private AppCompatImageButton takePictureButton;
    private CustomFrameProcessor frameProcessor;

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    ImageView backImage;
    TextView backTextView;


    private CameraConfiguration cameraConfiguration;
    private RelativeLayout customShapes;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();

    Runnable focusRunnable = new Runnable() {
        @Override
        public void run() {
            if (fotoapparat != null)
                fotoapparat.getCurrentParameters().whenDone(cameraParameters -> {
                    if (cameraParameters != null)
                        if (!cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusPicture.INSTANCE) ||
                                !cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusVideo.INSTANCE)) {
                            if (fotoapparat != null) {
                                fotoapparat.updateConfiguration(
                                        UpdateConfiguration.builder().focusMode(
                                                firstAvailable(continuousFocusPicture(), continuousFocusVideo())).build());
                                canFocus.set(true);
                            }
                        }
                });
        }
    };
    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 50;
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;
    private final int rectangeMargin = 5;

    // private ConstraintLayout slidingConstraintLayout;


    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public DocumentsCameraSessionFragment() {
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (getActivity() != null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            setFotoapparatCameraSettins(frameProcessor);
        }
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);

    }


    private void setFotoapparatCameraSettins(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    boolean isUp;
    int rootViewHeight;
    View topIvShoulder;
    View faceShoulderOverlay;
    View bottomIvShoulder;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        customShapes.setVisibility(View.VISIBLE);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        fotoapparatFocusView = rootView.findViewById(R.id.fotoapparat_focus);

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title);
        if (fotoapparatFocusView != null) {
            fotoapparatFocusView.setVisibility(View.VISIBLE);
        }
        customFocusView = rootView.findViewById(R.id.custom_focus);
        DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                R.color.idenfyDocumentsCameraSessionBackArrowColor));
        backTextView.setTextColor(getResources().getColor(R.color.idenfyDocumentsCameraSessionBackTextViewColor));

    }

    private void setupCustomUI()
    {
        if (documentTitleTutorial != null && getActivity()!=null)
            documentTitleTutorial.setTextColor(ContextCompat.getColor(getActivity(), R.color.idenfyDocumentsCameraSessionInformationTextViewColor));
    }

    ConstraintLayout previewHolder;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.idenfy_camera_preview_session_fragment, container, false);
        previewHolder = rootView.findViewById(R.id.previewHolder);
        initializeUI(rootView);
        View faceOverlay = LayoutInflater.from(getActivity()).inflate(R.layout.shoulders_face_overlay, container, false);
        topIvShoulder = faceOverlay.findViewById(R.id.top_iv_shoulder);
        faceShoulderOverlay = faceOverlay.findViewById(R.id.face_shoulder_overlay);
        bottomIvShoulder = faceOverlay.findViewById(R.id.bottom_iv_shoulder);
        previewHolder.addView(faceOverlay, 4);

        return rootView;
    }

    private void observeDocumentType() {

        cameraViewModel.getDocumentTypeMutableLiveData().observe(getViewLifecycleOwner(), new Observer<UploadDocumentPhotoType>() {
            @Override
            public void onChanged(@Nullable UploadDocumentPhotoType response) {

                if (response != null) {
                    currentUploadDocumentPhotoType = response;
                    setupDocumentTitle(response);
                    setupDocumentView(response);
                    setupDocumentOverlayString(response);

                }
            }
        });


    }


    ConstraintLayout imageViewResultConstraintLayout;

    private void setupDocumentOverlayString(UploadDocumentPhotoType uploadDocumentPhotoType) {
        if (documentBorderTextView == null) {
            return;
        }
        switch (uploadDocumentPhotoType) {
            case ID_CARD_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));
                break;
            case ID_CARD_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case PASSPORT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));

        }

    }

    private void setupDocumentTitle(UploadDocumentPhotoType response) {
        Integer titleId;
        if (documentTitleTutorial != null) {
            if (response != UploadDocumentPhotoType.OTHER_BACK && response != UploadDocumentPhotoType.OTHER_FRONT)
                documentTitleTutorial.setText(getDocumentInformationTitle(response));
            else {
                if (response == UploadDocumentPhotoType.OTHER_BACK)
                    documentTitleTutorial.setText(getDefaultTitle(getResources().getString(R.string.document_tutorial_title_default_part_1_back
                    )));
                if (response == UploadDocumentPhotoType.OTHER_FRONT) {
                    documentTitleTutorial.setText(getDefaultTitle(getResources().getString(R.string.document_tutorial_title_default_part_1_front
                    )));
                }
            }
        }
    }

    public String getDocumentInformationTitle(UploadDocumentPhotoType uploadDocumentPhotoType) {
        String titleName = "";
        switch (uploadDocumentPhotoType) {
            case PASSPORT:
                titleName = getResources().getString(R.string.document_type_text);
                break;
            case ID_CARD_FRONT:
                titleName = getResources().getString(R.string.document_type_id_card_front);
                break;
            case ID_CARD_BACK:
                titleName = getResources().getString(R.string.document_type_id_card_back);
                break;
            case FACE_PHOTO:
                titleName = getResources().getString(R.string.document_face_photo);
                break;


        }
        return titleName;
    }

    private void observeUI() {
        cameraViewModel.getDocumentTutorialTitleColorMutableLiveData().observe(getViewLifecycleOwner(), new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });

        cameraViewModel.getDocumentTutorialTitleVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {

                    if (documentTitleTutorial != null)
                        documentTitleTutorial.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getTextViewOfDocumentMutableLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (documentBorderTextView != null)
                    documentBorderTextView.setVisibility(response ? View.VISIBLE : View.GONE);
            }
        });

        cameraViewModel.getActionButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        cameraViewModel.setTakePictureButtonAvailability(true);
        setupCustomUI();


    }

    ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener() {
        @Override
        public boolean onPreDraw() {
            int width = rootView.getWidth();
            int height = rootView.getHeight();
            RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, currentUploadDocumentPhotoType != null ? currentUploadDocumentPhotoType.getProportions() : 30f / 19f);
            final double xPositionRatio = visibleArea.left / width;
            final double yPositionRatio = visibleArea.top / height;
            if (imageView != null)
                setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, currentUploadDocumentPhotoType);
            rootView.getViewTreeObserver().removeOnPreDrawListener(this);
            return true;
        }
    };


    public void setupDocumentView(@Nullable UploadDocumentPhotoType document) {
        if (document != UploadDocumentPhotoType.FACE_PHOTO) {

            cameraViewModel.setTextViewOfDocumentMutableLiveData(true);
            if (fotoapparatFocusView != null)
                fotoapparatFocusView.setVisibility(View.VISIBLE);
            if (customFocusView != null)
                customFocusView.setEnabled(true);
            rootView.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);
        }
    }


    private void setupImageViewWithScalledImage(final double xPositionRatio, final double yPositionRatio,
                                                UploadDocumentPhotoType uploadDocumentPhotoType) {
        if (uploadDocumentPhotoType != UploadDocumentPhotoType.FACE_PHOTO) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
            final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            int horizontalMargin = (int) (parent.getWidth() * xPositionRatio);
            int verticalMargin = (int) (parent.getHeight() * yPositionRatio);
            params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            imageView.setLayoutParams(params);

            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                determineValuesForDocument(parentWidth, parentHeight, horizontalMargin, verticalMargin);
                customViewHolder.setValuesForRectangle(rectangleLeft,
                        rectangleTop,
                        rectangleRight,
                        rectangleBottom);
                customViewHolder.invalidate();
            }
            setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth);
        }

    }

    private void setupValuesForCropping(int verticalMargin, int horizontalMargin, int parentHeight, int parentWidth) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin;
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2;
        widthOfImage = parentWidth;
        xCoordinateOfWidthStart = 0;
    }

    private void determineValuesForDocument(int parentWidth, int parentHeight, int horizontalMargin, int verticalMargin) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        if (this.rectangleLeft > this.rectangleRight) {
            int c = this.rectangleLeft;
            int k = this.rectangleRight;
            this.rectangleRight = c;
            this.rectangleLeft = k;
        }
    }

    private View getCustomShape() {
        if (customShapes != null)
            if (!(customShapes.getChildAt(0) == null)) {
                return customShapes.getChildAt(0);
            }
        return null;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD);
            backTextView.setTypeface(typeface);
            documentTitleTutorial.setTypeface(typeface);

        }
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (canFocus.get()) {
                        switch (event.getAction()) {
                            case MotionEvent.ACTION_DOWN:

                                if (cameraViewModel.getNextButtonVisibility().getValue() != null && !cameraViewModel.getNextButtonVisibility().getValue())
                                    if (canFocus.get()) {
                                        return false;
                                    } else {
                                    }
                        }
                        return false;
                    } else {
                        return true;
                    }
                }

            });
        setupFocus();
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();


    }

    private void observeButtonsAvailability() {

        cameraViewModel.getTakePictureButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupFocus() {
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (canFocus.get()) {
                        if (fotoapparat != null) {
                            canFocus.set(false);
                            fotoapparat.getCurrentParameters().whenDone(new WhenDoneListener<CameraParameters>() {
                                @Override
                                public void whenDone(@org.jetbrains.annotations.Nullable CameraParameters cameraParameters) {
                                    if (cameraParameters != null)
                                        if (!cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                            if (fotoapparat != null) {
                                                fotoapparat.updateConfiguration(
                                                        UpdateConfiguration.builder().focusMode(
                                                                firstAvailable(autoFocus())).build());
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                            if (cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                        }
                                }
                            });
                        }
                    }
                }
            });

    }

    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                takePictureHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (getActivity() != null) {
                            takePicture();
                        }
                    }

                }, BUTTON_DELAY_FOR_UX);

            }
        });


    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new CustomFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (cameraView != null) {
            if (getActivity() != null)
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Bitmap result = BitmapPhotoCropper.
                                cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                        currentUploadDocumentPhotoType);
                        DocumentPhotoResult uploadDocumentPhotoType = new DocumentPhotoResult(result, cameraViewModel.getCurrentDocumentStep(), currentUploadDocumentPhotoType,
                                rectangleRight, rectangleLeft, rectangleTop, rectangleBottom);
                        cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType);
                        cameraViewModel.addDocumentPhotoResultFragment.setValue(true);
                    }
                });


        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    private SpannableStringBuilder getDefaultTitle(String docPart) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (getActivity() == null) {
            builder.append("");
            return builder;
        }
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_0
                )));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)), " " + docPart + " "));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_2
                )));
        return builder;
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    @Override
    public void onPause() {
        super.onPause();
        fotoapparat.stop();
    }

    @Override
    public void onStop() {
        super.onStop();
        LoggingHelper.onStop(DocumentsCameraSessionFragment.class.getSimpleName());


    }


    @Override
    public void onStart() {
        super.onStart();
        setupCamera();
        LoggingHelper.onStart(DocumentsCameraSessionFragment.class.getSimpleName());


    }

    @Override
    public void onResume() {
        super.onResume();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (fotoapparat != null) {
                    fotoapparat.start();
                }

            }
        }, 20);


    }

    @Override
    public void onDestroyView() {
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        LoggingHelper.onDestroyView(DocumentsCameraSessionFragment.class.getSimpleName());
        onPreDrawListener = null;
        super.onDestroyView();
        fotoapparatFocusView = null;
        cameraView = null;
        fotoapparat = null;

        backTextView = null;
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        onPreDrawListener = null;

        imageInfoLayout = null;
        documentTitleTutorial = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        if (customShapes != null) {

            for (int i = 0; i < customShapes.getChildCount(); i++) {
                if (customShapes.getChildAt(i) != null) {
                    customShapes.removeViewAt(i);
                }
            }
            customShapes = null;
        }
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }

    public void setupCamera() {

        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            if (fotoapparatFocusView != null && cameraView != null) {
                fotoapparat = Fotoapparat
                        .with(getActivity())
                        .into(cameraView)
                        .previewScaleType(ScaleType.CenterCrop)
                        .previewResolution(highestResolution())
                        .lensPosition(back())
                        .focusMode(firstAvailable(
                                continuousFocusPicture(),
                                continuousFocusVideo(),
                                autoFocus(),
                                fixed()
                        ))
                        .focusView(fotoapparatFocusView)
                        .photoResolution(ResolutionSelectorsKt.highestResolution())
                        .frameProcessor(new CustomFrameProcessor(getActivity()))
                        .cameraErrorCallback(new CameraErrorListener() {
                            @Override
                            public void onError(@NonNull CameraException e) {
                                cameraViewModel.setAddCameraFragment(false);
                            }
                        })
                        .build();


            }

        }
    }

    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);

    }


}
