package com.idenfy.idenfySdk.RxExtensions;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.ReplaySubject;

public class ObservableListWithReplay<T> {

    protected final List<T> list;
    protected final ReplaySubject<T> onAdd;

    public ObservableListWithReplay() {
        this.list = new ArrayList<T>();
        this.onAdd = ReplaySubject.create();
    }

    public void add(T value) {
        list.add(value);
        onAdd.onNext(value);
    }

    public Observable<T> getObservable() {
        return onAdd;
    }
}
