package com.idenfy.idenfySdk.Networking;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.idenfySdk.BuildConfig;

import java.util.concurrent.TimeUnit;

import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public interface RetrofitFactory {
    static APIService create() {
        Gson gson = new GsonBuilder()
                .setLenient()
                .create();

        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        String hostname = "ivs.idenfy.com";
        String testApi = "http://34.246.55.6/";
        String productionApi = "https://ivs.idenfy.com/";
        CertificatePinner certificatePinner = new CertificatePinner.Builder()
                .add(hostname, BuildConfig.ROOT_PIN)
                .add(hostname, BuildConfig.INTERMEDIATE_PIN)
                .add(hostname, BuildConfig.LEAF_PIN)
                .build();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.certificatePinner(certificatePinner);
        if (BuildConfig.DEBUG) {
            builder.addInterceptor(interceptor);
        } else {
            builder.certificatePinner(certificatePinner);
        }

        builder.connectTimeout(300, TimeUnit.SECONDS)
                .writeTimeout(300, TimeUnit.SECONDS)
                .readTimeout(300, TimeUnit.SECONDS)
                .build();

        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        if (BuildConfig.DEBUG) {
            retrofitBuilder.baseUrl(productionApi);
        } else {
            retrofitBuilder.baseUrl(productionApi);
        }
        retrofitBuilder.addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .addConverterFactory(GsonConverterFactory.create(gson))
                .client(builder.build())
                .build();
        return retrofitBuilder.build().create(APIService.class);
    }
}