package com.idenfy.idenfySdk.helpers.enums;

import android.support.annotation.NonNull;

import com.idenfySdk.R;

import java.util.ArrayList;

import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.BACK_FILENAME;
import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.FACE_FILENAME;
import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.FRONT_FILENAME;

public enum UploadDocumentPhotoType {

    ID_CARD_FRONT() {
        @Override
        public double getProportions() {
            return 30f / 19f;
        }


    },
    RESIDENCE_PERMIT() {
        @Override
        public double getProportions() {
            return 30f / 19f;
        }
    },

    DRIVER_LICENSE() {
        @Override
        public double getProportions() {
            return 30f / 19f;
        }
    },
    OTHER_FRONT() {
        @Override
        public double getProportions() {
            return 125f / 87f;
        }
    },

    OTHER_BACK() {
        @Override
        public double getProportions() {
            return 125f / 87f;
        }
    },

    PASSPORT() {
        @Override
        public double getProportions() {
            return 125f / 87f;
        }

    },
    ID_CARD_BACK() {
        @Override
        public double getProportions() {
            return 30f / 19f;
        }

    },
    FACE_PHOTO() {
        @Override
        public double getProportions() {
            return -1;
        }


    };

    UploadDocumentPhotoType() {
    }

    private boolean showFront = true;

    public abstract double getProportions();


    public String getFilename() {
        switch (this) {
            case PASSPORT:
                return FRONT_FILENAME;
            case ID_CARD_FRONT:
                return FRONT_FILENAME;
            case ID_CARD_BACK:
                return BACK_FILENAME;
            case FACE_PHOTO:
                return FACE_FILENAME;
        }
        return "";
    }


}
