package com.idenfy.idenfySdk.Repository;

import android.arch.lifecycle.LiveData;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.Models.Step;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.Networking.Models.DocumentTypeRequest;
import com.idenfy.idenfySdk.Networking.Models.PartnerInfo;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;
import com.idenfy.idenfySdk.Networking.RetrofitFactory;
import com.idenfy.idenfySdk.Networking.RetrofitFactoryOptional;
import com.idenfy.idenfySdk.RxExtensions.ObservableListWithReplay;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.helpers.ErrorsHelper;
import com.idenfy.idenfySdk.helpers.SingleLiveEvent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function4;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import okhttp3.ResponseBody;
import retrofit2.HttpException;

public class Repository {


    Observable<ResponseBody> startSessionObservable;
    Observable<ResponseBody> setCountryObservable;
    public ReplaySubject<Boolean> startSessionSubjectTrigger;
    public ReplaySubject<Boolean> setDcumentTypeSubjectTrigger;
    private ReplaySubject<Boolean> zoomSDKSubjectTrigger;
    private ReplaySubject<Boolean> setDcumentIssuingCountryTrigger;
    private ReplaySubject<StreamPost> photosUploaedSubjectManager;
    private ReplaySubject<Boolean> photosUploadedTrigger;
    private ReplaySubject<Boolean> facePhotoUploaedTrigger;
    private PartnerInfo partnerInfo;
    ObservableListWithReplay<Observable<StreamPost>> listObservables;
    Observable<ResponseBody> documentTypeObservable;

    Repository(IdenfyController idenfyController) {

    }

    public void setupDocumentTypeTrigger() {
        setDcumentTypeSubjectTrigger = ReplaySubject.create();

    }


    public void setupInitialTriggers() {
        setDcumentIssuingCountryTrigger = ReplaySubject.create();
        startSessionSubjectTrigger = ReplaySubject.create();
    }

    public void startSessionTriggerDone() {
        startSessionSubjectTrigger.onNext(true);
    }

    public void setCountryTriggerDone() {
        setDcumentIssuingCountryTrigger.onNext(true);
    }

    public List<Step> uploadedSteps = new ArrayList<>();
    public SingleLiveEvent<String> idenfyErrorIdentifierLiveData = new SingleLiveEvent<>();

    public LiveData<String> getIdenfyErrorIdentifier() {
        return idenfyErrorIdentifierLiveData;
    }

    public void observeUploadedPhotos(List<Step> stepList, CompositeDisposable compositeDisposable) {
        photosUploadedTrigger = ReplaySubject.create();
        facePhotoUploaedTrigger = ReplaySubject.create();
        photosUploaedSubjectManager = ReplaySubject.create();
        compositeDisposable.add(photosUploaedSubjectManager.
                subscribeOn(Schedulers.io()).
                observeOn(AndroidSchedulers.mainThread())
                .subscribe(success ->
                {
                    Object[] photos = (Object[]) photosUploaedSubjectManager.getValues();
                    List<StreamPost> streamPostsFromSubject = new ArrayList<>();
                    List<Step> steps = new ArrayList<>();
                    for (int i = 0; i < photos.length; i++) {

                        StreamPost streamPost = (StreamPost) photos[i];
                        if (streamPost.getStep().equalsIgnoreCase(Step.face.name())) {
                            facePhotoUploaedTrigger.onNext(true);
                            facePhotoUploaedTrigger.onComplete();
                        }
                        streamPostsFromSubject.add(streamPost);
                        if (streamPost.getStep().equalsIgnoreCase(Step.face.name())) {
                            steps.add(Step.face);
                        }

                        if (streamPost.getStep().equalsIgnoreCase(Step.front.name())) {
                            steps.add(Step.front);
                        }
                        if (streamPost.getStep().equalsIgnoreCase(Step.back.name())) {
                            steps.add(Step.back);
                        }
                    }
                    if (steps.containsAll(stepList)) {
                        photosUploadedTrigger.onNext(true);
                        photosUploadedTrigger.onComplete();
                        photosUploaedSubjectManager.onComplete();
                    }
                }, error ->
                {
                    handleErrorInstance(error);
                }));


    }

    public void setPartnerInfo(PartnerInfo partnerInfo) {
        if (partnerInfo.getCountry() != null) {
            setCountryTriggerDone();
        }
        this.partnerInfo = partnerInfo;

    }

    public void checkLiveness(com.idenfy.idenfyliveness.LivenessCheck livenessCheck, CompositeDisposable compositeDisposable) {

        compositeDisposable.add(facePhotoUploaedTrigger
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread()).
                        concatMap(response ->
                        {
                            return RetrofitFactoryOptional.create().checkLivenessObservable(livenessCheck).subscribeOn(Schedulers.io())
                                    .observeOn(AndroidSchedulers.mainThread());
                        }).subscribeOn(Schedulers.io()).
                        observeOn(AndroidSchedulers.mainThread())
                .take(1)
                .subscribe(success ->
                {
                    zoomSDKSubjectTrigger.onNext(true);
                }, this::handleErrorInstance));
        ;
    }

    public void startSession(String authToken, CompositeDisposable compositeDisposable) {
        AuthTokenRequest authTokenRequest = new AuthTokenRequest(authToken);
        startSessionObservable = RetrofitFactory.create().startSessionObservable(authTokenRequest);
        compositeDisposable.add(startSessionObservable.
                subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .take(1)
                .subscribe(success ->
                {
                    startSessionTriggerDone();

                }, this::handleErrorInstance));
    }


    public void handleError(int code, ResponseBody errorBody) {
        if (code >= 300 && code < 500) {
            JsonParser parser = new JsonParser();
            JsonElement mJson = null;
            try {
                mJson = parser.parse(errorBody.string());
                Gson gson = new GsonBuilder().setLenient().create();
                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                idenfyErrorIdentifierLiveData.postValue(errorResponse.getIdentifier());
            } catch (Exception ex) {
                idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER);
            }

        } else if (code >= 500) {
            idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.IDENFY_SERVER_ERROR_IDENTIFIER);
        }
    }

    public void setIssuingCountry(CountrySetRequest countrySetRequest, CompositeDisposable compositeDisposable) {
        setCountryObservable = RetrofitFactory.create().setIssuingCountryObservable(countrySetRequest);
        compositeDisposable.add(setCountryObservable.
                subscribeOn(Schedulers.io()).
                observeOn(AndroidSchedulers.mainThread())
                .subscribe(success ->
                {
                    setCountryTriggerDone();
                }, this::handleErrorInstance));
    }

    public Observable<Boolean> observeThenToStartProcessing() {
        return Observable.zip(photosUploadedTrigger,
                setDcumentTypeSubjectTrigger, setDcumentIssuingCountryTrigger, zoomSDKSubjectTrigger, new Function4<
                        Boolean, Boolean, Boolean, Boolean, Boolean>() {
                    @Override
                    public Boolean apply(Boolean photosUploaded, Boolean documentSet, Boolean issuingCountry, Boolean zoomSDk) throws Exception {

                        if (photosUploaded && documentSet && issuingCountry && zoomSDk) {
                            return true;
                        }
                        return false;

                    }
                });
    }

    public boolean shouldSetupLiveness(List<Step> stepList) {
        if (!partnerInfo.getZoomLiveliness()) {
            return false;
        }
        if (stepList.contains(Step.face)) {
            return true;
        }
        return false;
    }


    public void startObservingUploads(CompositeDisposable documentsFlowDisposable, List<Step> stepList, CompositeDisposable documentsUploadingFlowReusableDispoable) {
        listObservables = new ObservableListWithReplay<>();
        zoomSDKSubjectTrigger = ReplaySubject.create();

        if (!shouldSetupLiveness(stepList)) {
            zoomSDKSubjectTrigger.onNext(true);
        }
        observeUploadedPhotos(stepList, documentsUploadingFlowReusableDispoable);
        documentsFlowDisposable.add(
                Observable.concat(listObservables.getObservable()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).

                        subscribe(response ->
                                {
                                    photosUploaedSubjectManager.onNext(response);
                                },
                                this::handleErrorInstance));


    }

    public void setupDocument(DocumentTypeRequest documentTypeRequest, CompositeDisposable compositeDisposable, boolean hasPartnerEnabledZoom) {
        compositeDisposable.add(startSessionSubjectTrigger.subscribeOn(Schedulers.io()).
                observeOn(AndroidSchedulers.mainThread()).concatMap(response ->
        {
            return RetrofitFactory.create().
                    setDocumentTypeObservable(documentTypeRequest).subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread());
        }).subscribeOn(Schedulers.io()).
                observeOn(AndroidSchedulers.mainThread()).
                take(1)
                .subscribe(success ->
                {
                    setDcumentTypeSubjectTrigger.onNext(true);
                }, this::handleErrorInstance));
        ;
    }

    private void handleErrorInstance(Throwable error) {
        if (error instanceof HttpException) {
            try {
                int errorCode = ((HttpException) error).code();
                ResponseBody errorBody = ((HttpException) error).response().errorBody();
                handleError(errorCode, errorBody);
            } catch (Exception e) {
                idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER);
            }

        } else {
            idenfyErrorIdentifierLiveData.postValue(ErrorsHelper.MALFORMED_JSON_IDENTIFIER);
        }
    }

    public void uploadDocumentPhoto(CompositeDisposable documentsUploadingFlowDisposable, StreamPost streamPost) {

        documentsUploadingFlowDisposable.add(startSessionSubjectTrigger.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).
                subscribe(trigger ->
                        {
                            listObservables.add(RetrofitFactory.create().streamPhotoNewObservanle(streamPost).
                                    subscribeOn(Schedulers.io()).
                                    observeOn(AndroidSchedulers.mainThread())

                                    .flatMap(response ->
                                    {
                                        return Observable.just(streamPost);
                                    }));
                        }
                        , this::handleErrorInstance
                ));


    }
}
