package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.graphics.Typeface;

import com.idenfy.idenfyliveness.IdenfyLivenessHelper;


public class IdenfyUISettings {

    private Integer customResultsViewSpinner = null;
    private boolean isActionBarEnabled = true;
    private String customFontPath;

    private com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings;

    public Integer getCustomResultsViewSpinner() {
        return customResultsViewSpinner;
    }

    public void setCustomResultsViewSpinner(Integer customResultsViewSpinner) {
        this.customResultsViewSpinner = customResultsViewSpinner;
    }

    public boolean isActionBarEnabled() {
        return isActionBarEnabled;
    }

    public void setActionBarEnabled(boolean actionBarEnabled) {
        isActionBarEnabled = actionBarEnabled;
    }

    public void setIdenfyLivenessUISettings(com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings) {
        this.idenfyLivenessUISettings = idenfyLivenessUISettings;
        this.idenfyLivenessUISettings.setLightDarkModeEnabled(false);
        this.idenfyLivenessUISettings = idenfyLivenessUISettings;
    }


    public String getCustomFontPath() {
        return customFontPath;
    }

    public void setCustomFontPath(String customFontPath) {
        this.customFontPath = customFontPath;
    }

    private IdenfyUISettings(IdenfyUIBuilder idenfyUIBuilder) {
        customResultsViewSpinner = idenfyUIBuilder.customResultsViewSpinner;
        isActionBarEnabled = idenfyUIBuilder.isActionBarEnabled;
        customFontPath = idenfyUIBuilder.customFontPath;
    }

    public com.idenfy.idenfyliveness.IdenfyLivenessUISettings getIdenfyLivenessUISettings() {
        return idenfyLivenessUISettings;
    }

    IdenfyUISettings() {

    }

    public static class IdenfyUIBuilder {
        private boolean optionalResultsChecking = false;
        private boolean setupAgreementFragment = true;
        private Typeface font;
        private Typeface fontBold;
        private String customFontPath;
        private Integer customBackgroundPath = -1;
        private Integer customResultsViewSpinner = null;
        private boolean isActionBarEnabled = true;
        private com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings;


        public IdenfyUIBuilder withTypefacePath(String pathOfTypeface) {
            this.customFontPath = pathOfTypeface;
            return this;
        }

        public IdenfyUIBuilder withCustomLoadingView(Integer customLoadingView) {
            this.customResultsViewSpinner = customLoadingView;
            return this;
        }

        public IdenfyUIBuilder withLivenessUISettings(com.idenfy.idenfyliveness.IdenfyLivenessUISettings idenfyLivenessUISettings) {
            this.idenfyLivenessUISettings = idenfyLivenessUISettings;
            return this;
        }


        public IdenfyUIBuilder withAppBarLayoutEnabled(boolean isActionBarEnabled) {
            this.isActionBarEnabled = isActionBarEnabled;
            return this;
        }

        public IdenfyUISettings build() {
            IdenfyUISettings idenfyUISettings = new IdenfyUISettings();
            try {
                Class.forName("com.idenfy.idenfyliveness.IdenfyLivenessUISettings");
                if (idenfyLivenessUISettings != null)
                    idenfyUISettings.setIdenfyLivenessUISettings(idenfyLivenessUISettings);
            } catch (Throwable var2) {
                // return null;
            }
            return idenfyUISettings;
        }

    }
}


