package com.idenfy.idenfySdk.ViewModelsCoreLogic

import android.app.Application
import android.arch.lifecycle.AndroidViewModel
import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.Transformations
import android.util.Pair

import com.idenfy.idenfyliveness.IdenfyLivenessHelper
import com.idenfy.idenfyliveness.LivenessCheck

class LivenessesViewModel(application: Application) : AndroidViewModel(application) {

    private var livenessHelper: IdenfyLivenessHelper? = null

    val zoomSessionResponse: LiveData<Pair<Boolean, LivenessCheck>>
        get() = Transformations.switchMap(livenessHelper!!.zoomSessionResponse) { id ->
            val result = MutableLiveData<Pair<Boolean, LivenessCheck>>()
            result.postValue(id)
            result
        }

    val zoomSuccessResponse: LiveData<Boolean>
        get() = Transformations.switchMap(livenessHelper!!.zoomSessionSuccess) { id ->
            val result = MutableLiveData<Boolean>()
            result.postValue(id)
            result
        }

    val zoomInitializationResult: LiveData<Pair<Boolean, String>>
        get() = Transformations.switchMap(livenessHelper!!.zoomSDKInicializationResponse) { id ->
            val result = MutableLiveData<Pair<Boolean, String>>()
            result.postValue(id)
            result
        }

    val zoomErrorOccured: LiveData<Boolean>
        get() = Transformations.switchMap(livenessHelper!!.zoomErrorOccured) { id ->
            val result = MutableLiveData<Boolean>()
            result.postValue(id)
            result
        }

    init {
        livenessHelper = getLivenessHelper()
    }

    fun getLivenessHelper(): IdenfyLivenessHelper? {
        try {
            Class.forName("com.idenfy.idenfyliveness.IdenfyLivenessHelper")
            if (livenessHelper == null)
                livenessHelper = com.idenfy.idenfyliveness.IdenfyLivenessHelper()
            return livenessHelper
        } catch (t: Throwable) {
            return null
        }

    }
}
