package com.idenfy.idenfySdk.Networking.Models;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

public class PartnerInfo implements Parcelable {
    @Override
    public String toString() {
        return "PartnerInfo{" +
                "name='" + name + '\'' +
                ", canUpload=" + canUpload +
                ", themeColor=" + themeColor +
                ", logoUrl=" + logoUrl +
                ", chatKey=" + chatKey +
                ", country='" + country + '\'' +
                '}';
    }

    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("canUpload")
    @Expose
    private Boolean canUpload;
    @SerializedName("themeColor")
    @Expose
    private Object themeColor;
    @SerializedName("logoUrl")
    @Expose
    private Object logoUrl;
    @SerializedName("chatKey")
    @Expose
    private Object chatKey;
    @SerializedName("country")
    @Expose
    private String country;
    @SerializedName("countriesBlacklist")
    @Expose
    private List<String> countriesBlacklist;

    @SerializedName("zoomLiveliness")
    @Expose
    private Boolean zoomLiveliness;

    public Boolean getZoomLiveliness() {
        return zoomLiveliness;
    }

    public void setZoomLiveliness(Boolean zoomLiveliness) {
        this.zoomLiveliness = zoomLiveliness;
    }

    public List<String> getCountriesBlacklist() {
        return countriesBlacklist;
    }

    public void setCountriesBlacklist(List<String> countriesBlacklist) {
        this.countriesBlacklist = countriesBlacklist;
    }

    /**
     * No args constructor for use in serialization
     */
    public PartnerInfo() {
    }

    /**
     * @param chatKey
     * @param name
     * @param canUpload
     * @param logoUrl
     * @param themeColor
     * @param country
     */
    public PartnerInfo(String name, Boolean canUpload, Object themeColor, Object logoUrl, Object chatKey, String country) {
        super();
        this.name = name;
        this.canUpload = canUpload;
        this.themeColor = themeColor;
        this.logoUrl = logoUrl;
        this.chatKey = chatKey;
        this.country = country;
    }

    protected PartnerInfo(Parcel in) {
        name = in.readString();
        byte tmpCanUpload = in.readByte();
        canUpload = tmpCanUpload == 0 ? null : tmpCanUpload == 1;
        country = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(name);
        dest.writeByte((byte) (canUpload == null ? 0 : canUpload ? 1 : 2));
        dest.writeString(country);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PartnerInfo> CREATOR = new Creator<PartnerInfo>() {
        @Override
        public PartnerInfo createFromParcel(Parcel in) {
            return new PartnerInfo(in);
        }

        @Override
        public PartnerInfo[] newArray(int size) {
            return new PartnerInfo[size];
        }
    };

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getCanUpload() {
        return canUpload;
    }

    public void setCanUpload(Boolean canUpload) {
        this.canUpload = canUpload;
    }

    public Object getThemeColor() {
        return themeColor;
    }

    public void setThemeColor(Object themeColor) {
        this.themeColor = themeColor;
    }

    public Object getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(Object logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Object getChatKey() {
        return chatKey;
    }

    public void setChatKey(Object chatKey) {
        this.chatKey = chatKey;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }


}