package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.idenfy.idenfySdk.helpers.enums.FontEnum;

public class IdenfySettings implements Parcelable {

    public boolean optionalResultsChecking = false;
    private boolean setupAgreementFragment = true;
    private Typeface font;
    private Typeface fontBold;
    private @Nullable
    String token;
    private @Nullable
    Boolean handleResultsChecking = false;

    private @Nullable
    String selectedSdkCustomLocale = null;

    private @Nullable
    boolean isWithStaticListener = false;
    private String customFontPath;
    private String predefinedIssuingCountry = null;
    private Integer customBackgroundPath = -1;
    private Integer customResultsViewSpinner = null;
    private boolean isActionBarEnabled = true;
    public boolean confirmationCompleted = false;

    private IdenfyUISettings idenfyUISettings = new IdenfyUISettings();


    protected IdenfySettings(Parcel in) {
        optionalResultsChecking = in.readByte() != 0;
        setupAgreementFragment = in.readByte() != 0;
        token = in.readString();
        byte tmpHandleResultsChecking = in.readByte();
        handleResultsChecking = tmpHandleResultsChecking == 0 ? null : tmpHandleResultsChecking == 1;
        selectedSdkCustomLocale = in.readString();
        isWithStaticListener = in.readByte() != 0;
        customFontPath = in.readString();
        predefinedIssuingCountry = in.readString();
        if (in.readByte() == 0) {
            customBackgroundPath = null;
        } else {
            customBackgroundPath = in.readInt();
        }
        if (in.readByte() == 0) {
            customResultsViewSpinner = null;
        } else {
            customResultsViewSpinner = in.readInt();
        }
        isActionBarEnabled = in.readByte() != 0;
        customIdentificationLayout = in.readByte() != 0;
        withActivityResults = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (optionalResultsChecking ? 1 : 0));
        dest.writeByte((byte) (setupAgreementFragment ? 1 : 0));
        dest.writeString(token);
        dest.writeByte((byte) (handleResultsChecking == null ? 0 : handleResultsChecking ? 1 : 2));
        dest.writeString(selectedSdkCustomLocale);
        dest.writeByte((byte) (isWithStaticListener ? 1 : 0));
        dest.writeString(customFontPath);
        dest.writeString(predefinedIssuingCountry);
        if (customBackgroundPath == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(customBackgroundPath);
        }
        if (customResultsViewSpinner == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(customResultsViewSpinner);
        }
        dest.writeByte((byte) (isActionBarEnabled ? 1 : 0));
        dest.writeByte((byte) (customIdentificationLayout ? 1 : 0));
        dest.writeByte((byte) (withActivityResults ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IdenfySettings> CREATOR = new Creator<IdenfySettings>() {
        @Override
        public IdenfySettings createFromParcel(Parcel in) {
            return new IdenfySettings(in);
        }

        @Override
        public IdenfySettings[] newArray(int size) {
            return new IdenfySettings[size];
        }
    };

    public void setIsActionBarEnabled(boolean isEnabled) {
        this.isActionBarEnabled = isEnabled;
    }

    public boolean getActionBarEnabled() {
        return isActionBarEnabled;
    }


    private boolean customIdentificationLayout = false;


    public boolean isCustomIdentificationLayout() {
        return customIdentificationLayout;
    }

    public void setCustomIdentificationLayout(boolean customIdentificationLayout) {
        this.customIdentificationLayout = customIdentificationLayout;
    }

    public String getCustomFontPath() {
        return customFontPath;
    }


    @Nullable
    public boolean isWithStaticListener() {
        return isWithStaticListener;
    }

    public void setWithStaticListener(@Nullable boolean withStaticListener) {
        isWithStaticListener = withStaticListener;
    }

    private boolean withActivityResults = false;

    public boolean isWithActivityResults() {
        return withActivityResults;
    }

    public void setWithActivityResults(boolean withActivityResults) {
        this.withActivityResults = withActivityResults;
    }

    public Typeface getIdenfyFont(FontEnum fontEnum) {
        if (this.font != null) {
            return this.font;
        }

        return fontEnum.getTypeface();
    }

    public void setFont(String font) {

        this.customFontPath = font;
    }

    public void setIssuingCountry(String issuingCountry) {
        if (issuingCountry != null) {
            this.predefinedIssuingCountry = issuingCountry;
            setupAgreementFragment = false;
        }

    }

    public String getIssuingCountry() {
        return this.predefinedIssuingCountry;
    }


    @Nullable
    public Boolean getHandleResultsChecking() {
        return handleResultsChecking;
    }

    public IdenfySettings(@NonNull String token, @NonNull Context context) {
        this.token = token;
    }

    @Nullable
    public String getToken() {
        return token;
    }


    public void setCustomLocale(String locale) {
        selectedSdkCustomLocale = locale;
    }

    public String getCustomLocale() {

        return selectedSdkCustomLocale;
    }

    public boolean getSetupAgreementFragment() {
        return setupAgreementFragment;
    }

    public void setSetupAgreementFragment(@NonNull boolean setupAgreementFragment) {
        this.setupAgreementFragment = setupAgreementFragment;
    }

    void setHandleResultsChecking(boolean optionalHandeling) {
        this.handleResultsChecking = optionalHandeling;
    }

    private void setCustomBackgroundPath(Integer integer) {
        this.customBackgroundPath = integer;
    }


    @Override
    public String toString() {
        return "IdenfySettings{" +
                ", setupAgreementFragment='" + setupAgreementFragment + '\'' +
                ", font=" + font +
                ", token='" + token + '\'' +
                ", handleResultsChecking=" + handleResultsChecking +
                '}';
    }

    public void setCustomTypeface(Typeface idenfyFont) {

        if (idenfyFont != null)
            font = idenfyFont;
    }

    public void setCustomTypefaceBold(Typeface idenfyFont) {

        if (idenfyFont != null)
            fontBold = idenfyFont;
    }

    public Typeface getIdenfyBold(FontEnum fontEnum) {
        if (this.font != null) {
            return this.fontBold;
        }

        return fontEnum.getTypeface();
    }

    public IdenfyUISettings getIdenfyUISettings() {
        return idenfyUISettings;
    }

    public void setIdenfyUISettings(IdenfyUISettings idenfyUISettings) {
        this.idenfyUISettings = idenfyUISettings;
    }

    public IdenfySettings(IdenfyBuilder idenfyBuilder) {
        this.selectedSdkCustomLocale = idenfyBuilder.selectedLocale;
        this.setIssuingCountry(idenfyBuilder.issuingCountry);
        this.setupAgreementFragment = idenfyBuilder.setupAgreementFragment;
        this.token = idenfyBuilder.token;
        this.customIdentificationLayout = idenfyBuilder.isCustomResultsView;
        this.customResultsViewSpinner = idenfyBuilder.idenfyUISettings.getCustomResultsViewSpinner();
        this.isActionBarEnabled = idenfyBuilder.idenfyUISettings.isActionBarEnabled();
        this.customFontPath = idenfyBuilder.idenfyUISettings.getCustomFontPath();
        this.idenfyUISettings = idenfyBuilder.idenfyUISettings;

    }

    public Integer getCustomBackgroundPath() {
        return customBackgroundPath;
    }

    public Integer getCustomResultsViewSpinner() {
        return this.customResultsViewSpinner;
    }

    public void setCustomResultsSpinner(int spinnerResourceId) {
        this.customResultsViewSpinner = spinnerResourceId;
    }

    public static class IdenfyBuilder {
        boolean setupAgreementFragment = true;
        boolean isCustomResultsView = false;
        private @Nullable
        String token;
        private @Nullable
        Boolean handleResultsChecking = false;
        String selectedLocale = null;
        private String issuingCountry = null;
        IdenfyUISettings idenfyUISettings = new IdenfyUISettings();

        public IdenfyBuilder withAuthToken(String authToken) {
            this.token = authToken;
            return this;
        }

        public IdenfyBuilder withCustomSelectedLocale(String selectedLocale) {
            this.selectedLocale = selectedLocale;
            return this;
        }

        public IdenfyBuilder withPresentInitialView(boolean isPresent) {
            this.setupAgreementFragment = isPresent;
            return this;
        }

        public IdenfyBuilder withCustomResultsView(boolean isCustom) {
            this.isCustomResultsView = isCustom;
            return this;
        }

        public IdenfyBuilder withUISettings(IdenfyUISettings idenfyUISettings) {
            this.idenfyUISettings = idenfyUISettings;
            return this;
        }

        public IdenfyBuilder withIssuingCountry(String issuingCountry) {
            this.issuingCountry = issuingCountry;
            this.setupAgreementFragment = false;
            return this;
        }

        public IdenfySettings build() {
            return new IdenfySettings(this);
        }

    }
}
