package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.idenfy.idenfySdk.InnerSDKInitialization.InnerSDKInitializationHelper;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.Networking.ProcessUploadCompletion;
import com.idenfy.idenfySdk.helpers.enums.AuthentificationResult;

public class IdenfyController {


    private IdenfySettings settings;
    private String test;
    public static ExitCode exitCode;
    public static IdenfyErrorResponse idenfyError;
    public static ProcessUploadCompletion processUploadCompletion;
    public static AuthenticationResultResponse authenticationResultResponse;
    private static final int exitCodeTerminated = -1;
    public static boolean isNewWayOfIdentification = true;
    public static final String ON_AUTHENTICATION_RESULT = "ON_AUTHENTICATION_RESULT";
    public static final String ON_USER_EXIT = "ON_USER_EXIT";
    public static final String ON_ERROR = "ON_ERROR";
    public static int AUTHENTICATION_RESULT_CODE = 14579;
    public static int USER_EXIT_CODE = 14580;
    public static int ERROR_CODE = 14581;
    public static int IDENFY_REQUEST_CODE = 14582;


    public void initialize(@NonNull IdenfySettings settings1, @Nullable AuthenticationListener listener) {
        this.settings = settings1;
        if (this.settings.getIssuingCountry() == null) {
            this.settings.setIssuingCountry("lt");
        }
        mListener = listener;
    }

    public void startAutentification(@NonNull Context context) {
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            settings.setWithStaticListener(false);
            InnerSDKInitializationHelper.startActivity(context);
//            Intent intent = new Intent(context, CameraPreviewActivity.class);
//            context.startActivity(intent);
        }

    }

    public void startActivityForResult(Activity context, int requestCode, IdenfySettings settings) {
        if (settings == null) {
            throw new IllegalStateException("call IdenfyContoller.getInstance().initialize(...) first");
        } else {
            this.settings = settings;
            this.settings.setHandleResultsChecking(false);
            this.settings.setWithActivityResults(true);
            InnerSDKInitializationHelper.startActivityForResult(context, requestCode);
//            Intent intent = new Intent(context, CameraPreviewActivity.class);
//            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void handleActivityResult(int resultCode, Intent data, AuthenticationListenerNew authenticationListenerNew) {

        if (idenfyError != null)
            authenticationListenerNew.onError(idenfyError);
        if (processUploadCompletion != null)
            authenticationListenerNew.onProcessCompleted(processUploadCompletion);
        if (exitCode == null && idenfyError == null && authenticationResultResponse == null) {
            authenticationListenerNew.onUserExit(new ExitCode(exitCodeTerminated));
        } else if (idenfyError == null && authenticationResultResponse == null) {
            authenticationListenerNew.onUserExit(exitCode);
        }
        if (authenticationResultResponse != null) {
            authenticationListenerNew.onAuthenticationResult(authenticationResultResponse);
        }
    }


    public interface AuthenticationListener {
        void onAutentification(AuthentificationResult result);
    }

    public interface AuthenticationListenerNew {
        default void onProcessCompleted(ProcessUploadCompletion result) {
            return;
        }

        default void onUserExit(ExitCode result) {

        }

        default void onError(IdenfyErrorResponse result) {

        }

        ;

        void onAuthenticationResult(AuthenticationResultResponse authenticationResultResponse);

    }

    public IdenfyController() {


    }

    public AuthenticationListener mListener;

    public static IdenfyController getInstance() {

        if (instance == null) {
            instance = new IdenfyController();
        }

        return instance;
    }

    public void startAuthentication(Activity context, int requestCode, IdenfySettings idenfySettings) {
        this.settings = idenfySettings;
        if (settings == null) {
            throw new IllegalStateException("create IdenfySettings first");
        } else {
            isNewWayOfIdentification = true;
            settings.setHandleResultsChecking(false);
            settings.setWithStaticListener(true);
            InnerSDKInitializationHelper.startActivityForResult(context, requestCode);
//            Intent intent = new Intent(context, CameraPreviewActivity.class);
//            context.startActivityForResult(intent, requestCode);
        }
    }

    public void setSettings(@NonNull IdenfySettings settings) {
        this.settings = settings;
    }

    public IdenfySettings getSettings() {
        return this.settings;
    }

    private static IdenfyController instance;

}
