package com.idenfy.idenfySdk.ViewModelsCoreLogic;

import android.app.Activity;
import android.app.Application;


import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.Transformations;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType;
import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentTypeClass;
import com.idenfy.idenfySdk.Models.Step;
import com.idenfy.idenfySdk.Models.StepStatusClass;
import com.idenfy.idenfySdk.Networking.Models.PartnerInfo;
import com.idenfy.idenfySdk.Networking.Models.SetDeviceTypeForAPI;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.Networking.RetrofitFactory;
import com.idenfy.idenfySdk.Networking.RetrofitFactoryOptional;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.RetakeSteps;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountryEnum;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult;
import com.idenfy.idenfySdk.helpers.DocumentWrapper;
import com.idenfy.idenfySdk.helpers.SingleLiveEvent;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountryCode;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfyliveness.IdenfyLivenessHelper;
import com.idenfy.idenfyliveness.LivenessCheck;
import com.idenfySdk.R;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.Networking.ProcessUploadCompletion;
import com.idenfy.idenfySdk.SdkResponseModels.AuthenticationResultClass;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;


import org.reactivestreams.Subscription;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

//import io.reactivex.Observable;
//import io.reactivex.Scheduler;
//import io.reactivex.android.schedulers.AndroidSchedulers;
//import io.reactivex.schedulers.Schedulers;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class CameraViewModel extends AndroidViewModel {
    public Context applicationContext;
    public DocumentTypeClass currentDocumentClass;
    public Bitmap setBitmap;
    private HashMap<UploadDocumentPhotoType, Boolean> uploadsFinishedHashMap;
    private HashMap<String, Boolean> loadingFinishedHasMap;

    public MutableLiveData<List<UploadDocumentPhotoType>> retakeDocumentsList = new MutableLiveData<>();
    private MutableLiveData<Resource<List<Country>>> countriesListFinalMutableLiveData = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> countrySetForDocumentMutableLiveData = new MutableLiveData<>();
    public MutableLiveData<Resource<Boolean>> startSessionMutableLIveData = new MutableLiveData<>();
    private int cameraDelay = 600;
    public long CHECKING_RESULTS_START_DELAY = 3000;
    public long CHECKING_RESULTS_PINNING_DELAY = 9000;
    private static final String DEVICE_TYPE = "MOBILE_SDK";
    private MutableLiveData<Boolean> initialLoadingDataHasLoaded = new MutableLiveData<>();

    public void setInitialLoadingDataHasLoaded(Boolean initialLoadingDataHasLoaded) {
        this.initialLoadingDataHasLoaded.setValue(initialLoadingDataHasLoaded);
    }

    public LiveData<Boolean> getInitialLoadingDataHasLoaded() {
        return initialLoadingDataHasLoaded;
    }

    //UPLOADS MANAGEMENT
    private MutableLiveData<Resource<ResponseBody>> fontUploadResponseBody = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> backUploadResponseBody = new MutableLiveData<>();
    private MutableLiveData<Resource<ResponseBody>> faceUploadResponseBody = new MutableLiveData<>();
    private MediatorLiveData<Resource<Status>> uploadsFinishedLiveData = new MediatorLiveData<>();
    //UI/UX VISIBILITY AND AVAILABILITY
    private MutableLiveData<Boolean> cameraViewVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> nextButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> facePhotoVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> actionButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> recreateButtonVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> showImageLayoutVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> cropShapeImageViewVisibility = new MutableLiveData<>();
    private MutableLiveData<Boolean> nextButtonAvailability = new MutableLiveData<>();
    MutableLiveData<Boolean> recreateButtonAvailability = new MutableLiveData<>();
    MutableLiveData<Boolean> takePictureButtonAvailability = new MutableLiveData<>();
    MutableLiveData<String> imageViewResultTitleMutableLiveData = new MutableLiveData<>();
    MutableLiveData<String> imageViewResultTitleColorMutableLiveData = new MutableLiveData<>();
    MutableLiveData<String> documentTutorialTitleColorMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Integer> resultPhotoWidthMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Drawable> backButtonDrawableMutableLiveData = new MutableLiveData<>();

    //DOCUMENT TYPES, INFO
    MutableLiveData<DocumentWrapper> documentInfo = new MutableLiveData<>();
    MutableLiveData<Boolean> isBackFotoapparatCamera = new MutableLiveData<>();
    MutableLiveData<UploadDocumentPhotoType> documentTypeMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Boolean> imageViewResult = new MutableLiveData<>();
    MutableLiveData<Boolean> imageViewResultFullSize = new MutableLiveData<>();
    MutableLiveData<AuthenticationResultClass> authenticationResultClassMutableLiveData = new MutableLiveData<>();
    public MutableLiveData<Boolean> authenticationFragmentOpenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Boolean> documentTutorialTitleVisibility = new MutableLiveData<>();
    MutableLiveData<Resource<String>> checkAuthTokenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Resource<String>> checkSixDigitTokenMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Resource<String>> firstCountryFromIPMutableLiveData = new MutableLiveData<>();
    public SingleLiveEvent<Resource<ResponseBody>> setDocumentTypeResponseMutableLiveData = new SingleLiveEvent<>();
    public MediatorLiveData<Resource<HashMap<String, Boolean>>> mainLoadingMediatorLiveData = new MediatorLiveData<>();
    MutableLiveData<Boolean> countrySelectionAvailabilityMutableLiveData = new MutableLiveData<>();
    MutableLiveData<Boolean> textViewOfDocumentMutableLiveData = new MutableLiveData<>();


    public void setTextViewOfDocumentMutableLiveData(Boolean textViewOfDocumentMutableLiveData) {
        this.textViewOfDocumentMutableLiveData.setValue(textViewOfDocumentMutableLiveData);
    }

    public MutableLiveData<Boolean> getTextViewOfDocumentMutableLiveData() {
        return textViewOfDocumentMutableLiveData;
    }

    //CheckIfCanRetry
    SingleLiveEvent<Resource<String>> checkIfCanRetryMutableLiveData = new SingleLiveEvent<>();

    public LiveData<Resource<String>> checkIfCanRetryLiveData() {
        return checkIfCanRetryMutableLiveData;
    }

    public MutableLiveData<Boolean> getCountrySelectionAvailabilityMutableLiveData() {
        return countrySelectionAvailabilityMutableLiveData;
    }

    //ADDING REMOVING VIEWS, SAFELY
    private MutableLiveData<Boolean> addCameraFragment = new MutableLiveData<>();
    private MutableLiveData<Boolean> dismissCountryDialog = new MutableLiveData<>();
    private MutableLiveData<Boolean> addSixDigitsBarcodeFragmentMutableLiveData = new MutableLiveData<>();
    private MutableLiveData<Boolean> addInitialAgreementFragmentMutableLiveData = new MutableLiveData<>();
    // private MutableLiveData<Boolean> canSetCameraView = new MutableLiveData<>();

    //CONSTANTS
    public static final String loadingLiveDataCountriesKey = "CountriesList";
    public static final String loadingLiveDataAuthTokenKey = "AuthToken";
    public static final String loadingLiveDataDocumentsTypes= "DocumentTypes";
    public static final String loadingLiveDataFirstCountryKey = "FirstCountry";
    public static final String startSessionLoadingKey = "StartSession";


    private MutableLiveData<List<UploadDocumentPhotoType>> photosNeededToUpload = new MutableLiveData<>();

    public LiveData<Resource<ResponseBody>> getCountrySetForDocumentMutableLiveData() {

        return this.countrySetForDocumentMutableLiveData;
    }

    public LiveData<Resource<Boolean>> getInitialFragmentClosingLiveData() {
        return this.startSessionMutableLIveData;
    }


    public void setUploadsFinishedFalse(UploadDocumentPhotoType uploadDocumentPhotoType) {
        uploadsFinishedHashMap.put(uploadDocumentPhotoType, false);
    }


    public CameraViewModel(@NonNull Application application) {
        super(application);
        setupSourcesForMainMediator();
        if (IdenfyController.getInstance() != null && IdenfyController.getInstance().getSettings() != null && IdenfyController.getInstance().getSettings().getCustomLocale() != null) {
            Configuration config = this.getApplication().getApplicationContext().getResources().getConfiguration();
            Locale locale = new Locale(IdenfyController.getInstance().getSettings().getCustomLocale());
            Locale.setDefault(locale);
            config.locale = locale;
            this.getApplication().getApplicationContext().getResources().
                    updateConfiguration(config, this.getApplication().getApplicationContext().getResources().getDisplayMetrics());
        }
        retakeDocumentsList.postValue(new ArrayList<>());
        uploadsFinishedHashMap = new HashMap<>();
        applicationContext = application.getApplicationContext();
        mainActivityViewVisibility.postValue(true);
        countrySelectionAvailabilityMutableLiveData.setValue(true);
    }
    public Resource<String> frontUploadStepStatus = Resource.loading(null);
    public Resource<String> backUploadStepStatus = Resource.loading(null);
    public Resource<String> faceUploadStepStatus = Resource.loading(null);
    public List<Resource<String>> listOfUploadStatus = new ArrayList<>();
    public List<Boolean> uploadedPhotosList = new ArrayList<>();
    public List<MutableLiveData<Resource<ResponseBody>>> listOfUploadedPhotosLiveData = new ArrayList<>();
    public List<String> uploadedDocumentsPhotosBase64Array = new ArrayList<>();
    public List<StepStatusClass> stepStatusClassList = new ArrayList<>();

    public void reInitSources()
    {
        for(MutableLiveData<Resource<ResponseBody>> uploadMutableLiveData : listOfUploadedPhotosLiveData)
        {
            uploadsFinishedLiveData.removeSource(uploadMutableLiveData);
        }
    }

   public void setupUploadStatuses(DocumentTypeClass documentTypeClass)
   {
       reInitSources();
       uploadedDocumentsPhotosBase64Array = new ArrayList<>();
       listOfUploadedPhotosLiveData = new ArrayList<>();
       stepStatusClassList = new ArrayList<>();
       for(Step step:documentTypeClass.getUploadPhotoStepList())
       {
           MutableLiveData<Resource<ResponseBody>> stepMutableLiveData = new MutableLiveData<>();
           StepStatusClass stepStatusClass = new StepStatusClass(step.name(), false);
           listOfUploadedPhotosLiveData.add(stepMutableLiveData);
           stepStatusClassList.add(stepStatusClass);
           uploadsFinishedLiveData.addSource(stepMutableLiveData, response->
           {
               if(response!=null && response.status==Status.SUCCESS) {
                   stepStatusClass.setStatus(true);
                   uploadsFinishedLiveData.setValue(Resource.success(null));
               }
           });
       }
   }
   public boolean checkIfReadyToStartProccessing()
   {
       for(StepStatusClass stepStatusClass: stepStatusClassList)
       {
           if(!stepStatusClass.isStatus())
           {
               return false;
           }
       }
       return true;
   }



    private void setupSourcesForMainMediator() {

        loadingFinishedHasMap = new HashMap<>();
        if (IdenfyController.getInstance().getSettings() == null) {
            return;
        }
        if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment()) {
            loadingFinishedHasMap.put(loadingLiveDataFirstCountryKey, false);
        }

        loadingFinishedHasMap.put(loadingLiveDataAuthTokenKey, false);
        loadingFinishedHasMap.put(loadingLiveDataDocumentsTypes, false);
        mainLoadingMediatorLiveData.setValue(Resource.loading(loadingFinishedHasMap));
        if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment()) {
            mainLoadingMediatorLiveData.addSource(firstCountryFromIPMutableLiveData, response ->
            {
                if (response != null) {
                    if (response.status == Status.SUCCESS) {
                        loadingFinishedHasMap.put(loadingLiveDataFirstCountryKey, true);
                        mainLoadingMediatorLiveData.setValue(Resource.success(loadingFinishedHasMap));
                    }
                }
            });
        }
        else
        {
            mainLoadingMediatorLiveData.addSource(startSessionMutableLIveData, response ->
            {
                if (response != null) {
                    if (response.status == Status.SUCCESS) {
                        loadingFinishedHasMap.put(startSessionLoadingKey, true);
                        mainLoadingMediatorLiveData.setValue(Resource.success(loadingFinishedHasMap));
                    }
                }
            });
        }
        mainLoadingMediatorLiveData.addSource(documentsTypesMutableLiveData, response->
        {
            if(response!=null)
            {
                if(response.status==Status.SUCCESS)
                {
                    loadingFinishedHasMap.put(loadingLiveDataDocumentsTypes, true);
                    documentsTypesLiveData.setValue(response.data);
                    mainLoadingMediatorLiveData.setValue(Resource.success(loadingFinishedHasMap));
                }
            }
        });
        mainLoadingMediatorLiveData.addSource(partnerInfoMutableLiveData, new Observer<Resource<PartnerInfo>>() {
            @Override
            public void onChanged(@Nullable Resource<PartnerInfo> response) {
                if (response != null) {

                    if (response.status == Status.SUCCESS) {
                        loadingFinishedHasMap.put(loadingLiveDataAuthTokenKey, true);
                        mainLoadingMediatorLiveData.setValue(Resource.success(loadingFinishedHasMap));
                    }
                }
            }
        });
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        applicationContext = null;

    }


    public SingleLiveEvent<Resource<ResponseBody>> getSetDocumentTypeResponseMutableLiveData() {
        return this.setDocumentTypeResponseMutableLiveData;


    }

    private MutableLiveData<Resource<List<Country>>> countriesListMutableLiveData = new MutableLiveData<>();


    //SDK Responses
    private MutableLiveData<Resource<ProcessUploadCompletion>> startedProcessingLiveData =
            new MutableLiveData<>();

    public MutableLiveData<IdenfyError> idenfyError =
            new MutableLiveData<>();
    public void setIdenfyErrorLiveData(IdenfyError idenfyErrorLiveData)
    {
        idenfyError.setValue(idenfyErrorLiveData);
    }
    MutableLiveData<Resource<ExitCode>> exitCode =
            new MutableLiveData<>();

    public LiveData<Resource<ProcessUploadCompletion>> getStartedProcessingLiveData() {
        return this.startedProcessingLiveData;
    }


    public LiveData<IdenfyError> getIdenfyError() {
        return this.idenfyError;
    }

    public void setIdenfyError(IdenfyError idenfyError) {
        this.idenfyError.setValue(idenfyError);
    }

    public LiveData<Resource<ExitCode>> getExitCode() {
        return this.exitCode;
    }


    public MutableLiveData<Boolean> optionalResultsCheckingMutableLiveData = new MutableLiveData<>();


    public void startProcessing() {
        uploadsFinishedLiveData.setValue(Resource.loading(null));
        startedProcessingLiveData.setValue(Resource.loading(null));
                AuthTokenRequest authTokenRequest = new AuthTokenRequest();
                authTokenRequest.setAuthToken(IdenfyController
                        .getInstance().getSettings().getToken());
                Call<ResponseBody> call = RetrofitFactory.create().startProcess(authTokenRequest);
                call.enqueue(new Callback<ResponseBody>() {
                    @Override
                    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            if (IdenfyController.getInstance().getSettings().optionalResultsChecking) {
                                optionalResultsCheckingMutableLiveData.setValue(true);
                            } else
                                startedProcessingLiveData.setValue(Resource.success(new ProcessUploadCompletion(true)));
                        } else {
                            JsonParser parser = new JsonParser();
                            JsonElement mJson = null;
                            try {
                                ResponseBody errorBody = response.errorBody();
                                if (errorBody != null) {
                                    mJson = parser.parse(errorBody.string());
                                    try {
                                        Gson gson = new GsonBuilder().setLenient().create();
                                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                        idenfyError.postValue(new IdenfyError(errorResponse, true));
                                    } catch (Exception ex) {
                                        idenfyError.postValue(new IdenfyError(new
                                                IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                                true));
                                        ex.printStackTrace();
                                    }
                                }
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new
                                        IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));

                    }
                });


    }


    public LiveData<Resource<String>> getCountryFromIPLiveDataAndDecideToShowFragment() {
        return this.firstCountryFromIPMutableLiveData;
    }

    public LiveData<Resource<String>> getSixDigitTokenMutableLiveData() {
        return this.checkSixDigitTokenMutableLiveData;
    }

    public void setCheckSixDigitTokenMutableLiveDataLoading() {
        this.checkSixDigitTokenMutableLiveData.postValue(Resource.loading(null));
    }

    public void setAuthTokenMutableLiveDataLoading() {
        this.checkAuthTokenMutableLiveData.postValue(Resource.loading(null));
    }

    public LiveData<Resource<String>> getCheckAuthTokenLiveData() {
        return this.checkAuthTokenMutableLiveData;
    }


    public LiveData<Boolean> getDismissCountryDialogLiveData() {
        return dismissCountryDialog;
    }

    public void setDismissCountryDialogMutableLiveData(boolean b) {
        dismissCountryDialog.postValue(b);
    }

    public IdenfyError getDefaultIdenfyError() {
        return new IdenfyError(
                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                true);
    }

    public MutableLiveData<Resource<AuthenticationResultResponse>> authenticationResultResponseLiveData = new MutableLiveData<>();
    public MutableLiveData<AuthenticationResultResponse> identificationSuccessResponse = new MutableLiveData<>();
    public void setIdentificationSuccessResponse( AuthenticationResultResponse authenticationResultResponse)
    {
       this.identificationSuccessResponse.setValue(authenticationResultResponse);
    }

    public void setDeviceTypeForAPI() {

        SetDeviceTypeForAPI setDeviceTypeForAPI = new SetDeviceTypeForAPI(IdenfyController
                .getInstance().getSettings().getToken(),
                DEVICE_TYPE);
        Call<SetDeviceTypeForAPI> call =
                RetrofitFactory.create().setDeviceTypeForAPI(setDeviceTypeForAPI);

        call.enqueue(new Callback<SetDeviceTypeForAPI>() {
            @Override
            public void onResponse(@NonNull Call<SetDeviceTypeForAPI> call, @NonNull Response<SetDeviceTypeForAPI> response) {
                if (response.isSuccessful()) {

                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                mJson = parser.parse(errorBody.string());
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<SetDeviceTypeForAPI> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(
                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });
    }

    public void handleRetakeSteps(RetakeSteps retakeSteps)
    {
        List<Step> stepList = new ArrayList<>();
        if(retakeSteps.getFRONT()!=null && !retakeSteps.getFRONT())
        {
            stepList.add(Step.front);
        }
        if(retakeSteps.getBACK()!=null && !retakeSteps.getBACK())
        {
            stepList.add(Step.back);
        }
        if(retakeSteps.getFACE()!=null && !retakeSteps.getFACE())
        {
            stepList.add(Step.face);
        }
        currentDocumentClass.setupValuesForCurrentStep(stepList);

    }
    public MutableLiveData<Boolean> isReadyForStartCheckingResults = new MutableLiveData<>();
    public MutableLiveData<Boolean> isReadyForStartProcessing = new MutableLiveData<>();

    public void startCheckingForAuthenticationResultsNew() {

        AuthTokenRequest streamPost = new AuthTokenRequest();
        streamPost.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<AuthenticationResultResponse> authenticationResultResponseCall =
                RetrofitFactory.create().checkAuthenticationStatus(streamPost);
        authenticationResultResponseCall.enqueue(new Callback<AuthenticationResultResponse>() {

            @Override
            public void onResponse(@NonNull Call<AuthenticationResultResponse> call, @NonNull Response<AuthenticationResultResponse> response) {
                if (response.isSuccessful()) {
                        AuthenticationResultResponse authenticationResultResponse = response.body();
                        if(authenticationResultResponse!=null) {
                            if(authenticationResultResponse.getProcessingStatus()==null)
                            {
                                idenfyError.postValue(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                                getApplication().getResources()
                                                        .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                        true));
                                return;

                            }
                            authenticationResultResponseLiveData.setValue(Resource.success(authenticationResultResponse));

                            if (!authenticationResultResponse.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
//                                authenticationResultsHandler.postDelayed(new Runnable() {
//                                    @Override
//                                    public void run() {
//                                       // isReadyForStartCheckingResults.setValue(true);
//                                       // startCheckingForAuthenticationResultsNew();
//
//                                    }
//                                }, CHECKING_RESULTS_START_DELAY);
                            } else {
                                if (authenticationResultResponse.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
                                    handleRetakeSteps(authenticationResultResponse.getRetakeSteps());
                                }
                            }
                        }
                        else
                        {

                            idenfyError.postValue(new IdenfyError(
                                    new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                            .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                            getApplication().getResources()
                                                    .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                    true));
                        }


                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                mJson = parser.parse(errorBody.string());
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(
                                        new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                                getApplication().getResources()
                                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(
                                new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }


            @Override
            public void onFailure(@NonNull Call<AuthenticationResultResponse> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));

            }
        });
    }

    public void setCurrentDocumentLiveData(DocumentTypeClass document) {
        document.resetStepsToOriginal();
        this.currentDocumentClass =document;
    }


    public void fetchCountriesList() {

        countriesListMutableLiveData.postValue(Resource.loading(null));
        List<CountryEnum> country_enums =
                new ArrayList<CountryEnum>(EnumSet.allOf(CountryEnum.class));
        List<Country> countryList = new ArrayList<>();
        for (int i = 0; i < country_enums.size(); i++) {
            countryList.add(new Country(country_enums.get(i), i, applicationContext));
        }

        countriesListMutableLiveData.postValue(Resource.success(countryList));
    }

    public void setCountriesList(Resource<List<Country>> countriesList) {
        this.countriesListFinalMutableLiveData.postValue(countriesList);
    }

    public Country selectedCountry = new Country("lt");

    public void setCountryForDocument(Country value) {
        if (value != null) {
            selectedCountry = value;
            setCountryForDocumentRequest(value);
        }
    }



    public void startSession() {
      //  startSessionMutableLIveData.postValue(Resource.success(true));
        AuthTokenRequest authTokenRequest = new AuthTokenRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<ResponseBody> call = RetrofitFactory.create().startSession(authTokenRequest);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    startSessionMutableLIveData.postValue(Resource.success(true));
                    //TODO new mutableLiveData
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                ex.printStackTrace();
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));

            }
        });
    }

    public void setCountryForDocumentRequest(String value) {

        CountrySetRequest authTokenRequest = new CountrySetRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        authTokenRequest.setCountry(value);

        Call<ResponseBody> call = RetrofitFactory.create().setIssuingCountry(authTokenRequest);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    countrySetForDocumentMutableLiveData.setValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                mJson = parser.parse(errorBody.string());
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });

    }


    private void setCountryForDocumentRequest(Country value) {

        CountrySetRequest authTokenRequest = new CountrySetRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        authTokenRequest.setCountry(value.getCountryISO());

        Call<ResponseBody> call = RetrofitFactory.create().setIssuingCountry(authTokenRequest);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    countrySetForDocumentMutableLiveData.setValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                mJson = parser.parse(errorBody.string());
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse, true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });

    }


    public void setDocumentType(DocumentTypeClass document) {
        setDocumentTypeResponseMutableLiveData.postValue(Resource.loading(null));
        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("authToken", IdenfyController.getInstance().getSettings().getToken());
        requestBody.put("documentType", document.getDocumentTypeEnum().name());
        Call<ResponseBody> responseBodyCall = RetrofitFactory.create().setDocumentType(requestBody);
        responseBodyCall.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    setDocumentTypeResponseMutableLiveData.postValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(errorResponse,
                                        true)));
                                idenfyError.postValue(new IdenfyError(errorResponse,
                                        true));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        } else {
                            idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    true));
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(new
                                IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)), true)));
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                setDocumentTypeResponseMutableLiveData.postValue(Resource.error(new IdenfyError(new
                        IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)), true)));
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });
    }

    private MutableLiveData<Resource<PartnerInfo>> partnerInfoMutableLiveData = new MutableLiveData<>();

    public LiveData<Resource<PartnerInfo>> getPartnerInfoLiveData() {
        return partnerInfoMutableLiveData;
    }


    public void setPartnerInfoMutableLiveData(PartnerInfo partnerInfoMutableLiveData) {
        this.partnerInfoMutableLiveData.setValue(Resource.success(partnerInfoMutableLiveData));
    }





    public MutableLiveData<Resource<ResponseBody>> livenessCheckMutableLiveData = new MutableLiveData<>();
    public MutableLiveData<Resource<ResponseBody>> getLivenessCheckMutableLiveData()
    {
        return livenessCheckMutableLiveData;
    }
    public  boolean isZoomLivenessCheckOccured;


    public void fetchPartnerInfo() {
        AuthTokenRequest authTokenRequest = new AuthTokenRequest();
        authTokenRequest.setAuthToken(IdenfyController
                .getInstance().getSettings().getToken());
        Call<PartnerInfo> partnerInfo = RetrofitFactory.create().getPartnerInfo(
                authTokenRequest);
        partnerInfo.enqueue(new Callback<PartnerInfo>() {
            @Override
            public void onResponse(Call<PartnerInfo> call, Response<PartnerInfo> response) {
                if (response.isSuccessful()) {
                    partnerInfoMutableLiveData.postValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse,
                                        true, 1500));
                                partnerInfoMutableLiveData.postValue(Resource.error(new IdenfyError(errorResponse,
                                        false)));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                                partnerInfoMutableLiveData.postValue(Resource.error(ex));

                            }
                        } else {
                            idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    false));
                            partnerInfoMutableLiveData.postValue(Resource.error((String) null));
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                false));
                        partnerInfoMutableLiveData.postValue(Resource.error((String) null));
                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<PartnerInfo> call, @NonNull Throwable t) {
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
                partnerInfoMutableLiveData.postValue(Resource.error((String) null));
            }
        });

    }


    public void setImageViewResultTitleColorMutableLiveData(String colorMutableLiveData) {
        this.imageViewResultTitleColorMutableLiveData.postValue(colorMutableLiveData);
    }

    public void setDocumentTutorialTitleColorMutableLiveData(String colorMutableLiveData) {
        this.documentTutorialTitleColorMutableLiveData.postValue(colorMutableLiveData);
    }

    public LiveData<String> getImageViewResultTitleColorMutableLiveData() {
        return this.imageViewResultTitleColorMutableLiveData;
    }

    public LiveData<String> getDocumentTutorialTitleColorMutableLiveData() {
        return this.documentTutorialTitleColorMutableLiveData;
    }

    public void setBackButtonDrawableMutableLiveData(Drawable drawableMutableLiveData) {
        this.backButtonDrawableMutableLiveData.postValue(drawableMutableLiveData);
    }

    public LiveData<Drawable> getBackButtonDrawableMutableLiveData() {
        return this.backButtonDrawableMutableLiveData;
    }

    public void setTakePictureButtonAvailability(boolean available) {
        takePictureButtonAvailability.setValue(available);
    }

    public void setNextButtonAvailability(boolean available) {
        this.nextButtonAvailability.setValue(available);
    }

    public void setRecreateButtonAvailability(boolean available) {
        this.recreateButtonAvailability.setValue(available);
        this.recreateButtonAvailability.setValue(available);
    }

    public LiveData<Boolean> getTakePictureButtonAvailability() {
        return this.takePictureButtonAvailability;
    }

    public LiveData<Integer> getResultPhotoWidthMutableLiveData() {
        return resultPhotoWidthMutableLiveData;
    }

    public void setResultPhotoWidthMutableLiveData(Integer value) {
        this.resultPhotoWidthMutableLiveData.postValue(value);
    }

    public LiveData<Boolean> getNextButtonAvailability() {
        return this.nextButtonAvailability;
    }

    public LiveData<Boolean> getRecreateButtonAvailability() {
        return this.recreateButtonAvailability;
    }

    public static final String FRONT_FILENAME = "front.jpeg";
    public static final String BACK_FILENAME = "back.jpeg";
    public static final String FACE_FILENAME = "face.jpeg";


    public void setAddCameraFragment(boolean value) {
        this.addCameraFragment.postValue(value);
    }

    public LiveData<Boolean> getAddCameraFragment() {
        return this.addCameraFragment;
    }

    public boolean isRecyclerViewEnabled = false;
    public Boolean shouldDeleteCustomViews = false;

    public LiveData<Boolean> addInitialAgreementFragmentLiveData() {
        if (this.addInitialAgreementFragmentMutableLiveData == null) {
            addInitialAgreementFragmentMutableLiveData = new MutableLiveData<>();
            addInitialAgreementFragmentMutableLiveData.setValue(false);
        }
        return this.addInitialAgreementFragmentMutableLiveData;
    }

    public Boolean checkBoxChecked = false;
    public Boolean check2BoxChecked = false;
    public Boolean countrySelected = false;
    MutableLiveData<Boolean> initialAgreementButtonAvailability = new MutableLiveData<>();

    public MutableLiveData<Boolean> getInitialAgreementButtonAvailability() {
        return initialAgreementButtonAvailability;
    }

    public void setInitialAgreementButtonAvailability(Boolean initialAgreementButtonAvailability) {
        this.initialAgreementButtonAvailability.postValue(initialAgreementButtonAvailability);
    }

    public void setAddInitialAgreementFragmentMutableLiveData(Boolean addInitialAgreementFragmentMutableLiveData) {
        this.addInitialAgreementFragmentMutableLiveData.postValue(addInitialAgreementFragmentMutableLiveData);
    }

    public void setAddSixDigitsFragmentMutableLiveData(Boolean addSixDigitsFragmentMutableLiveData) {
        addSixDigitsBarcodeFragmentMutableLiveData.postValue(addSixDigitsFragmentMutableLiveData);
    }

    public LiveData<Boolean> getDocumentTutorialTitleVisibility() {
        return documentTutorialTitleVisibility;
    }

    public void setDocumentTutorialTitleVisibility(Boolean documentTutorialTitleVisibility) {
        this.documentTutorialTitleVisibility.setValue(documentTutorialTitleVisibility);
    }

    public LiveData<Boolean> getAuthenticationResultFragmentLiveData() {
        return authenticationFragmentOpenMutableLiveData;
    }

    public void setAuthenticationFragmentOpenMutableLiveData(Boolean authenticationFragmentOpenMutableLiveData) {
        this.authenticationFragmentOpenMutableLiveData.postValue(authenticationFragmentOpenMutableLiveData);
    }

    public LiveData<Boolean> getCameraViewVisibility() {
        return cameraViewVisibility;
    }

    public LiveData<Boolean> getImageViewResult() {
        return imageViewResult;
    }

    public void setImageViewResult(Boolean imageViewResult) {
        this.imageViewResult.setValue(imageViewResult);
    }

    public LiveData<Boolean> getImageViewResultFullSize() {
        return imageViewResultFullSize;
    }

    public void setImageViewResultFullSize(Boolean imageViewResultFullSize) {
        this.imageViewResultFullSize.setValue(imageViewResultFullSize);
    }

    public void setShowImageLayoutVisibility(Boolean showImageLayoutVisibility) {
        this.showImageLayoutVisibility.setValue(showImageLayoutVisibility);
    }

    public LiveData<Boolean> getShowImageLayoutVisibility() {
        return showImageLayoutVisibility;
    }

    public void setCameraViewVisibility(Boolean cameraViewVisibility) {
        this.cameraViewVisibility.setValue(cameraViewVisibility);
    }


    public LiveData<Boolean> getNextButtonVisibility() {
        return nextButtonVisibility;
    }

    public void setNextButtonVisibility(Boolean nextButtonVisibility) {
        this.nextButtonVisibility.setValue(nextButtonVisibility);
    }

    public LiveData<Boolean> getIsBackFotoapparatCamera() {
        return isBackFotoapparatCamera;
    }

    public void setIsBackFotoapparatCamera(Boolean isBackFotoapparatCamera) {

        if (isBackFotoapparatCamera) {
            if (this.isBackFotoapparatCamera.getValue() != null) {
                if (!this.isBackFotoapparatCamera.getValue()) {
                    this.isBackFotoapparatCamera.setValue(true);
                }
            }
        } else
            this.isBackFotoapparatCamera.setValue(isBackFotoapparatCamera);
    }

    public MutableLiveData<UploadDocumentPhotoType> getDocumentTypeMutableLiveData() {
        return documentTypeMutableLiveData;
    }

    public void setDocumentTypeMutableLiveData(UploadDocumentPhotoType uploadDocumentPhotoTypeMutableLiveData) {
        this.documentTypeMutableLiveData.setValue(uploadDocumentPhotoTypeMutableLiveData);
    }

    public MutableLiveData<Boolean> getFacePhotoVisibility() {
        return facePhotoVisibility;
    }

    public void setFacePhotoVisibility(Boolean facePhotoVisibility) {
        this.facePhotoVisibility.setValue(facePhotoVisibility);
    }

    public MutableLiveData<Boolean> getActionButtonVisibility() {
        return actionButtonVisibility;
    }

    public void setActionButtonVisibility(Boolean actionButtonVisibility) {
        this.actionButtonVisibility.setValue(actionButtonVisibility);
    }

    public MutableLiveData<Boolean> getRecreateButtonVisibility() {
        return recreateButtonVisibility;
    }

    public void setRecreateButtonVisibility(Boolean recreateButtonVisibility) {

        this.recreateButtonVisibility.setValue(recreateButtonVisibility);
    }

    public LiveData<DocumentWrapper> getDocumentInfo() {
        return documentInfo;
    }

    public MutableLiveData<Boolean> mainActivityViewVisibility = new MutableLiveData<>();

    public void setMainActivityViewVisibility(Boolean mainActivityViewVisibility) {
        if (this.mainActivityViewVisibility.getValue() == null) {
            this.mainActivityViewVisibility.postValue(mainActivityViewVisibility);
        }
        if (mainActivityViewVisibility != this.mainActivityViewVisibility.getValue()) {
            this.mainActivityViewVisibility.postValue(mainActivityViewVisibility);
        }
    }

    public void setDocumentInfo(DocumentWrapper documentWrapper) {
        documentInfo.setValue(documentWrapper);
        if (documentWrapper.getUploadDocumentPhotoType() != null)
            setDocumentTypeMutableLiveData(documentWrapper.getUploadDocumentPhotoType());
        setRecreateButtonVisibility(documentWrapper.isRecreateButtonVisibility());
        setFacePhotoVisibility(documentWrapper.isFacePhotoVisibility());
        setNextButtonVisibility(documentWrapper.isNextButtonVisibility());
        setCameraViewVisibility(documentWrapper.isCameraViewVisibility());
        setShowImageLayoutVisibility(documentWrapper.isShowImageLayoutVisibility());
        setCropShapeImageViewVisibility(documentWrapper.isCropShapeImageViewVisibility());
        setImageViewResult(documentWrapper.isImageViewResultVisibility());
        setImageViewResultFullSize(documentWrapper.isImageViewFullSizeResultVisibility());
        setActionButtonVisibility(documentWrapper.isActionButtonVisibility());
        setDocumentTutorialTitleVisibility(documentWrapper.isDocumentTitleTutorialVisibility());
        setTakePictureButtonAvailability(documentWrapper.isTakePictureButtonAvailability());

    }
    public UploadDocumentPhotoType getUploadDocumentPhotoType()
    {
        return currentDocumentClass.getUploadPhotoStep();
    }
    public void increaseCurrentStep() {
        currentDocumentClass.increaseCurrentStep();
    }

    public Step getCurrentDocumentStep()
    {
        return currentDocumentClass.getCurrentStep();
    }
    public boolean checkIfItReadyToOpenResults()
    {
        return currentDocumentClass.getIsReadyToOpenResults();
    }
    public void setupStepsForCurrentDocument()
    {
        currentDocumentClass.setupValuesForCurrentStep(currentDocumentClass.getUploadPhotoStepList());
    }

    public LiveData<Boolean> cameraViewVisibility() {
        return cameraViewVisibility;
    }

    public LiveData<Boolean> getCropShapeImageView() {
        return cropShapeImageViewVisibility;
    }

    public void setCropShapeImageViewVisibility(Boolean cropShapeImageViewVisibility) {
        this.cropShapeImageViewVisibility.setValue(cropShapeImageViewVisibility);
    }

    public void clearRetakedSteps() {
        retakeDocumentsList.postValue(new ArrayList<>());

    }


    public LiveData<Resource<Status>> getUploadsFinishedLiveData() {
        return uploadsFinishedLiveData;
    }

    public String getImageData(int currentStep)
    {
        if(uploadedDocumentsPhotosBase64Array.size()>currentStep)
        return uploadedDocumentsPhotosBase64Array.get(currentStep);
        return "";
    }
    public void saveFileToServer(UploadDocumentPhotoType uploadDocumentPhotoType, int currentStep ) {
        listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.loading(null));
        String authToken = IdenfyController
                .getInstance().getSettings().getToken();
        String imageData = getImageData(currentStep);
        String step = String.valueOf(currentDocumentClass.getUploadPhotoStepList().get(currentStep)).toUpperCase();
        StreamPost streamPost = new StreamPost(authToken, imageData, step);
        Call<ResponseBody> responseBodySingle = RetrofitFactory.create().streamPhotoNew(streamPost);

        responseBodySingle.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(@NonNull Call<ResponseBody> call,
                                   @NonNull Response<ResponseBody> response) {

                if (response.isSuccessful()) {
                  listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.success(response.body()));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.error(new IdenfyError(errorResponse,
                                        true)));
                                idenfyError.postValue(new IdenfyError(errorResponse,
                                        true));
                            } catch (Exception ex) {
                                ex.printStackTrace();
                                listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true)));
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));
                            }
                        }
                    } catch (Exception ex) {

                        listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.error(new IdenfyError(
                                new IdenfyErrorResponse(
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getApplicationContext()
                                                .getString(R.string.MALFORMED_JSON_IDENTIFIER)),
                                true)));
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                                getApplication().getApplicationContext()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));
                        ex.printStackTrace();

                    }
                }
            }

            @Override
            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                listOfUploadedPhotosLiveData.get(currentStep).setValue(Resource.error(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true)));
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getApplicationContext()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));


            }
        });

    }


    public void setFirstIssuingCountry(String countryCode) {
        firstCountryFromIPMutableLiveData.postValue(Resource.success(countryCode.toLowerCase()));
    }

    private void fetchCountryByIpIfSelected() {
        firstCountryFromIPMutableLiveData.setValue(Resource.loading(null));

        Call<CountryCode> responseBodySingle = RetrofitFactory.create().getCountryByIPAd();
        responseBodySingle.enqueue(new Callback<CountryCode>() {
            @Override
            public void onResponse(@NonNull Call<CountryCode> call, @NonNull Response<CountryCode> response) {
                if (response.isSuccessful()) {
                    CountryCode countryCode = response.body();
                    if (countryCode != null) {
//                        if (getPartnerInfoLiveData().getValue() != null && getPartnerInfoLiveData().getValue().data.)
                            firstCountryFromIPMutableLiveData.setValue(
                                    Resource.success(countryCode.getCountry()));
                    }
                } else {
                    firstCountryFromIPMutableLiveData.postValue(
                            Resource.error(new IdenfyError(new IdenfyErrorResponse(
                                    getApplication().getResources()
                                            .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    false)));
                    idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                            getApplication().getResources()
                                    .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                            getApplication().getResources()
                                    .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                            true));
                    ;
                }
            }

            @Override
            public void onFailure(Call<CountryCode> call, Throwable t) {
                firstCountryFromIPMutableLiveData.postValue(
                        Resource.error(new IdenfyError(new IdenfyErrorResponse
                                (getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                false)));
                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });
    }

    public void fetchCountryByIp() {
        fetchCountryByIpIfSelected();
    }

    public String getBase64(Bitmap type) {

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        type.compress(Bitmap.CompressFormat.JPEG, 90, stream);
        byte[] byteArray = stream.toByteArray();
        String encodedImage = Base64.encodeToString(byteArray, Base64.DEFAULT);
     //   type.recycle();
        return encodedImage;
    }
    public Bitmap savedFacePhotoBitmap;
    public void decideWhichSaveBitmap(@NonNull Bitmap bitmap, @NonNull UploadDocumentPhotoType type) {

        uploadedDocumentsPhotosBase64Array.add(getBase64(bitmap));
    }


    public LiveData<Country> getSelectedCountryLiveData() {
        return this.selectedCountryMutableLiveData;
    }

    public LiveData<Resource<List<Country>>> getCountriesListMutableLiveData() {
        return this.countriesListMutableLiveData;
    }

    public void selectedCountry(Country item) {
        this.selectedCountryMutableLiveData.setValue(item);
    }

    public boolean hasPartnerEnabledZoom = false;

    private MutableLiveData<Country> selectedCountryMutableLiveData = new MutableLiveData<>();

    public void changeDocument(final UploadDocumentPhotoType uploadDocumentPhotoType, boolean isRecreated) {

        if (uploadDocumentPhotoType == UploadDocumentPhotoType.FACE_PHOTO) {
            if (!isRecreated) {
                setIsBackFotoapparatCamera(false);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        setNextButtonVisibility(false);
                        setRecreateButtonVisibility(false);
                        setFacePhotoVisibility(true);
                        setDocumentTypeMutableLiveData(uploadDocumentPhotoType);
                        setShowImageLayoutVisibility(false);
                        setActionButtonVisibility(true);
                        setDocumentTutorialTitleVisibility(true);
                    }
                }, cameraDelay);

            } else {
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setFacePhotoVisibility(true);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setDocumentTypeMutableLiveData(uploadDocumentPhotoType);
                setShowImageLayoutVisibility(false);
            }
        } else {
            if (!isRecreated) {
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setDocumentTypeMutableLiveData(uploadDocumentPhotoType);
                setShowImageLayoutVisibility(false);
            } else {
                setTextViewOfDocumentMutableLiveData(true);
                setNextButtonVisibility(false);
                setRecreateButtonVisibility(false);
                setActionButtonVisibility(true);
                setDocumentTutorialTitleVisibility(true);
                setShowImageLayoutVisibility(false);
            }
        }
    }

    public LiveData<String> getImageViewResultTitleMutableLiveData() {
        return this.imageViewResultTitleMutableLiveData;
    }

    private MutableLiveData<Boolean> authenticationSuccessForClosing = new MutableLiveData<>();
    public void setAuthenticationSuccessForClosing(Boolean authenticationSuccessForClosing)
    {
        this.authenticationSuccessForClosing.setValue(authenticationSuccessForClosing);
    }

    public void setImageViewResultTitleMutableLiveData(UploadDocumentPhotoType type) {

        switch (type) {
            case ID_CARD_FRONT:
                this.imageViewResultTitleMutableLiveData.setValue(getApplication().getResources().getString(R.string.show_pictured_document_bottom_passport_text));
                break;
            case PASSPORT:
                this.imageViewResultTitleMutableLiveData.setValue(getApplication().getResources().getString(R.string.show_pictured_document_bottom_passport_text));
                break;
            case ID_CARD_BACK:
                this.imageViewResultTitleMutableLiveData.setValue(getApplication().getResources().getString(R.string
                        .show_pictured_document_bottom_card_back_text));
                break;
            case FACE_PHOTO:
                this.imageViewResultTitleMutableLiveData.setValue(getApplication().getResources().
                        getString(R.string.document_face_photo_result));
                break;
            default :
                this.imageViewResultTitleMutableLiveData.setValue(getApplication().getResources().
                        getString(R.string.show_pictured_document_information_text_default));
                break;

        }


    }

    MutableLiveData<List<DocumentTypeClass>> documentsTypesLiveData = new MutableLiveData<>();
    public LiveData<List<DocumentTypeClass>> getDocumentTypes() {
        return  documentsTypesLiveData;
    }
    public void fetchDocumentTypes()
    {
        fetchDocumentTypesFromApi();
    }
    private MutableLiveData<Resource<List<DocumentTypeClass>>> documentsTypesMutableLiveData = new MutableLiveData<>();
    public void fetchDocumentTypesFromApi() {

        documentsTypesMutableLiveData.setValue(Resource.loading(null));
        Call<List<DocumentType>> call = RetrofitFactory.create().getDocumentsTypes(IdenfyController.getInstance().getSettings().getToken());
        call.enqueue(new Callback<List<DocumentType>>() {
            @Override
            public void onResponse(Call<List<com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType>> call, Response<List<DocumentType>> response) {
                if (response.isSuccessful()) {
                    List<com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType> list = response.body();
                    List<DocumentTypeClass> list1 = new ArrayList<>();
                    if (list != null && !list.isEmpty()) {
                        for (DocumentType type : list) {
                            DocumentTypeClass documentTypeClass = new DocumentTypeClass(type.getType(), type.getStepEnums());
                            list1.add(documentTypeClass);
                        }
                    }
                    documentsTypesMutableLiveData.setValue(Resource.success(list1));
                } else {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            mJson = parser.parse(errorBody.string());
                            try {
                                Gson gson = new GsonBuilder().setLenient().create();
                                IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                                idenfyError.postValue(new IdenfyError(errorResponse,
                                        true, 1500));
                            } catch (Exception ex) {
                                idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                        .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                        getApplication().getResources()
                                                .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                        true));

                            }
                        } else {
                            idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                    .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                    getApplication().getResources()
                                            .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                    false));
                        }
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                false));
                    }
                }
            }

            @Override
            public void onFailure(Call<List<com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType>> call, Throwable t) {
                idenfyError.setValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                        .getString(R.string.IDENFY_SERVER_ERROR_IDENTIFIER),
                        getApplication().getResources()
                                .getString(R.string.IDENFY_SERVER_ERROR_MESSAGE)),
                        true));
            }
        });


    }


    public void setCountrySelectionAvailabilityMutableLiveData(boolean b) {
        this.countrySelectionAvailabilityMutableLiveData.setValue(b);
    }
    private MutableLiveData<DocumentPhotoResult> documentPhotoResultMutableLiveData = new MutableLiveData<>();
    public void setDocumentPhotoResultMutableLiveData(DocumentPhotoResult documentPhotoResultMutableLiveData)
    {
        this.documentPhotoResultMutableLiveData.setValue(documentPhotoResultMutableLiveData);
    }
    public LiveData<DocumentPhotoResult> getDocumentPhotoResultLiveData()
    {
        return documentPhotoResultMutableLiveData;
    }
    public SingleLiveEvent<Boolean> addDocumentPhotoResultFragment = new SingleLiveEvent<>();


    public void checkLiveness(com.idenfy.idenfyliveness.LivenessCheck livenessCheck) {
        uploadsFinishedLiveData.setValue(Resource.loading(null));
        livenessCheckMutableLiveData.setValue(Resource.loading(null));
        livenessCheck.setAuthToken(IdenfyController.getInstance().getSettings().getToken());
        Call<ResponseBody> checkLiveness = RetrofitFactoryOptional.create().checkLiveness(livenessCheck);
        checkLiveness.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if(response.isSuccessful())
                {
                    livenessCheckMutableLiveData.setValue(Resource.success(null));
                }
                else
                {
                    JsonParser parser = new JsonParser();
                    JsonElement mJson = null;
                    try {
                        Gson gson = new GsonBuilder().setLenient().create();
                        IdenfyErrorResponse errorResponse = gson.fromJson(mJson, IdenfyErrorResponse.class);
                        idenfyError.postValue(new IdenfyError(errorResponse,
                                true, 1500));
                    } catch (Exception ex) {
                        idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                                .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                                getApplication().getResources()
                                        .getString(R.string.MALFORMED_JSON_MESSAGE)),
                                true));

                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                    idenfyError.postValue(new IdenfyError(new IdenfyErrorResponse(getApplication().getApplicationContext().getResources()
                            .getString(R.string.MALFORMED_JSON_IDENTIFIER),
                            getApplication().getResources()
                                    .getString(R.string.MALFORMED_JSON_MESSAGE)),
                            true));

            }
        });
    }

}
