package com.idenfy.idenfySdk.UI.DocumentPhotoResultView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.UI.CustomViews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraDisplayHelpers;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;
import com.idenfy.idenfySdk.UI.UIModels.TextViewOfDocument;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.configuration.UpdateConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.log.LoggersKt;
import io.fotoapparat.parameter.FocusMode;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.parameter.camera.CameraParameters;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.result.FocusResult;
import io.fotoapparat.result.WhenDoneListener;
import io.fotoapparat.selector.LensPositionSelectorsKt;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;
import io.fotoapparat.view.FocusView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.LensPositionSelectorsKt.front;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

public class DocumentPhotoResultFragment extends ViewLifecycleFragment {

    public static final String TAG = DocumentPhotoResultFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    CustomFrameProcessor.OnPictureListener onPictureListener;
    private FocusView fotoapparatFocusView;
    private View customFocusView;
    private AppCompatImageButton takePictureButton;
    private CustomFrameProcessor frameProcessor;

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button retakeButton;
    private Button nextButton;
    ImageView backImage;
    TextView backTextView;


    private CameraConfiguration cameraConfiguration;
    private TextView imageViewResultTitle;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();

    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 200;
    //View drawings values

    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public DocumentPhotoResultFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);

    }
    boolean isUp;
    int rootViewHeight;

    View topIvShoulder;
    View faceShoulderOverlay;
    View bottomIvShoulder;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.showedDocumentTitle);
        imageViewResultTitle = rootView.findViewById(R.id.showedDocumentTitle1);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        retakeButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        fotoapparatFocusView = rootView.findViewById(R.id.fotoapparat_focus);

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title);
        customFocusView = rootView.findViewById(R.id.custom_focus);

    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.fragment_camera_preview, container, false);
        initializeUI(rootView);
        return rootView;
    }



    ConstraintLayout imageViewResultConstraintLayout;



    private void observeUI() {
        cameraViewModel.getDocumentTutorialTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });
        cameraViewModel.getImageViewResultTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });


        cameraViewModel.getImageViewResultTitleMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                if (imageViewResultTitle != null)
                    imageViewResultTitle.setText(s);
            }
        });
        cameraViewModel.getImageViewResult().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    if (imageViewResult != null) {
                        imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });
        cameraViewModel.getImageViewResultFullSize().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewFullScreenResult != null) {
                        imageViewFullScreenResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });

        cameraViewModel.getRecreateButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    retakeButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageInfoLayout != null)
                        imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getTextViewOfDocumentMutableLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (documentBorderTextView != null)
                    documentBorderTextView.setVisibility(response ? View.VISIBLE : View.GONE);
            }
        });
        cameraViewModel.getNextButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
            }
        });
        cameraViewModel.getActionButtonVisibility().observe(this, new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


    }





    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD);
            backTextView.setTypeface(typeface);
            imageViewResultTitle.setTypeface(typeface);
            documentTitleTutorial.setTypeface(typeface);
            nextButton.setTypeface(typeface);
            retakeButton.setTypeface(typeface);
        }
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        cameraViewModel.getDocumentPhotoResultLiveData().observe(getViewLifecycleOwner(), response->
        {
            show(response.getDocumentImage(), response.getUploadPhotoType(),
                    response.getRectangleRight(), response.getRectangleLeft(), response.getRectangleBottom(), response.getRectangleTop());
        });
    }

    private void observeButtonsAvailability() {
        cameraViewModel.getNextButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    nextButton.setEnabled(response);

                }
            }
        });
        cameraViewModel.getRecreateButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    retakeButton.setEnabled(aBoolean);
            }
        });
    }





    private void isShouldersViewVisibile(Boolean visible) {
        topIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
        faceShoulderOverlay.setVisibility(visible ? View.VISIBLE : View.GONE);
        bottomIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
    }




    private void retakePhotoPressed(Bitmap bitmap) {
        cameraViewModel.setNextButtonAvailability(false);
        cameraViewModel.setRecreateButtonAvailability(false);
        cameraViewModel.setTakePictureButtonAvailability(true);
        recreateButtonHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                recreateImage();
            }

        }, BUTTON_DELAY_FOR_UX);
    }


    public void show(final Bitmap bitmap, UploadDocumentPhotoType type, int rectangleRight, int rectangleLeft, int rectangleBottom, int rectangleTop) {

        if (currentUploadDocumentPhotoType == UploadDocumentPhotoType.FACE_PHOTO) {
            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                    R.color.idenfyCameraBackArrowPreviewColor));
            isShouldersViewVisibile(false);
        }
        cameraViewModel.setShowImageLayoutVisibility(true);
        cameraViewModel.setImageViewResultTitleMutableLiveData(type);
        if (type == UploadDocumentPhotoType.FACE_PHOTO) {
            if (imageViewFullScreenResult != null) {
                cameraViewModel.setImageViewResultFullSize(true);
                imageViewFullScreenResult.setImageBitmap(bitmap);
            }
        } else {
            cameraViewModel.setImageViewResult(true);
            if (imageViewResult != null) {
                ViewGroup.LayoutParams params = imageViewResult.getLayoutParams();
                params.width = rectangleRight - rectangleLeft;
               params.height = rectangleBottom - rectangleTop;
                imageViewResult.setLayoutParams(params);
                imageViewResult.setImageBitmap(bitmap);
            }
        }

        retakeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                retakePhotoPressed(bitmap);

            }
        });

        nextButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View view) {

                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextButtonHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {

                        nextStep(bitmap);

                    }

                }, BUTTON_DELAY_FOR_UX);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    public void nextStep(Bitmap bitmap) {

        cameraViewModel.decideWhichSaveBitmap(bitmap, cameraViewModel.getUploadDocumentPhotoType());
        cameraViewModel.saveFileToServer(cameraViewModel.getUploadDocumentPhotoType(), cameraViewModel.currentDocumentClass.getCurrentStepPosition());
        if(cameraViewModel.checkIfItReadyToOpenResults()) {
            cameraViewModel.authenticationResultResponseLiveData.setValue(Resource.loading(null));
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
        }
        else {
            cameraViewModel.increaseCurrentStep();

            cameraViewModel.changeDocument(cameraViewModel.getUploadDocumentPhotoType(), false);
            cameraViewModel.setAddCameraFragment(true);
        }
    }


    public void recreateImage() {
        cameraViewModel.changeDocument(currentUploadDocumentPhotoType, true);
    }


    @Override
    public void onPause() {
        super.onPause();

    }

    @Override
    public void onStop() {
        super.onStop();


    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        imageViewFullScreenResult = null;
        imageViewResult = null;
        imageInfoLayout = null;
        cameraView = null;
        fotoapparatFocusView = null;
        documentTitleTutorial = null;
        imageViewResultTitle = null;
        nextButton = null;
        retakeButton = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }



    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);

    }


}
