package com.idenfy.idenfySdk.UI.AuthenticationResultView;

import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.LiveDataExtensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.Models.DocumentTypeEnum;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.ErrorMessage;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;
import com.idenfy.idenfySdk.helpers.IdentificationStatus;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.ErrorsHelper;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.util.Locale;
import java.util.Objects;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link AuthenticationResultFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class AuthenticationResultFragment extends ViewLifecycleFragment implements View.OnClickListener {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    private OnAuthenticationResultFragmentClosed mFragmentClosedListener;
    private RetakeStepsListListener retakeStepsListListener;
    private CameraViewModel cameraViewModel;
    private boolean buttonClicked;
    private Button btnClose;
    //   HorizontalStepView horizontalStepView;

    public AuthenticationResultFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment AuthenticationResultFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static AuthenticationResultFragment newInstance(String param1, String param2) {
        AuthenticationResultFragment fragment = new AuthenticationResultFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        cameraViewModel = ViewModelProviders.of(getActivity()).get(CameraViewModel.class);
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }


    ImageView backPhotoPlaceHolder;
    ImageView frontPhotoPlaceHolder;
    ImageView facePhotoPlaceHolder;
    ProgressBar backProgressBar;
    ProgressBar faceProgressBar;
    ProgressBar frontProgressBar;
    ImageView customLoadingProgressSpinner;
    AppCompatImageView customResultsImageView;
    private TextView authenticationStatusTextView;
    private TextView descriptionTextView;
    private ProgressBar materialProgressBar;
    private TextView tvFrontInfo, tvBackInfo, tvFaceInfo;


    private void initializeUI(View view) {
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder);
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar);
        customLoadingProgressSpinner = view.findViewById(R.id.custom_loading_spinner);
        customResultsImageView = view.findViewById(R.id.custom_results_image_view);
        tvBackInfo = view.findViewById(R.id.back_photo_text_view);
        tvFrontInfo = view.findViewById(R.id.front_document_text_view);
        tvFaceInfo = view.findViewById(R.id.face_photo_text_view);
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder);
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder);
        authenticationStatusTextView = view.findViewById(R.id.titleTextView);
        descriptionTextView = view.findViewById(R.id.descriptionTextView);
        backProgressBar = view.findViewById(R.id.progressBarBack);
        faceProgressBar = view.findViewById(R.id.progressBarFace);
        frontProgressBar = view.findViewById(R.id.progressBarFront);
        btnClose = view.findViewById(R.id.btnClose);
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder);
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar);
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder);
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder);
        authenticationStatusTextView = view.findViewById(R.id.titleTextView);
        descriptionTextView = view.findViewById(R.id.descriptionTextView);
        backProgressBar = view.findViewById(R.id.progressBarBack);
        faceProgressBar = view.findViewById(R.id.progressBarFace);
        frontProgressBar = view.findViewById(R.id.progressBarFront);
        if (faceProgressBar != null)
            faceProgressBar.setVisibility(View.VISIBLE);
        btnClose = view.findViewById(R.id.btnClose);
        btnClose.setVisibility(View.INVISIBLE);
    }

    private void observeAuthenticationResponse() {
        cameraViewModel.authenticationResultResponseLiveData.observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (response.status == Status.LOADING) {
                    startProgressIndicators();
                } else if (response.status == Status.SUCCESS) {
                    if (response.data != null) {
                            handleStepsLoading(response.data);
                        if (response.data.getProcessingStatus()!=null && response.data.getProcessingStatus().equalsIgnoreCase("FINISHED")) {
                            if(!response.data.getIdentificationStatus().equalsIgnoreCase(IdentificationStatus.REVIEWING.getStatus()))
                            handleFinishedLoading(response.data);
                            if (materialProgressBar != null)
                                materialProgressBar.setVisibility(View.INVISIBLE);
                            if (response.data.getIdentificationStatus() != null)
                                handleIdentificationStatus(response.data);

                        }
                    }
                }
            }
        });
    }

    private void handleFinishedLoading(AuthenticationResultResponse data) {
        if(data.getRetakeSteps().getFRONT()==null)
        {
            if (frontProgressBar != null) {
                if (frontProgressBar.getVisibility() == View.VISIBLE) {
                    frontProgressBar.setVisibility(View.INVISIBLE);
                }
                if (frontPhotoPlaceHolder != null)
                    frontPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
            }
        }
        if(data.getRetakeSteps().getBACK()==null)
        {
            if (backProgressBar != null) {
                if (backProgressBar.getVisibility() == View.VISIBLE) {
                    backProgressBar.setVisibility(View.INVISIBLE);
                }
                if (backPhotoPlaceHolder != null)
                    backPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);

            }
        }
        if(data.getRetakeSteps().getFACE() == null)
        {
            if (faceProgressBar!= null) {
                if (faceProgressBar.getVisibility() == View.VISIBLE) {
                    faceProgressBar.setVisibility(View.INVISIBLE);
                }
                if (facePhotoPlaceHolder != null)
                   facePhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
            }
        }

    }

    private void handleIdentificationStatus(AuthenticationResultResponse response) {
        if (response.getIdentificationStatus().equalsIgnoreCase(IdentificationStatus.APPROVED.getStatus())) {
            showSuccess("");
            cameraViewModel.setIdentificationSuccessResponse(response);
        } else if (response.getIdentificationStatus().equalsIgnoreCase(IdentificationStatus.DENIED.getStatus())) {
            String sDefSystemLanguage = Locale.getDefault().getLanguage();
            if (response.getErrorMessage() != null)
                handleErrorMessage(IdenfyController.getInstance().getSettings().getCustomLocale() == null ? sDefSystemLanguage : IdenfyController.getInstance().getSettings().getCustomLocale(), response.getErrorMessage(),response);
        } else if (response.getIdentificationStatus().equalsIgnoreCase(IdentificationStatus.SUSPECTED.getStatus())) {
            cameraViewModel.setIdentificationSuccessResponse(response);
            authenticationStatusTextView.setText(R.string.data_failed);
        } else if(response.getIdentificationStatus().equalsIgnoreCase(IdentificationStatus.REVIEWING.getStatus())){

            showCloseAppAlertDialog(response);
        }
        else
        {
            cameraViewModel.setIdentificationSuccessResponse(response);
            authenticationStatusTextView.setText(R.string.data_failed);
        }

    }
    AlertDialog rewievingStatusDialog;
    private Handler checkResultsDelayHandler = new Handler();

    private void showCloseAppAlertDialog(AuthenticationResultResponse response) {

        if(getActivity()==null)
        {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());

        builder.setTitle(getActivity().getResources().getString(R.string.manual_reviewing_informion_title));
        builder.setMessage(getActivity().getResources().getString(R.string.manual_reviewing_information_message));

        builder.setPositiveButton(getActivity().getResources().getString(R.string.thank_repeat), new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                makeProgressBarsInvisible();
                        cameraViewModel.identificationSuccessResponse.setValue(response);
                        dialog.dismiss();


            }
        });
        rewievingStatusDialog = builder.create();
        rewievingStatusDialog.show();
        rewievingStatusDialog.setCancelable(false);
        rewievingStatusDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }
    private void showAlertDialog()
    {

    }

    private void observeIdenfyError() {
        cameraViewModel.getIdenfyError().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                showIdenfyError(ErrorsHelper.getErrrorMessageFromIdentifier(Objects.requireNonNull(getActivity()), response.getIdenfyErrorResponse().getIdentifier()));
            }
        });
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = null;

        if (!IdenfyController.getInstance().getSettings().isCustomIdentificationLayout()) {

            if(cameraViewModel.currentDocumentClass==null)
            {
                view = inflater.inflate(R.layout.authentication_resut_with_steps_id, container, false);
            }
            else {
                if (cameraViewModel.currentDocumentClass.getDocumentTypeEnum() == DocumentTypeEnum.PASSPORT || cameraViewModel.currentDocumentClass.getDocumentTypeEnum()==DocumentTypeEnum.DRIVER_LICENSE ) {
                    view = inflater.inflate(R.layout.authentication_resut_with_steps_passport, container, false);
                } else {
                    view = inflater.inflate(R.layout.authentication_resut_with_steps_id, container, false);
                }
            }
        } else {
            view = inflater.inflate(R.layout.fragment_identification_results_custom_view, container, false);
        }
        initializeUI(view);
        return view;
    }


    private void handleStepsLoading(AuthenticationResultResponse data) {
       // makeProgressBarsInvisible();
        if(data.getRetakeSteps().getFRONT()!=null && !data.getRetakeSteps().getFRONT())
        {

            if (frontProgressBar != null)
                frontProgressBar.setVisibility(View.INVISIBLE);
            if (frontPhotoPlaceHolder != null)
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        }
        if(data.getRetakeSteps().getFRONT()!=null &&data.getRetakeSteps().getFRONT())
        {
            if (frontProgressBar != null)
                frontProgressBar.setVisibility(View.INVISIBLE);
            if (frontPhotoPlaceHolder != null)
                frontPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_success);
        }
        if(data.getRetakeSteps().getFACE()!=null && !data.getRetakeSteps().getFACE())
        {
            if (faceProgressBar != null)
                faceProgressBar.setVisibility(View.INVISIBLE);
            if (facePhotoPlaceHolder != null)
                facePhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        }
        if(data.getRetakeSteps().getFACE()!=null && data.getRetakeSteps().getFACE())
        {
            if (faceProgressBar != null)
                faceProgressBar.setVisibility(View.INVISIBLE);
            if (facePhotoPlaceHolder!= null)
               facePhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_success);
        }
        if(data.getRetakeSteps().getBACK()!=null && !data.getRetakeSteps().getBACK())
        {
            if (backProgressBar != null)
                backProgressBar.setVisibility(View.INVISIBLE);
            if (backPhotoPlaceHolder != null)
                backPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        }
        if(data.getRetakeSteps().getBACK()!=null && data.getRetakeSteps().getBACK())
        {
            if (backProgressBar != null)
                backProgressBar.setVisibility(View.INVISIBLE);
            if (backPhotoPlaceHolder != null)
                backPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_success);
        }

    }



    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        observeAuthenticationResponse();
        observeIdenfyError();
        cameraViewModel.setNextButtonVisibility(true);
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            descriptionTextView.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            authenticationStatusTextView.setTypeface((idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)));
            if (tvBackInfo != null)
                tvBackInfo.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            if (tvFrontInfo != null)
                tvFrontInfo.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
            if (tvFaceInfo != null)
                tvFaceInfo.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));

        }
    }

    public void startProgressIndicators() {
        if (customLoadingProgressSpinner != null) {
            if (IdenfyController.getInstance().getSettings().getCustomResultsViewSpinner() != null) {
                try {
                    Glide.with(Objects.requireNonNull(getActivity()))
                            .load(IdenfyController.getInstance().getSettings().getCustomResultsViewSpinner())
                            .into(customLoadingProgressSpinner);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (backProgressBar != null) {
            backProgressBar.setVisibility(View.VISIBLE);
        }
        if (frontProgressBar != null)
            frontProgressBar.setVisibility(View.VISIBLE);
        if (faceProgressBar != null)
            faceProgressBar.setVisibility(View.VISIBLE);


    }

    public void showSuccess(String response) {
        authenticationStatusTextView.setText(getResources().getString(R.string.data_approved));
        cameraViewModel.setAuthenticationSuccessForClosing(true);
        if (customResultsImageView != null && customLoadingProgressSpinner != null) {
            customLoadingProgressSpinner.setVisibility(View.INVISIBLE);
            customResultsImageView.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull(getActivity()), R.drawable.ic_checked));

        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    public void showError(String response, AuthenticationResultResponse authenticationResultResponse) {

        if (customResultsImageView != null)
            customResultsImageView.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull(getActivity()), R.drawable.ic_idenfy_spinner_error));
        if (customLoadingProgressSpinner != null)
            customLoadingProgressSpinner.setVisibility(View.INVISIBLE);

        btnClose.setVisibility(View.VISIBLE);
        btnClose.setText(R.string.thank_repeat);
        authenticationStatusTextView.setText(R.string.data_failed);
        descriptionTextView.setVisibility(View.VISIBLE);
        descriptionTextView.setText(response);
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                buttonClicked = true;
                if(authenticationResultResponse.getAttemptsLeft().equalsIgnoreCase("0"))
                {

                    if(getActivity()!=null)
                    cameraViewModel.setIdenfyError(new IdenfyError(new IdenfyErrorResponse(getActivity().getResources()
                            .getString(R.string.TOO_MANY_REATTEMPTS_IDENTIFIER),
                            getActivity().getResources()
                                    .getString(R.string.TOKEN_NOT_VALID_MESSAGE)),
                            false));
                    return;
                }
                else
                {
                    if (retakeStepsListListener != null) {
                        retakeStepsListListener.onRetakeStepsList(true);
                    }
                }

            }
        });
    }

    private void makeProgressBarsInvisible() {
        if (backProgressBar != null)
            backProgressBar.setVisibility(View.INVISIBLE);
        if (frontProgressBar != null)
            frontProgressBar.setVisibility(View.INVISIBLE);
        if (faceProgressBar != null)
            faceProgressBar.setVisibility(View.INVISIBLE);
    }

    public void showIdenfyError(String response) {
        if (customResultsImageView != null)
            customResultsImageView.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull(getActivity()), R.drawable.ic_pause_button));
        if (customLoadingProgressSpinner != null)
            customLoadingProgressSpinner.setVisibility(View.INVISIBLE);
        makeProgressBarsInvisible();
        btnClose.setVisibility(View.INVISIBLE);
        if (materialProgressBar != null)
            materialProgressBar.setVisibility(View.INVISIBLE);
        if (facePhotoPlaceHolder != null)
            facePhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        if (backPhotoPlaceHolder != null)
            backPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        if (frontPhotoPlaceHolder != null)
            frontPhotoPlaceHolder.setImageResource(R.drawable.ic_idenfy_spinner_error);
        authenticationStatusTextView.setText(R.string.data_failed);
        descriptionTextView.setVisibility(View.VISIBLE);
        descriptionTextView.setText(response);
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    private void handleErrorMessage(String sDefSystemLanguage, ErrorMessage errorMessage, AuthenticationResultResponse response) {
        switch (sDefSystemLanguage) {
            case "en":
                showError(errorMessage.getEn(), response);
                break;
            case "lt":
                showError(errorMessage.getLt(), response);
                break;
            case "ru":
                showError(errorMessage.getRu(), response);
                break;
            case "pl":
                showError(errorMessage.getPl(), response);
                break;
            default:
                showError(errorMessage.getEn(), response);
                break;
        }
    }

    @Override
    public void onAttach(Context context) {
        if (context instanceof OnAuthenticationResultFragmentClosed) {
            mFragmentClosedListener = (OnAuthenticationResultFragmentClosed) context;
        }
        if (context instanceof RetakeStepsListListener) {
            retakeStepsListListener = (RetakeStepsListListener) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onClick(View button) {
        switch (button.getId()) {
        }

    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }

    public interface OnAuthenticationResultFragmentClosed {
        // TODO: Update argument type and name
        public void onAuthenticationResultFragmentClosed(boolean closed);
    }

    public interface RetakeStepsListListener {
        // TODO: Update argument type and name
        public void onRetakeStepsList(Boolean value);
    }
}
