package com.idenfy.idenfySdk.Networking

import com.google.gson.GsonBuilder
import retrofit2.Retrofit
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import retrofit2.converter.gson.GsonConverterFactory

object RetrofitFactoryKotlin {
    const val BASE_URL = "https://ivs.idenfy.com/"

    val gson = GsonBuilder()
            .setLenient()
            .create()
    fun makeRetrofitService(): APIService {
        return Retrofit.Builder()
                .baseUrl(BASE_URL)
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .addConverterFactory(GsonConverterFactory.create(gson))
                .build().create(APIService::class.java)
    }
}