package com.idenfy.idenfySdk.Models.DocumentsTypes;


import android.util.Log;

import com.idenfy.idenfySdk.Models.DocumentTypeEnum;
import com.idenfy.idenfySdk.Models.Step;
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;

import java.util.List;

public class DocumentTypeClass {

    private boolean isReadyToOpenResults;
    private DocumentTypeEnum documentTypeEnum;
    private List<Step> uploadPhotoStepList;
    private List<Step> originalStepList;
    private Integer currentStep;
    private Integer previous;


    public DocumentTypeClass(DocumentTypeEnum documentTypeEnum, List<Step> uploadPhotoStepList) {
        this.documentTypeEnum = documentTypeEnum;
        this.uploadPhotoStepList = uploadPhotoStepList;
        this.originalStepList = uploadPhotoStepList;
        currentStep = 0;
        previous = 0;

    }
    public DocumentTypeClass()
    {

    }

    public Integer getCurrentStepPosition() {
        return currentStep;
    }
    public Step getCurrentStep()
    {
       return uploadPhotoStepList.get(currentStep);
    }

    public Boolean getIsReadyToOpenResults() {
        return (uploadPhotoStepList.size()-1) == currentStep;
    }

    public boolean isReadyToOpenResultsView()
    {
        return (uploadPhotoStepList.size()-1)==currentStep;
    }

    public UploadDocumentPhotoType getUploadPhotoStep() {
        if (documentTypeEnum == DocumentTypeEnum.ID_CARD) {
            if (uploadPhotoStepList.get(currentStep)==Step.back)
                return UploadDocumentPhotoType.ID_CARD_BACK;
            else if (uploadPhotoStepList.get(currentStep)==Step.front) {
                return UploadDocumentPhotoType.ID_CARD_FRONT;
            }
            else if(uploadPhotoStepList.get(currentStep)==Step.face)
            {
                return UploadDocumentPhotoType.FACE_PHOTO;
            }
        }
        else if
            ((documentTypeEnum == DocumentTypeEnum.PASSPORT)) {
            if (uploadPhotoStepList.get(currentStep)==Step.front)
                return UploadDocumentPhotoType.PASSPORT;
            else {
                return UploadDocumentPhotoType.FACE_PHOTO;
            }

        }
        else
        {
            if (uploadPhotoStepList.get(currentStep)==Step.front)
                return UploadDocumentPhotoType.OTHER_FRONT;

            else if(uploadPhotoStepList.get(currentStep)==Step.back) {
                return UploadDocumentPhotoType.OTHER_BACK;
            }
            else if(uploadPhotoStepList.get(currentStep)==Step.face) {
                return UploadDocumentPhotoType.FACE_PHOTO;
            }
        }
        return null;
    }


    public void setupValuesForCurrentStep(List<Step> steps)
    {
        currentStep =0;
        this.uploadPhotoStepList = steps;
    }
    public void resetCurrentStep()
    {
        currentStep = 0;
    }
    public void resetStepsToOriginal()
    {

        this.uploadPhotoStepList = originalStepList;

    }
    public void increaseCurrentStep()
    {
        if(currentStep+1<=uploadPhotoStepList.size())
        {
            currentStep++;
        }
    }
    public DocumentTypeEnum getDocumentTypeEnum() {
        return documentTypeEnum;
    }

    public List<Step> getUploadPhotoStepList() {
        return uploadPhotoStepList;
    }

}
