package com.idenfy.idenfySdk.Repository

import android.content.SyncRequest

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest
import com.idenfy.idenfySdk.Networking.RetrofitFactory
import com.idenfy.idenfySdk.Networking.RetrofitFactoryKotlin
import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType


import java.io.IOException
import java.util.function.BiFunction

import io.reactivex.Observable
import io.reactivex.Observer
import io.reactivex.Scheduler
import io.reactivex.Single
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers
import io.reactivex.subjects.PublishSubject
import okhttp3.MediaType
import okhttp3.ResponseBody
import okio.BufferedSource
import retrofit2.HttpException

class Repository(private val idenfyController: IdenfyController) {

    var objectPublishSubject = PublishSubject.create<UploadDocumentPhotoType>()


    val startSessionObservable: Observable<*>
        get() {
            val authTokenRequest = AuthTokenRequest()
            authTokenRequest.authToken = idenfyController.settings.token
            return RetrofitFactoryKotlin.makeRetrofitService().startSessionObservable(authTokenRequest).subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .doOnError(Consumer<Throwable> { this.genericError(it) })
        }


    fun setDocumentType(name: String, photos: String, another: String): Observable<*> {
        return zipSessionDataCountry().observeOn(Schedulers.io())
    }

    private fun setDocumentTypee(name: String, photos: String, o: Any) {

    }

    private fun zipSessionDataCountry(): Observable<*> {

        return Observable.merge(
                startSessionObservable,
                startSessionObservable)
    }

    private fun genericError(throwable: Throwable) {
        val httpException = throwable as HttpException
        try {
            val errorBody = httpException.response().errorBody()!!.string()
        } catch (e: IOException) {
            e.printStackTrace()
        }

    }
}
