package com.idenfy.idenfySdk.Networking;

import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentType;
import com.idenfy.idenfySdk.Networking.Models.AuthToken;
import com.idenfy.idenfySdk.Networking.Models.AuthTokenRequest;
import com.idenfy.idenfySdk.Networking.Models.CountryCode;
import com.idenfy.idenfySdk.Networking.Models.CountrySetRequest;
import com.idenfy.idenfySdk.Networking.Models.PartnerInfo;
import com.idenfy.idenfySdk.Networking.Models.SetDeviceTypeForAPI;
import com.idenfy.idenfySdk.Networking.Models.StreamPost;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface APIService {

    @Headers("Content-Type: application/json")
    @POST("identification/start-process")
    Call<ResponseBody> startProcess(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Call<ResponseBody> startSession(
            @Body AuthTokenRequest rawJson
    );


    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Observable<ResponseBody> startSessionObservable(
            @Body AuthTokenRequest rawJson
    );
    @Headers("Content-Type: application/json")
    @POST("storage/store/stream")
    Call<ResponseBody> streamPhotoNew(
            @Body StreamPost moment
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Call<AuthenticationResultResponse> checkAuthenticationStatus(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Observable<Response<AuthenticationResultResponse>> checkAuthenticationStatusObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/check")
    Call<ResponseBody> checkAuthToken(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("partner/info")
    Call<PartnerInfo> getPartnerInfo(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/can-retry")
    Call<ResponseBody> checkIfCanRetry(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/country")
    Call<ResponseBody> setIssuingCountry(
            @Body CountrySetRequest rawJson
    );

    @GET("other/geoip-country")
    Call<CountryCode> getCountryByIPAd(
    );

    @GET("document/list")
    Call<List<DocumentType>> getDocumentsTypes(
            @Query("authToken") String auhToken
    );



    @Headers("Content-Type: application/json")
    @POST("document/set")
    Call<ResponseBody> setDocumentType(
            @Body Map<String, String> rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/platform")
    Call<SetDeviceTypeForAPI> setDeviceTypeForAPI(
            @Body SetDeviceTypeForAPI deviceTypeForAPI
    );

//    @Headers("Content-Type: application/json")
//    @POST("identification/zoom/liveness")
//    Call<ResponseBody> checkLiveness(
//            @Body com.idenfy.idenfyliveness.LivenessCheck checkLiveness
//    );


}
