package com.idenfy.idenfySdk.UI.UIHelpers;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.YuvImage;
import android.support.annotation.NonNull;

import com.idenfy.idenfySdk.helpers.enums.UploadDocumentPhotoType;


import java.io.ByteArrayOutputStream;

import io.fotoapparat.result.BitmapPhoto;


public class BitmapPhotoCropper {
    private static Bitmap bitmap;

    private static final String TAG = BitmapPhotoCropper.class.getSimpleName();

    public static Bitmap cropPhotoWithPaddings(@NonNull BitmapPhoto bitmapPhoto, CameraViewSize cameraCameraViewSize, RectF visibleArea, @NonNull UploadDocumentPhotoType type) {
        Bitmap bitmap = bitmapPhoto.bitmap;
        if (bitmapPhoto.rotationDegrees != 0) {
            int rotate = 360 - bitmapPhoto.rotationDegrees;

            Matrix rotationMatrix = new Matrix();
            rotationMatrix.postRotate(rotate);
            if (type == UploadDocumentPhotoType.FACE_PHOTO) {
                rotationMatrix.postScale(-1, 1);
            }

            bitmap = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), rotationMatrix, true);
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (type == UploadDocumentPhotoType.FACE_PHOTO) {
                return bitmap;
            } else {
                double multiply = 1;
                double multiplyWidth = 1;
                double multiplyHeight = 1;
                multiplyWidth = (double) ((double) cameraCameraViewSize.width / (double) width);
                multiplyHeight = ((double) ((double) cameraCameraViewSize.height / (double) height));
                try {
                    bitmap = Bitmap.createBitmap(bitmap,
                            (int) (visibleArea.left / multiplyWidth),
                            (int) (visibleArea.top / multiplyHeight),
                            (int) (visibleArea.right / multiplyWidth),
                            (int) (visibleArea.bottom / multiplyHeight));
                    throw new IllegalArgumentException();
                } catch (IllegalArgumentException e) {
                    return bitmap;
                }
            }

        }
        return bitmap;
    }


    public static Bitmap cropPhoto(byte[] data, int width, int height, Context context) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        YuvImage yuvImage = new YuvImage(data, ImageFormat.NV21, width, height, null);
        yuvImage.compressToJpeg(new Rect(0, 0, width, height), 100, out);
        byte[] imageBytes = out.toByteArray();


        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray(imageBytes, 0, imageBytes.length, options);
        options.inSampleSize = calculateInSampleSize(options, (int) (width), (int) (height));
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeByteArray(imageBytes, 0, imageBytes.length, options);
        return bitmap;
    }


    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {

        final int height = options.outHeight;
        final int width = options.outWidth;
        int inSampleSize = 1;

        if (height > reqHeight || width > reqWidth) {

            final int halfHeight = height / 2;
            final int halfWidth = width / 2;

            while ((halfHeight / inSampleSize) >= reqHeight
                    && (halfWidth / inSampleSize) >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

}
