package com.idenfy.idenfySdk.UI.MainActivity;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.Models.DocumentTypeEnum;
import com.idenfy.idenfySdk.Models.DocumentsTypes.DocumentTypeClass;
import com.idenfySdk.R;

import java.util.List;

public class DocumentsRecyclerViewAdapter extends RecyclerView.Adapter<DocumentsRecyclerViewAdapter.ViewHolder> {

    private List<DocumentTypeClass> uploadDocumentPhotoTypes;
    private View.OnClickListener onClickListener;
    private Context mContext;
    private Typeface typeface;
    private onItemClickListener mListener;

    public interface onItemClickListener {
        void onClick(DocumentTypeClass type);
    }

    public DocumentsRecyclerViewAdapter(@NonNull List<DocumentTypeClass> types, final onItemClickListener listener, Context context, Typeface idenfyBold) {
        uploadDocumentPhotoTypes = types;
        this.typeface = idenfyBold;
        mContext = context;
        mListener = listener;



    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.idenfy_documents_type_item, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

       DocumentTypeEnum type = uploadDocumentPhotoTypes.get(position).getDocumentTypeEnum();
        //  holder.textView.setText(type.getNameStringId());
        if (type == DocumentTypeEnum.ID_CARD) {
            if (mContext != null) {
                //holder.textView.setText(type.getNameStringId());
                holder.textView.setText(mContext.getResources().getString(R.string.document_type_id_card).toUpperCase());
                holder.imageView.setImageResource(R.drawable.ic_idenfy_national_identity);
            }
        } else if (type == DocumentTypeEnum.PASSPORT) {
            if (mContext != null) {
                holder.textView.setText(mContext.getResources().getString(R.string.document_type_passport).toUpperCase());
                holder.imageView.setImageResource(R.drawable.ic_idenfy_passport);
            }
        }
        else if(type == DocumentTypeEnum.DRIVER_LICENSE)
        {
            if (mContext != null) {
                holder.textView.setText(mContext.getResources().getString(R.string.document_type_list_item_driver_licence));
                holder.imageView.setImageResource(R.drawable.ic_idenfy_driver_license);
            }
        }
        else if(type == DocumentTypeEnum.OTHER)
        {
            if (mContext != null) {
                holder.textView.setText(mContext.getResources().getString(R.string.document_type_list_item_other));
                holder.imageView.setImageResource(R.drawable.ic_idenfy_other);
            }
        }
        else if(type == DocumentTypeEnum.RESIDENCE_PERMIT)
        {
            if (mContext != null) {
                holder.textView.setText(mContext.getResources().getString(R.string.document_type_list_item_residence_permit));
                holder.imageView.setImageResource(R.drawable.ic_idenfy_residence_permit);
            }
        }
        holder.textView.setTypeface(typeface);
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onClick(uploadDocumentPhotoTypes.get(position));
            }
        });
        holder.itemView.setTag(type);
    }

    @Override
    public int getItemCount() {
        return uploadDocumentPhotoTypes.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView textView;

        ViewHolder(View itemView) {

            super(itemView);
            imageView = itemView.findViewById(R.id.idenfy_document_icon);
            textView = itemView.findViewById(R.id.idenfy_document_text_view);

        }
    }
}
