package com.idenfy.idenfySdk.SdkResponseModels;

import android.os.Parcel;
import android.os.Parcelable;

public class ExitCode implements Parcelable {
    Integer exitCode;

    public ExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }


    protected ExitCode(Parcel in) {
        if (in.readByte() == 0) {
            exitCode = null;
        } else {
            exitCode = in.readInt();
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (exitCode == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(exitCode);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ExitCode> CREATOR = new Creator<ExitCode>() {
        @Override
        public ExitCode createFromParcel(Parcel in) {
            return new ExitCode(in);
        }

        @Override
        public ExitCode[] newArray(int size) {
            return new ExitCode[size];
        }
    };

    public Integer getExitCode() {
        return exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public String toString() {
        return "ExitCode{" +
                "exitCode=" + exitCode +
                '}';
    }
}
