package com.idenfy.idenfySdk.UI.CustomViews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;
import com.idenfySdk.R;

public class CustomViewHolder extends View {
    Paint strokeRectangle = new Paint();
    int left;
    int top;
    int right;
    int bottom;
    Rect rectangle;
    RectF transParentBackground;
    boolean transparentBackgroundVisibility = true;
    private Paint mBackgroundPaint;
    private int transparentBackgroundColor = getResources().getColor(R.color.idenfyTransparentCameraOverlay);
    private int transparentBackgroundColorBlack = getResources().getColor(R.color.idenfyPhotoResultBackgroundColor);
    private int paddingDefault = DpToPixelConverter.dpToPx(5);
    private boolean shouldDrawOval = false;

    //Oval
    private int mTutorialColor = getResources().getColor(R.color.idenfyTransparentCameraOverlay);
    private RectF oval1;
    private RectF ovalStroke;
    Paint strokePaint;
    int layoutWidth;
    int layoutHeight;
    private boolean shouldDrawRectangle = true;

    public boolean getShouldDrawOval() {
        return shouldDrawOval;
    }

    public void setShouldDrawOval(boolean shouldDrawOval) {
        this.shouldDrawOval = shouldDrawOval;
    }

    public boolean getShouldDrawRectangle() {
        return shouldDrawRectangle;
    }

    public void setShouldDrawRectangle(boolean shouldDrawRectangle) {
        this.shouldDrawRectangle = shouldDrawRectangle;
    }

    public CustomViewHolder(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomViewHolder(Context context, int left, int top, int right, int bottom) {
        super(context);
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        if (this.left > this.right) {
            int c = this.left;
            int k = this.right;
            this.right = c;
            this.left = k;
        }
        if (this.bottom > this.right) {

        }
        setLayerType(LAYER_TYPE_HARDWARE, null);
        mBackgroundPaint = new Paint();
        mBackgroundPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        rectangle = new Rect(this.left
                - paddingDefault
                , this.top - paddingDefault,
                this.right + paddingDefault,
                this.bottom + paddingDefault);
        transParentBackground = new RectF(
                this.left,
                this.top,
                this.right,
                this.bottom
        );
    }


    @Override
    public void onDraw(Canvas canvas) {
        if (shouldDrawRectangle) {
            if (transparentBackgroundVisibility) {
                canvas.drawColor(transparentBackgroundColor);
                if (transParentBackground != null && mBackgroundPaint != null)
                    canvas.drawRect(transParentBackground, mBackgroundPaint);
            } else {
                canvas.drawColor(transparentBackgroundColorBlack);
                if (transParentBackground != null && mBackgroundPaint != null)
                    canvas.drawRect(transParentBackground, mBackgroundPaint);
            }
            strokeRectangle.setStyle(Paint.Style.STROKE);
            strokeRectangle.setColor(getResources().getColor(R.color.idenfyDocumentBorderColor));
            strokeRectangle.setStrokeWidth(DpToPixelConverter.dpToPx(2));
            if (rectangle != null && shouldDrawRectangle)
                canvas.drawRect(rectangle, strokeRectangle);
        }

        if (oval1 != null && shouldDrawOval) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawColor(transparentBackgroundColor);
            float cX = canvas.getWidth() / 2.0f;
            float cY = canvas.getHeight() / 2.0f;
            canvas.scale(0.75f, 0.65f, cX, cY);
            canvas.drawOval(ovalStroke, strokePaint);
            canvas.drawOval(oval1, mBackgroundPaint);
        }
    }

    public void drawOval() {
        shouldDrawOval = true;
        shouldDrawRectangle = false;
        setLayerType(LAYER_TYPE_HARDWARE, null);
        mBackgroundPaint = new Paint();
        mBackgroundPaint.setColor(Color.RED);
        mBackgroundPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        strokePaint = new Paint();
        strokePaint.setStyle(Paint.Style.STROKE);
        strokePaint.setColor(getResources().getColor(R.color.idenfyFaceBorderColor));
        strokePaint.setStrokeWidth(DpToPixelConverter.dpToPx(2));


    }

    @Override
    protected void onSizeChanged(int xNew, int yNew, int xOld, int yOld) {
        super.onSizeChanged(xNew, yNew, xOld, yOld);
        if (layoutHeight != yNew || layoutWidth != xNew) {
            layoutHeight = yNew;
            layoutWidth = xNew;
            oval1 = new RectF(0, DpToPixelConverter.dpToPx(30), layoutWidth, layoutHeight);
            ovalStroke = new RectF(-paddingDefault,
                    -paddingDefault + DpToPixelConverter.dpToPx(30),
                    layoutWidth + paddingDefault,
                    layoutHeight + paddingDefault
            );
        }
    }


    public void changeTransparentBackgroundVisibility(Boolean isVisible) {
        this.transparentBackgroundVisibility = isVisible;
    }

    public void setValuesForRectangle(int left, int top, int right, int bottom) {
        shouldDrawOval = false;
        shouldDrawRectangle = true;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        if (this.left > this.right) {
            int c = this.left;
            int k = this.right;
            this.right = c;
            this.left = k;
        }
        setLayerType(LAYER_TYPE_HARDWARE, null);
        mBackgroundPaint = new Paint();
        mBackgroundPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        rectangle = new Rect(this.left
                - paddingDefault
                , this.top - paddingDefault,
                this.right + paddingDefault,
                this.bottom + paddingDefault);
        transParentBackground = new RectF(
                this.left,
                this.top,
                this.right,
                this.bottom
        );

    }
}