package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.UI.CustomViews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.MainActivity.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraDisplayHelpers;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;
import com.idenfy.idenfySdk.UI.UIModels.TextViewOfDocument;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.configuration.UpdateConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.log.LoggersKt;
import io.fotoapparat.parameter.FocusMode;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.parameter.camera.CameraParameters;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.result.FocusResult;
import io.fotoapparat.result.WhenDoneListener;
import io.fotoapparat.selector.LensPositionSelectorsKt;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;
import io.fotoapparat.view.FocusView;

import static android.app.Activity.RESULT_OK;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.LensPositionSelectorsKt.front;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

/**
 * A simple {@link Fragment} subclass.
 * create an instance of this fragment.
 */
public class CameraNewFragment extends Fragment {

    public static final String TAG = CameraNewFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    CustomFrameProcessor.OnPictureListener onPictureListener;
    private FocusView fotoapparatFocusView;
    private View customFocusView;
    private AppCompatImageButton takePictureButton;
    private CustomFrameProcessor frameProcessor;

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button retakeButton;
    private Button nextButton;
    ImageView backImage;
    TextView backTextView;


    private CameraConfiguration cameraConfiguration;
    private TextView imageViewResultTitle;
    private RelativeLayout customShapes;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();

    Runnable focusRunnable = new Runnable() {
        @Override
        public void run() {
            if (fotoapparat != null)
                fotoapparat.getCurrentParameters().whenDone(cameraParameters -> {
                    if (cameraParameters != null)
                        if (!cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusPicture.INSTANCE) ||
                                !cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusVideo.INSTANCE)) {
                            if (fotoapparat != null) {
                                fotoapparat.updateConfiguration(
                                        UpdateConfiguration.builder().focusMode(
                                                firstAvailable(continuousFocusPicture(), continuousFocusVideo())).build());
                                canFocus.set(true);
                            }
                        }
                });
        }
    };
    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    DocumentType currentDocumentType;
    private long BUTTON_DELAY_FOR_UX = 200;
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;
    private final int rectangeMargin = 5;

    // private ConstraintLayout slidingConstraintLayout;


    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public CameraNewFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (getActivity() != null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            setFotoapparatCameraSettins(frameProcessor);
        }
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
        cameraViewModel.getIsBackFotoapparatCamera().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean isBack) {
                if (isBack != null) {

                    isBackCamera = isBack;

                    CameraNewFragment.this.setCameraSettings();
                }
            }
        });

        if (cameraViewModel.getIsBackFotoapparatCamera().getValue() != null) {
            isBackCamera = cameraViewModel.getIsBackFotoapparatCamera().getValue();
            CameraNewFragment.this.setCameraSettings();
        }
    }


    private void setCameraSettings() {
        if (fotoapparat != null) {
            fotoapparat.switchTo(isBackCamera ? LensPositionSelectorsKt.back() :
                    LensPositionSelectorsKt.front(), cameraConfiguration);
        }
    }

    private void setFotoapparatCameraSettins(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    boolean isUp;
    int rootViewHeight;

    private void hideShoulderOverlay() {

    }

    View topIvShoulder;
    View faceShoulderOverlay;
    View bottomIvShoulder;

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.showedDocumentTitle);
//        View view=LayoutInflater.from(getContext()).inflate(R.layout.shoulders_face_overlay,null);
//        ((ViewGroup) rootView).addView(view);
        imageViewResultTitle = rootView.findViewById(R.id.showedDocumentTitle1);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        customShapes.setVisibility(View.VISIBLE);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        retakeButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        fotoapparatFocusView = rootView.findViewById(R.id.fotoapparat_focus);

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_border_tv);

        if (fotoapparatFocusView != null) {
            fotoapparatFocusView.setVisibility(View.VISIBLE);
        }
        customFocusView = rootView.findViewById(R.id.custom_focus);

    }

    ConstraintLayout previewHolder;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.fragment_camera_preview, container, false);
        previewHolder = rootView.findViewById(R.id.previewHolder);
        initializeUI(rootView);
        //SHOULDER_FACE_OVERLAY
        View faceOverlay = LayoutInflater.from(getActivity()).inflate(R.layout.shoulders_face_overlay, container, false);
        topIvShoulder = faceOverlay.findViewById(R.id.top_iv_shoulder);
        faceShoulderOverlay = faceOverlay.findViewById(R.id.face_shoulder_overlay);
        bottomIvShoulder = faceOverlay.findViewById(R.id.bottom_iv_shoulder);
        previewHolder.addView(faceOverlay, 4);

        return rootView;
    }

    private void observeDocumentType() {
        cameraViewModel.getDocumentTypeMutableLiveData().observe(this, new Observer<DocumentType>() {
            @Override
            public void onChanged(@Nullable DocumentType response) {

                if (response != null) {
                    currentDocumentType = response;
                    setupDocumentTitle(response);
                    setupDocumentView(response);
                    setupDocumentOverlayString(response);

                }
            }
        });
    }


    ConstraintLayout imageViewResultConstraintLayout;

    private void handleTextViewAboveDocument(TextViewOfDocument textViewOfDocument) {

    }

    private void setupDocumentOverlayString(DocumentType documentType) {
        if (documentBorderTextView == null) {
            return;
        }
        switch (documentType) {
            case ID_CARD_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));
                break;
            case ID_CARD_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case PASSPORT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));

        }

    }

    private void setupDocumentTitle(DocumentType response) {
        Integer titleId;
        titleId = CameraNewFragment.this.setupTitles(response);
        if (documentTitleTutorial != null)
            documentTitleTutorial.setText(titleId);
    }

    private void observeUI() {
        cameraViewModel.getDocumentTutorialTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });
        cameraViewModel.getImageViewResultTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });


        cameraViewModel.getImageViewResultTitleMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                if (imageViewResultTitle != null)
                    imageViewResultTitle.setText(s);
            }
        });
        cameraViewModel.getImageViewResult().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    if (imageViewResult != null) {
                        imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });
        cameraViewModel.getImageViewResultFullSize().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewFullScreenResult != null) {
                        imageViewFullScreenResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });

        cameraViewModel.getRecreateButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    retakeButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageInfoLayout != null)
                        imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getDocumentTutorialTitleVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewResultTitle != null) {
                        imageViewResultTitle.setVisibility(response ? View.INVISIBLE : View.VISIBLE);
                    }
                    if (documentTitleTutorial != null)
                        documentTitleTutorial.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getTextViewOfDocumentMutableLiveData().observe(getViewLifecycleOwner(), response ->
        {
            if (response != null) {
                if (documentBorderTextView != null)
                    documentBorderTextView.setVisibility(response ? View.VISIBLE : View.GONE);
            }
        });
        cameraViewModel.getNextButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    View view = getCustomShape();
                    if (view == null) {
                        return;
                    }
                    if (view instanceof CustomViewHolder) {
                        CustomViewHolder customViewHolder = (CustomViewHolder) view;
                        if (customViewHolder.getShouldDrawRectangle()) {
                            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                                    response ? R.color.idenfyCameraBackArrowResultsColor :
                                            R.color.idenfyCameraBackArrowPreviewColor));
                            customViewHolder.changeTransparentBackgroundVisibility(response ? false : true);
                            customViewHolder.invalidate();
                        }
                    }
                    if (customFocusView != null)
                        customFocusView.setEnabled(!response);
                    canFocus.set(!response);
                    nextButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                } else {
                    if (customFocusView != null) {
                        customFocusView.setEnabled(true);
                    }
                }
            }
        });
        cameraViewModel.getActionButtonVisibility().observe(this, new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCameraViewVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    cameraView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


    }


    ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener() {
        @Override
        public boolean onPreDraw() {
            int width = rootView.getWidth();
            int height = rootView.getHeight();
            RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, currentDocumentType != null ? currentDocumentType.getProportions() : 30f / 19f);
            if (visibleArea == null) {
                setupImageView(currentDocumentType);
            } else {
                final double xPositionRatio = visibleArea.left / width;
                final double yPositionRatio = visibleArea.top / height;
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, currentDocumentType);
            }
            rootView.getViewTreeObserver().removeOnPreDrawListener(this);
            return true;
        }
    };


    public void setupDocumentView(@Nullable DocumentType document) {
        if (document != DocumentType.FACE_PHOTO) {

            cameraViewModel.setTextViewOfDocumentMutableLiveData(true);
            if (fotoapparatFocusView != null)
                fotoapparatFocusView.setVisibility(View.VISIBLE);
            if (customFocusView != null)
                customFocusView.setEnabled(true);
            if (imageViewResultTitle != null)
                imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraResultsTitle));
            int width = rootView.getWidth();
            int height = rootView.getHeight();

            rootView.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);
        } else {
            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                    R.color.idenfyCameraBackArrowResultsColor));
            if (fotoapparatFocusView != null)
                fotoapparatFocusView.setVisibility(View.INVISIBLE);
            if (imageViewResultTitle != null)
                imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraInformationTitle));
            if (documentTitleTutorial != null)
                documentTitleTutorial.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraResultsTitle));
            int width = rootView.getWidth();
            int height = rootView.getHeight();
            if (customFocusView != null)
                customFocusView.setEnabled(false);
            RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, document != null ? document.getProportions() : 30f / 19f);
            if (visibleArea == null) {
                setupImageView(document);
            } else {
                final double xPositionRatio = visibleArea.left / width;
                final double yPositionRatio = visibleArea.top / height;
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, document);
            }
        }
    }


    private void setupImageViewWithScalledImage(final double xPositionRatio, final double yPositionRatio,
                                                DocumentType documentType) {
        if (documentType == DocumentType.ID_CARD_FRONT || documentType == DocumentType.PASSPORT || documentType == DocumentType.ID_CARD_BACK) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
            final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            int horizontalMargin = (int) (parent.getWidth() * xPositionRatio);
            int verticalMargin = (int) (parent.getHeight() * yPositionRatio);
            params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            imageView.setLayoutParams(params);

            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                determineValuesForDocument(parentWidth, parentHeight, horizontalMargin, verticalMargin);
                customViewHolder.setValuesForRectangle(rectangleLeft,
                        rectangleTop,
                        rectangleRight,
                        rectangleBottom);
                customViewHolder.invalidate();
            }
            setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth);
        }

    }

    private void setupValuesForCropping(int verticalMargin, int horizontalMargin, int parentHeight, int parentWidth) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin;
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2;
        widthOfImage = parentWidth;
        xCoordinateOfWidthStart = 0;
    }

    private void determineValuesForDocument(int parentWidth, int parentHeight, int horizontalMargin, int verticalMargin) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        if (this.rectangleLeft > this.rectangleRight) {
            int c = this.rectangleLeft;
            int k = this.rectangleRight;
            this.rectangleRight = c;
            this.rectangleLeft = k;
        }
    }

    private View getCustomShape() {
        if (customShapes != null)
            if (!(customShapes.getChildAt(0) == null)) {
                return customShapes.getChildAt(0);
            }
        return null;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD);
            backTextView.setTypeface(typeface);
            imageViewResultTitle.setTypeface(typeface);
            documentTitleTutorial.setTypeface(typeface);
            nextButton.setTypeface(typeface);
            retakeButton.setTypeface(typeface);
        }
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (canFocus.get()) {
                        switch (event.getAction()) {
                            case MotionEvent.ACTION_DOWN:

                                if (cameraViewModel.getNextButtonVisibility().getValue() != null && !cameraViewModel.getNextButtonVisibility().getValue())
                                    if (canFocus.get()) {
                                        return false;
                                    } else {
                                    }
                        }
                        return false;
                    } else {
                        return true;
                    }
                }

            });


        setupFocus();
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();


    }

    private void observeButtonsAvailability() {
        cameraViewModel.getNextButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    nextButton.setEnabled(response);

                }
            }
        });
        cameraViewModel.getRecreateButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    retakeButton.setEnabled(aBoolean);
            }
        });
        cameraViewModel.getTakePictureButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupFocus() {
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (canFocus.get()) {
                        if (fotoapparat != null) {
                            canFocus.set(false);
                            fotoapparat.getCurrentParameters().whenDone(new WhenDoneListener<CameraParameters>() {
                                @Override
                                public void whenDone(@org.jetbrains.annotations.Nullable CameraParameters cameraParameters) {
                                    if (cameraParameters != null)
                                        if (!cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                            if (fotoapparat != null) {
                                                fotoapparat.updateConfiguration(
                                                        UpdateConfiguration.builder().focusMode(
                                                                firstAvailable(autoFocus())).build());
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                            if (cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                        }
                                }
                            });
                        }
                    }
                }
            });
        if (customFocusView != null)
            customFocusView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (canFocus.get()) {
                        if (fotoapparat != null) {
                            canFocus.set(false);
                            fotoapparat.getCurrentParameters().whenDone(new WhenDoneListener<CameraParameters>() {
                                @Override
                                public void whenDone(@org.jetbrains.annotations.Nullable CameraParameters cameraParameters) {
                                    if (cameraParameters != null)
                                        if (!cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                            if (fotoapparat != null) {
                                                fotoapparat.updateConfiguration(
                                                        UpdateConfiguration.builder().focusMode(
                                                                firstAvailable(autoFocus())).build());
                                                fotoapparat.focus().whenDone(new WhenDoneListener<FocusResult>() {
                                                    @Override
                                                    public void whenDone(@org.jetbrains.annotations.Nullable FocusResult focusResult) {
                                                    }
                                                });
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                        } else if (cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                            if (fotoapparat != null) {
                                                fotoapparat.focus();
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 2500);
                                            }
                                        }

                                }
                            });
                        }
                    }
                }
            });

    }

    private void setupImageView(DocumentType documentType) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
        final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
        int horizontalMargin = (int) (parent.getWidth());
        int verticalMargin = (int) (parent.getHeight());
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        imageView.setLayoutParams(params);
        if (documentType == DocumentType.FACE_PHOTO) {
            customShapes.setVisibility(View.GONE);

            isShouldersViewVisibile(true);

        }


    }

    private void isShouldersViewVisibile(Boolean visible) {
        topIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
        faceShoulderOverlay.setVisibility(visible ? View.VISIBLE : View.GONE);
        bottomIvShoulder.setVisibility(visible ? View.VISIBLE : View.GONE);
    }


    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                takePictureHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (getActivity() != null) {
                            takePicture();
                        }
                    }

                }, BUTTON_DELAY_FOR_UX);

            }
        });


    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new CustomFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (cameraView != null) {
            requireActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    show(BitmapPhotoCropper.
                            cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                    currentDocumentType), currentDocumentType);


                }
            });


        }
    }


    private void retakePhotoPressed(Bitmap bitmap) {
        cameraViewModel.setNextButtonAvailability(false);
        cameraViewModel.setRecreateButtonAvailability(false);
        cameraViewModel.setTakePictureButtonAvailability(true);
        recreateButtonHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                recreateImage();
            }

        }, BUTTON_DELAY_FOR_UX);
    }

    private Bitmap facePhoto;

    public void show(final Bitmap bitmap, DocumentType type) {

        if (currentDocumentType == DocumentType.FACE_PHOTO)
            isShouldersViewVisibile(false);
        cameraViewModel.setShowImageLayoutVisibility(true);
        cameraViewModel.setImageViewResultTitleMutableLiveData(type);
        if (type == DocumentType.FACE_PHOTO) {
            if (imageViewFullScreenResult != null) {
                cameraViewModel.setImageViewResultFullSize(true);
                imageViewFullScreenResult.setImageBitmap(bitmap);
            }
        } else {
            cameraViewModel.setImageViewResult(true);
            if (imageViewResult != null) {
                ViewGroup.LayoutParams params = imageViewResult.getLayoutParams();
                params.width = rectangleRight - rectangleLeft;
                params.height = rectangleBottom - rectangleTop;
                imageViewResult.setLayoutParams(params);
                imageViewResult.setImageBitmap(bitmap);
            }
        }
        cameraViewModel.setTextViewOfDocumentMutableLiveData(false);
        cameraViewModel.setRecreateButtonVisibility(true);
        cameraViewModel.setNextButtonAvailability(true);
        cameraViewModel.setRecreateButtonAvailability(true);
        cameraViewModel.setNextButtonVisibility(true);
        cameraViewModel.setDocumentTutorialTitleVisibility(false);
        cameraViewModel.setActionButtonVisibility(false);

        retakeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                retakePhotoPressed(bitmap);

            }
        });

        nextButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View view) {

                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextButtonHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {

                        nextStep(bitmap);

                    }

                }, BUTTON_DELAY_FOR_UX);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    public void nextStep(Bitmap bitmap) {

        cameraViewModel.setupNewDocument(bitmap);
    }


    public void recreateImage() {
        cameraViewModel.changeDocument(currentDocumentType, true);
    }

    private Integer setupTitles(DocumentType documentType) {
        Integer titleName = -1;
        switch (documentType) {
            case PASSPORT:
                titleName = R.string.document_type_text;
                break;
            case ID_CARD_FRONT:
                titleName = R.string.document_type_id_card_front;
                break;
            case ID_CARD_BACK:
                titleName = R.string.document_type_id_card_back;
                break;
            case FACE_PHOTO:
                titleName = R.string.document_face_photo;
                break;
        }
        return titleName;
    }


    @Override
    public void onPause() {
        super.onPause();

    }

    @Override
    public void onStop() {
        super.onStop();
        if (frameProcessor != null) {
            frameProcessor = null;
        }
        if (fotoapparat != null) {
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (fotoapparat != null) {
                        fotoapparat.stop();
                        fotoapparat = null;
                    }

                }
            }, 300);
        }


    }

    @Override
    public void onStart() {
        super.onStart();
        Activity activity = getActivity();
        if (isAdded() && activity != null) {

            if (frameProcessor == null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            if (fotoapparat != null) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (fotoapparat != null)
                            fotoapparat.start();
                    }
                }, 200);
            } else {
                fotoapparatSetupHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        setupCamera();

                    }
                }, 200);
            }

        }
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroyView() {
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        onPreDrawListener = null;
        super.onDestroyView();
        backTextView = null;
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        onPreDrawListener = null;
        backImage = null;
        imageViewFullScreenResult = null;
        imageViewResult = null;
        imageInfoLayout = null;
        cameraView = null;
        fotoapparatFocusView = null;
        documentTitleTutorial = null;
        imageViewResultTitle = null;
        nextButton = null;
        retakeButton = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        if (customShapes != null) {

            for (int i = 0; i < customShapes.getChildCount(); i++) {
                if (customShapes.getChildAt(i) != null) {
                    customShapes.removeViewAt(i);
                }
            }
            customShapes = null;
        }
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }

    public void setupCamera() {

        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            if (fotoapparatFocusView != null) {
                fotoapparat = Fotoapparat
                        .with(getActivity())
                        .into(cameraView)
                        .previewScaleType(ScaleType.CenterCrop)
                        .previewResolution(highestResolution())
                        .lensPosition(isBackCamera ? back() : front())
                        .focusMode(firstAvailable(
                                continuousFocusPicture(),
                                continuousFocusVideo(),
                                autoFocus(),
                                fixed()
                        ))
                        .focusView(fotoapparatFocusView)
                        .photoResolution(ResolutionSelectorsKt.highestResolution())
                        .frameProcessor(new CustomFrameProcessor(getActivity()))
                        .logger(
                                LoggersKt.logcat()
                        )
                        .cameraErrorCallback(new CameraErrorListener() {
                            @Override
                            public void onError(@NonNull CameraException e) {
                            }
                        })
                        .build();
                fotoapparat.start();
            } else {
                fotoapparat = Fotoapparat
                        .with(getActivity())
                        .into(cameraView)
                        .previewScaleType(ScaleType.CenterCrop)
                        .previewResolution(highestResolution())
                        .lensPosition(isBackCamera ? back() : front())
                        .focusMode(firstAvailable(
                                continuousFocusPicture(),
                                continuousFocusVideo(),
                                autoFocus(),
                                fixed()
                        ))
                        .photoResolution(ResolutionSelectorsKt.highestResolution())
                        .frameProcessor(new CustomFrameProcessor(getActivity()))
                        .logger(
                                LoggersKt.logcat()
                        )
                        .cameraErrorCallback(new CameraErrorListener() {
                            @Override
                            public void onError(@NonNull CameraException e) {
                            }
                        })
                        .build();
                fotoapparat.start();
            }

        }
    }

    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);

    }


}
