package com.idenfy.idenfySdk.iDenfySDKSetup;

import android.graphics.Typeface;

public class IdenfyUISettings {

    private Integer customResultsViewSpinner = null;
    private boolean isActionBarEnabled = true;
    private String customFontPath;

    public Integer getCustomResultsViewSpinner() {
        return customResultsViewSpinner;
    }

    public void setCustomResultsViewSpinner(Integer customResultsViewSpinner) {
        this.customResultsViewSpinner = customResultsViewSpinner;
    }

    public boolean isActionBarEnabled() {
        return isActionBarEnabled;
    }

    public void setActionBarEnabled(boolean actionBarEnabled) {
        isActionBarEnabled = actionBarEnabled;
    }

    public String getCustomFontPath() {
        return customFontPath;
    }

    public void setCustomFontPath(String customFontPath) {
        this.customFontPath = customFontPath;
    }

    private IdenfyUISettings(IdenfyUIBuilder idenfyUIBuilder) {
        customResultsViewSpinner = idenfyUIBuilder.customResultsViewSpinner;
        isActionBarEnabled = idenfyUIBuilder.isActionBarEnabled;
        customFontPath = idenfyUIBuilder.customFontPath;
    }

    IdenfyUISettings() {

    }

    public static class IdenfyUIBuilder {
        private boolean optionalResultsChecking = false;
        private boolean setupAgreementFragment = true;
        private Typeface font;
        private Typeface fontBold;
        private String customFontPath;
        private Integer customBackgroundPath = -1;
        private Integer customResultsViewSpinner = null;
        private boolean isActionBarEnabled = true;


        public IdenfyUIBuilder withTypefacePath(String pathOfTypeface) {
            this.customFontPath = pathOfTypeface;
            return this;
        }

        public IdenfyUIBuilder withCustomLoadingView(Integer customLoadingView) {
            this.customResultsViewSpinner = customLoadingView;
            return this;
        }


        public IdenfyUIBuilder withAppBarLayoutEnabled(boolean isActionBarEnabled) {
            this.isActionBarEnabled = isActionBarEnabled;
            return this;
        }

        public IdenfyUISettings build() {
            return new IdenfyUISettings(this);
        }

    }
}


