package com.idenfy.idenfySdk.helpers.enums;

import android.support.annotation.NonNull;

import com.idenfySdk.R;

import java.util.ArrayList;

import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.BACK_FILENAME;
import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.FACE_FILENAME;
import static com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel.FRONT_FILENAME;

public enum DocumentType {

    ID_CARD_FRONT(R.string.document_type_id_card, R.drawable.ic_idenfy_national_identity) {
        @Override
        public String getDocumentSetName() {
            return "ID_CARD";
        }

        @Override
        public int getFront() {
            return R.string.document_type_id_card_front_info;
        }

        @Override
        public int getBack() {
            return R.string.document_type_id_card_back_info;
        }

        @Override
        public double getProportions() {
            return 30f / 19f;
        }


        @Override
        protected boolean isDifferentType() {
            return true;
        }

    },
    PASSPORT(R.string.document_type_passport, R.drawable.ic_idenfy_passport) {
        @Override
        public int getFront() {
            return R.string.document_type_passport_info;
        }

        @Override
        public int getBack() {
            return getFront();
        }

        @Override
        public double getProportions() {
            return 125f / 87f;
        }

        @Override
        protected boolean isDifferentType() {
            return true;
        }

        @Override
        public String getDocumentSetName() {
            return "PASSPORT";
        }
    },
    ID_CARD_BACK(R.string.document_type_id_card, R.drawable.ic_idenfy_national_identity) {
        @Override
        public int getFront() {
            return R.string.document_type_id_card_back_info;
        }

        @Override
        public int getBack() {
            return R.string.document_type_id_card_back_info;
        }

        @Override
        public double getProportions() {
            return 30f / 19f;
        }


        @Override
        protected boolean isDifferentType() {
            return false;
        }


        @Override
        public String getDocumentSetName() {
            return null;
        }
    },
    FACE_PHOTO(0, 0) {
        @Override
        public int getFront() {
            return 0;
        }

        @Override
        public int getBack() {
            return 0;
        }

        @Override
        public double getProportions() {
            return -1;
        }

        @Override
        protected boolean isDifferentType() {
            return false;
        }


        @Override
        public String getDocumentSetName() {
            return null;
        }


    },
    OCR_TEXT(0, 0) {
        @Override
        public int getFront() {
            return 0;
        }

        @Override
        public int getBack() {
            return 0;
        }

        @Override
        public double getProportions() {
            return 0;
        }

        @Override
        protected boolean isDifferentType() {
            return false;
        }

        @Override
        public String getDocumentSetName() {
            return null;
        }


    };

    @NonNull
    private static ArrayList<Integer> getIntegersFromString(String input) {
        String rs = input.replaceAll("<", "0").replaceAll("\n", "");
        ArrayList<Integer> data = new ArrayList<>();
        for (char ch : rs.toCharArray()) {
            if (ch >= 'A' && ch <= 'Z') {
                final int number = (ch - 'A' + 10);
                data.add(number);
            } else if (ch >= '0' && ch <= '9') {
                data.add((int) ch - '0');
            }
        }
        return data;
    }

    public static final String TAG = "DocumentType";

    private int nameStringId;
    private int imageResId;

    DocumentType(int nameStringId, int imageResId) {
        this.nameStringId = nameStringId;
        this.imageResId = imageResId;
    }

    private boolean showFront = true;

    public abstract int getFront();

    public abstract int getBack();

    public abstract double getProportions();


    protected abstract boolean isDifferentType();

    public abstract String getDocumentSetName();


    public int getInfo() {
        if (showFront) {
            return getFront();
        }
        return getBack();
    }

    public int getNameStringId() {
        return nameStringId;
    }

    public int getImageResId() {
        return imageResId;
    }


    public void setShowFront(boolean showFront) {
        this.showFront = showFront;
    }

    public static DocumentType[] getValues() {
        ArrayList<DocumentType> types = new ArrayList<>();

        for (DocumentType type : DocumentType.values()) {
            if (type.isDifferentType()) {
                types.add(type);
            }
        }

        return types.toArray(new DocumentType[types.size()]);
    }


    public String getFilename() {
        switch (this) {
            case PASSPORT:
                return FRONT_FILENAME;
            case ID_CARD_FRONT:
                return FRONT_FILENAME;
            case ID_CARD_BACK:
                return BACK_FILENAME;
            case FACE_PHOTO:
                return FACE_FILENAME;
        }

        return "";
    }

    public String getDocumnetType() {
        switch (this) {
            case ID_CARD_FRONT:
                return "FRONT";
            case ID_CARD_BACK:
                return "BACK";
            case FACE_PHOTO:
                return "FACE";
            case PASSPORT:
                return "FRONT";
        }
        return "";
    }
}
