package com.idenfy.idenfySdk.UI.MainActivity;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfySdk.R;

public class DocumentsRecyclerViewAdapter extends RecyclerView.Adapter<DocumentsRecyclerViewAdapter.ViewHolder> {

    private DocumentType[] documentTypes;
    private View.OnClickListener onClickListener;
    private Context mContext;
    private Typeface typeface;

    public interface onItemClickListener {
        void onClick(DocumentType type);
    }

    public DocumentsRecyclerViewAdapter(@NonNull DocumentType[] types, final onItemClickListener listener, Context context, Typeface idenfyBold) {
        documentTypes = types;
        this.typeface = idenfyBold;


        onClickListener = new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                DocumentType type = (DocumentType) view.getTag();
                type.setShowFront(true);
                listener.onClick(type);
            }
        };

    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.idenfy_documents_type_item, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        DocumentType type = documentTypes[position];
        holder.textView.setText(type.getNameStringId());
        if(type==DocumentType.ID_CARD_FRONT)
        holder.imageView.setImageResource(R.drawable.ic_idenfy_national_identity);
        else if(type==DocumentType.PASSPORT)
        {
            holder.imageView.setImageResource(R.drawable.ic_idenfy_passport);
        }
        holder.textView.setTypeface(typeface);
        holder.itemView.setOnClickListener(onClickListener);
        holder.itemView.setTag(type);
    }

    @Override
    public int getItemCount() {
        return documentTypes.length;
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView textView;

        ViewHolder(View itemView) {

            super(itemView);
            imageView = itemView.findViewById(R.id.idenfy_document_icon);
            textView = itemView.findViewById(R.id.idenfy_document_text_view);

        }
    }
}
