package com.idenfy.idenfySdk.UI.MainActivity;

import android.Manifest;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDelegate;

import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.Networking.Resource;
import com.idenfy.idenfySdk.Networking.Status;
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.ProcessUploadCompletion;
import com.idenfy.idenfySdk.UI.AuthenticationResultView.AuthenticationResultFragment;
import com.idenfy.idenfySdk.UI.CameraView.CameraNewFragment;
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country;
import com.idenfy.idenfySdk.UI.InitialAgreementView.InitialAgreementFragmnet;
import com.idenfy.idenfySdk.UI.SplashScreenFragment.SplashScreenFragment;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.DocumentWrapper;
import com.idenfy.idenfySdk.helpers.enums.AuthentificationResult;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;


public class CameraPreviewActivity extends AppCompatActivity implements
        AuthenticationResultFragment.OnAuthenticationResultFragmentClosed,
        CameraNewFragment.OnCameraClosedFragment, InitialAgreementFragmnet.OnFragmentInteractionListener,
        AuthenticationResultFragment.RetakeStepsListListener,
        SplashScreenFragment.OnFragmentInteractionListener, DocumentsRecyclerViewAdapter.onItemClickListener {

    private CameraViewModel cameraViewModel;
    private DocumentType selectedDocument;
    private RecyclerView recyclerView;
    private TextView toolbarTitle;
    private TextView selectDocumentType;
    private String authneticationResultResponse = "authneticationResultResponse";
    private String idenfyError = "idenfyError";
    private String settings = "settings";
    private boolean cameraPermissionWasRequested=false;


    private void fetchCountriesList() {
        cameraViewModel.fetchCountriesList();
    }

    private String AUTH_FRAGMENT = "AuthenticationFragment";
    private int REQUEST_PERMISSIONS_CAMERA = 44444;
    private String SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment";
    private String CAMERA_NEW_FRAGMENT = "CameraNewFragment";
    private String INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment";
    private int delay = 700;
    private boolean mReturningWithResult;
    public static final String loadingLiveDataCountriesKey = "CountriesList";
    public static final String loadingLiveDataAuthTokenKey = "AuthToken";
    public static final String loadingLiveDataFirstCountryKey = "FirstCountry";


    private Integer idenfyErrorDelayClosing = 1000;
    private Integer idenfySuccessDelayClosing = 1200;

    private boolean isDocumentItemPressed;
    private boolean isOnPausedCalled = false;
    private boolean wasPermissionRequested = false;

    private Handler successHandler = new Handler();
    private Handler errorHandler = new Handler();
    private Handler checkResultsDelayHandler = new Handler();

    private AppCompatImageView backButton;

    String logResults = "LogResults";

    private void addAuthenticationResultFragment() {
        cameraViewModel.setNextButtonVisibility(true);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        AuthenticationResultFragment authenticationResultFragment = new AuthenticationResultFragment();
        transaction.replace(R.id.newMain, authenticationResultFragment, AUTH_FRAGMENT);
        transaction.commit();
    }

    private String activityLifecycle = "activityLifecycle";

    @Override
    public void onCreate(Bundle savedInstanceState) {

        cameraViewModel = ViewModelProviders.of(this).get(CameraViewModel.class);
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        restoreAppAfterDeath(savedInstanceState);
        //NON UI RELATED
        observeCountriesList();
        observeProccessUploadCompletion();
        observeUploadsFinished();
        observeSDKResponse();
        //UI initialization
        setContentView(R.layout.activity_main_new);
        initializeUI(savedInstanceState);

        //Observation
        observeCameraFragment();
        observeAuthenticationResultFragment();
        observeSdkInitialLoading();
        observeInitialAgreementFragment();
    }


    private void observeOptionalResultsChecking() {
        cameraViewModel.optionalResultsCheckingMutableLiveData.observe(this, response ->
        {
            if (response != null) {
                if (response) {
                    HashMap<DocumentType, Boolean> hashMap = cameraViewModel.getUploadsFinished().getValue();
                    if (hashMap != null) {
                        for (Map.Entry<DocumentType, Boolean> entry : hashMap.entrySet()) {


                        }
                    }
                }
            }
        });
    }


    private void setupRestoredValues() {

        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings.getCustomFontPath() != null) {

            Typeface customFont = null;
            try {
                customFont = Typeface.createFromAsset(getApplicationContext().getAssets(), idenfySettings.getCustomFontPath());
                idenfySettings.setCustomTypeface(customFont);
            } catch (Exception e) {
                //   Toast.makeText(this, "errrrooo", Toast.LENGTH_SHORT).show();
                e.printStackTrace();
            }

        }

    }

    private void observeInitialAgreementFragment() {
        cameraViewModel.addInitialAgreementFragmentLiveData().observe(this, canAdd ->
        {
            if (canAdd != null) {
                if (canAdd) {
                    if(toolbarTitle!=null)
                    toolbarTitle.setText(getResources().getString(R.string.start_identity_verification));
                    addInitialAgrrementFragment();

                } else {

                    removeInitialAgrrementFragment();
                    if(toolbarTitle!=null)
                    toolbarTitle.setText("iDenfy");
                  //  getCameraPermission();
                }
            }
        });
    }

    public void removeCameraFragment() {
        Fragment cameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        if (cameraFragment != null) {
            getSupportFragmentManager().beginTransaction().remove(cameraFragment).commit();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment == null) {
            removeFragmentsForRestarting();
            isOnPausedCalled = false;
            reInitViewModelLogic();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
        Log.d("onPause", "onPostrResume");
        if (mReturningWithResult) {
            Log.d("onPause", "onPoostResumeInside");
            if (this.selectedDocument != null) {
                observeIfCanSetupCameraFragment(this.selectedDocument);
                cameraViewModel.setDocumentType(this.selectedDocument);
                mReturningWithResult=false;
            }
        }
    }

    @Override
    protected void onStop() {

        super.onStop();

    }

    @Override
    protected void onPause() {
        super.onPause();
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        if (fragment == null) {
            if (!isOnPausedCalled) {
                Log.d("onPause", "regular");
                isOnPausedCalled = true;
            }
            if(cameraPermissionWasRequested )
            {
                Log.d("onPause", "camera");
            }
        }
    }


    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (cameraViewModel.getIdenfyError().getValue() != null) {
            IdenfyError idenfyError = cameraViewModel.getIdenfyError().getValue();
            outState.putParcelable(this.idenfyError, idenfyError);
        }
        if (cameraViewModel.authneticationResultResponse.getValue() != null) {
            if (cameraViewModel.authneticationResultResponse.getValue().data != null) {
                if (cameraViewModel.authneticationResultResponse.getValue().data.
                        getIdentificationStatus() != null && cameraViewModel.authneticationResultResponse.getValue().data.
                        getIdentificationStatus().equalsIgnoreCase("APPROVED")) {
                    outState.putParcelable(authneticationResultResponse, cameraViewModel.authneticationResultResponse.getValue().data);
                }
            }
        }
        outState.putParcelable(settings, IdenfyController.getInstance().getSettings());
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onDestroy() {
        if (recyclerView != null) {
            recyclerView.setAdapter(null);
            recyclerView.setLayoutManager(null);
            recyclerView.addItemDecoration(null);
            recyclerView = null;
        }
        if (errorHandler != null)
            errorHandler.removeCallbacksAndMessages(null);
        if (successHandler != null)
            successHandler.removeCallbacksAndMessages(null);
        if (checkResultsDelayHandler != null)
            checkResultsDelayHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        if (item.getItemId() == android.R.id.home) {
            onBackPressed(); // close this activity and return to preview activity (if there is any)
        }

        return super.onOptionsItemSelected(item);
    }

    private void initializeUI(Bundle savedInstanceState) {
        toolbarTitle = findViewById(R.id.toolbar_title);
        selectDocumentType = findViewById(R.id.select_document_type);
        appBarLayout = findViewById(R.id.app_bar_layout);
        if(toolbarTitle!=null)
        toolbarTitle.setText("iDenfy");
        try {
            backButton = findViewById(R.id.backImage);
            backButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(savedInstanceState==null)
        addSplashScreenFragment();
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        Objects.requireNonNull(getSupportActionBar()).setElevation(4);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        getSupportActionBar().setTitle("");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_NOSENSOR);
        setTheme(R.style.IdenfyTheme);
        initRecyclerView();
        setupCustomDesign();


    }

    private void setupCustomDesign()
    {
        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings != null) {
            setupFonts();
            enableActionBar(idenfySettings.getActionBarEnabled());
        }
    }
    private void enableActionBar(Boolean isActionBarEnabled) {
        appBarLayout.setVisibility(isActionBarEnabled?View.VISIBLE:View.GONE);

    }

    private void setupFonts() {
        IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
        if (idenfySettings != null) {
            if(selectDocumentType!=null)
            selectDocumentType.setTypeface((idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)));
            if(toolbarTitle!=null)
            toolbarTitle.setTypeface((idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)));
        }
    }

    private void addSplashScreenFragment() {
        if(!IdenfyController.getInstance().getSettings().isCustomIdentificationLayout()) {
            SplashScreenFragment cameraNewFragment = new SplashScreenFragment();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.splash_screen, cameraNewFragment, SPLASH_SCREEN_FRAGMENT)
                    .commit();
        }
    }

    private void observeCountriesList()

    {
        cameraViewModel.getCountryFromIPLiveDataAndDecideToShowFragment().observe(this, response ->
        {
            cameraViewModel.getCountriesListMutableLiveData().observe(this, countriesList ->
            {
                if (response != null) {
                    Country firstCountry = null;
                    int sameIndex = 0;
                    if (response.status == Status.SUCCESS) {
                        if (countriesList != null && countriesList.status == Status.SUCCESS) {

                            for (int i = 0; i < Objects.requireNonNull(countriesList.data).size(); i++) {
                                if (countriesList.data.get(i).getCountryISO().
                                        equalsIgnoreCase(response.data)) {
                                    firstCountry = countriesList.data.get(i);
                                    sameIndex = i;
                                }
                                if (firstCountry != null) {
                                    countriesList.data.add(0, firstCountry);
                                    countriesList.data.remove(sameIndex + 1);
                                    break;
                                }
                            }
                            cameraViewModel.setCountriesList(countriesList);
                        }
                    }
                    if (response.status == Status.ERROR) {
                        if (countriesList != null)
                            cameraViewModel.setCountriesList(countriesList);
                    }
                }
            });
        });
    }


    private boolean checkIfNewVersionOfInitialization() {
        if (IdenfyController.getInstance().getSettings().isNewWayOfIdentification()) {
            return true;
        }
        return false;
    }

    private void restoreAppAfterDeath(Bundle savedInstanceState) {

        IdenfySettings idenfySettingsRestored = null;
        if (savedInstanceState != null) {
            if (savedInstanceState.getParcelable(idenfyError) != null) {
                IdenfyError idenfyError = savedInstanceState.getParcelable(this.idenfyError);
                if (idenfyError != null) {
                    IdenfyController.idenfyError = idenfyError.getIdenfyErrorResponse();
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                }
            }
            if (savedInstanceState.getParcelable(authneticationResultResponse) != null) {
                IdenfyController.authenticationResultResponse = savedInstanceState.getParcelable(authneticationResultResponse);
                deleteCache(CameraPreviewActivity.this);
                finish();
            }

            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false);
            if (savedInstanceState.getParcelable(settings) != null) {
                IdenfyController.getInstance().setSettings(Objects.requireNonNull(savedInstanceState.getParcelable(settings)));
                if (checkIfNewVersionOfInitialization()) {
                    initialRequests(true);
                } else {
                    deleteCache(this);
                    finish();
                }
            }

        } else {
            initialRequests(false);
        }
    }

    private void observeProccessUploadCompletion() {
        cameraViewModel.getProcessUploadCompletion().observe(this, uploadCompleted ->
        {
            if (uploadCompleted != null) {
                if (uploadCompleted.status == Status.SUCCESS)
                    checkResultsDelayHandler.postDelayed(new Runnable() {
                        @Override
                        public void run() {

                            cameraViewModel.startCheckingForAuthenticationesults();
                        }

                    }, cameraViewModel.CHECKING_RESULTS_PINNING_DELAY);
            }
        });
    }

    private void observeUploadsFinished() {
        cameraViewModel.getUploadsFinished().observe(this, response ->
        {
            if (response != null) {
                if (response.containsKey(DocumentType.ID_CARD_FRONT) && response.get(DocumentType.ID_CARD_FRONT)
                        && response.containsKey(DocumentType.ID_CARD_BACK)
                        &&
                        response.get(DocumentType.ID_CARD_BACK)
                        && response.containsKey(DocumentType.FACE_PHOTO) &&
                        response.get(DocumentType.FACE_PHOTO)) {

                    cameraViewModel.startProcessing();
                    if (IdenfyController.getInstance().getSettings().getHandleResultsChecking() != null
                            && IdenfyController.getInstance().getSettings().getHandleResultsChecking()) {
                        IdenfyController.processUploadCompletion = new ProcessUploadCompletion();
                        IdenfyController.processUploadCompletion.setBackIdUploaded(true);
                        IdenfyController.processUploadCompletion.setFaceImageUploaded(true);
                        IdenfyController.processUploadCompletion.setFrontIdUploaded(true);
                    }
                }
                if (response.containsKey(DocumentType.PASSPORT) && response.get(DocumentType.PASSPORT)
                        && response.containsKey(DocumentType.FACE_PHOTO) &&
                        response.get(DocumentType.FACE_PHOTO)) {
                    if (IdenfyController.getInstance().getSettings().getHandleResultsChecking()) {
                        IdenfyController.processUploadCompletion = new ProcessUploadCompletion();
                        IdenfyController.processUploadCompletion.setPassportUploaded(true);
                        IdenfyController.processUploadCompletion.setFaceImageUploaded(true);
                    }
                    cameraViewModel.startProcessing();
                }
            }
        });
    }

    private void setupCustomLocale() {
        if (IdenfyController.getInstance().getSettings().getCustomLocale() != null) {
            Configuration config = this.getResources().getConfiguration();
            Locale locale = new Locale(IdenfyController.getInstance().getSettings().getCustomLocale());
            Locale.setDefault(locale);
            config.locale = locale;
            this.getBaseContext().getResources().updateConfiguration(config,
                    this.getBaseContext().getResources().getDisplayMetrics());
        }
    }

    private void initialRequests(boolean isSavedInstance) {
        if (IdenfyController.getInstance().getSettings() == null) {
            IdenfyController.exitCode = new ExitCode(1);
            deleteCache(CameraPreviewActivity.this);
            finish();
        } else {

            if(!IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
            {
             cameraViewModel.startSession();
            }
            setupRestoredValues();
            setupCustomLocale();
            if(!isSavedInstance) {

                cameraViewModel.setDeviceTypeForAPI();
                cameraViewModel.fetchPartnerInfo();
                fetchCountriesList();
                if (IdenfyController.getInstance().getSettings().getIssuingCountry() == null)
                    cameraViewModel.fetchCountryByIp();
                else {
                    cameraViewModel.setCountryForDocumentRequest(IdenfyController.getInstance().getSettings().getIssuingCountry());
                    cameraViewModel.setFirstIssuingCountry(IdenfyController.getInstance().getSettings().getIssuingCountry());
                    cameraViewModel.setCountrySelectionAvailabilityMutableLiveData(false);
                }
            }
            else
            {
                cameraViewModel.isRecyclerViewEnabled = true;
                removeSplashScreenFragment();
            }
        }
    }

    private void observeCameraFragment() {
        cameraViewModel.getAddCameraFragment().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null && aBoolean) {

                    addCameraFragment();
                }
            }
        });
    }

    private void observeAuthenticationResultFragment() {
        cameraViewModel.getAuthenticationResultFragmentLiveData().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (response) {
                        CameraPreviewActivity.this.addAuthenticationResultFragment();
                    } else {
                        removeAuthenticationResultFragment();
                    }
                }
            }
        });
    }

    private void observeSdkInitialLoading() {
        cameraViewModel.mainLoadingMediatorLiveDara.observe(this, response ->
        {
            if (response != null && response.status == Status.SUCCESS) {

                if ((response.data != null) && response.data.containsKey(
                        loadingLiveDataCountriesKey) &&
                        response.data.get(loadingLiveDataCountriesKey)
                        && response.data.containsKey(loadingLiveDataAuthTokenKey)
                        && response.data.get(loadingLiveDataAuthTokenKey)
                        && response.data.containsKey(loadingLiveDataFirstCountryKey) &&
                        response.data.get(loadingLiveDataFirstCountryKey)) {
                    if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                        cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                    else
                        cameraViewModel.isRecyclerViewEnabled = true;
                    removeSplashScreenFragment();
                } else if (response.data != null &&
                        response.data.containsKey(loadingLiveDataCountriesKey)
                        && response.data.get(loadingLiveDataCountriesKey)
                        && response.data.containsKey(loadingLiveDataAuthTokenKey) &&
                        response.data.get(loadingLiveDataAuthTokenKey)) {
                    if (IdenfyController.getInstance().getSettings().getSetupAgreementFragment())
                        cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true);
                    else
                        cameraViewModel.isRecyclerViewEnabled = true;
                    removeSplashScreenFragment();
                }


            }
        });
    }

    private void observeSDKResponse() {
        cameraViewModel.getIdenfyError().observe(this, error ->
        {
            if (error != null) {
                if (error.getTerminateWithoutWaitingResult()) {
                    cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true);
                }
                errorHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (checkIfNewVersionOfInitialization()) {
                            IdenfyController.idenfyError = error.getIdenfyErrorResponse();
                            deleteCache(CameraPreviewActivity.this);
                            finish();
                        } else {
                            AuthentificationResult result = AuthentificationResult.ERROR;
                            result.message = error.getIdenfyErrorResponse().getMessage();
                            IdenfyController.getInstance().mListener.onAutentification(result);
                            finish();
                        }
                    }

                }, idenfyErrorDelayClosing);
            }
        });
        cameraViewModel.getProcessUploadCompletion().observe(this, processUploadCompletionResource ->
        {
            if (processUploadCompletionResource != null) {
                if (IdenfyController.getInstance().getSettings().getHandleResultsChecking() != null
                        && IdenfyController.getInstance().getSettings().getHandleResultsChecking()) {
                    IdenfyController.processUploadCompletion.setSuccess(true);
                }
            }
        });
        cameraViewModel.authneticationResultResponse.observe(this, response ->
        {
            if (response != null)
                if (response.data != null) {
                    if (response.data.getIdentificationStatus() != null && response.data.getIdentificationStatus().equalsIgnoreCase("APPROVED")) {
                        successHandler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                if (checkIfNewVersionOfInitialization()) {
                                    IdenfyController.authenticationResultResponse = response.data;
                                    deleteCache(CameraPreviewActivity.this);
                                    finish();
                                } else {
                                    deleteCache(CameraPreviewActivity.this);
                                    IdenfyController.getInstance().mListener.onAutentification(AuthentificationResult.SUCCESS);
                                    finish();
                                }
                            }

                        }, idenfySuccessDelayClosing);
                    }
                }

        });
    }

    private void showsnackBar(String message) {
        Snackbar mySnackbar = Snackbar.make(findViewById(R.id.newMain),
                message, Snackbar.LENGTH_SHORT);
        mySnackbar.show();
    }

    private void snackBarTokenExpired() {

    }

    private void removeInitialAgrrementFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (fragment != null) {

            cameraViewModel.isRecyclerViewEnabled = true;
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }

    }


    private void removeSplashScreenFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
        if (fragment != null) {
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }
    }


    private void addInitialAgrrementFragment() {
        Fragment initialAgreementFragment = getSupportFragmentManager().findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT);
        if (initialAgreementFragment == null) {
            InitialAgreementFragmnet cameraNewFragment = new InitialAgreementFragmnet();
            getSupportFragmentManager().
                    beginTransaction().add(R.id.setupContainer, cameraNewFragment, INITIAL_AGREEMENT_FRAGMENT)
                    .commit();
        }
    }


    private void reInitViewModelLogic() {

        DocumentWrapper documentWrapper = new DocumentWrapper(
                DocumentType.ID_CARD_FRONT,
                true, false,
                false,
                true,
                false,
                false,
                false,
                true,
                false
                , false,
                true
                , true
        );
        cameraViewModel.setDocumentTypeResponseMutableLiveData.postValue(Resource.loading(null));
        cameraViewModel.clearUploadsFinished();
        cameraViewModel.clearRetakedSteps();
        cameraViewModel.setDocumentInfo(documentWrapper);
    }


    AlertDialog restartAuthenticationDialog;

    private void showRestartAuhenticationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.start_over_alert_title);
        builder.setMessage(R.string.start_over_alert_message);
        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });
        builder.setNegativeButton(getResources().getString(R.string.yes_alert_button),
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        cameraViewModel.authneticationResultResponse.setValue(Resource.loading(null));
                        removeFragmentsForRestarting();
                        restartIdentificationLogic();
                        dialog.dismiss();
                    }
                });
        restartAuthenticationDialog = builder.create();
        restartAuthenticationDialog.show();
        restartAuthenticationDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
        restartAuthenticationDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }

    private void removeFragmentsForRestarting() {
        Fragment authenticationResultFragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        Fragment cameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        if (authenticationResultFragment != null) {
            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false);
        }
        if (cameraFragment != null) {

            removeCameraFragment();
        }
    }

    AlertDialog closeAppAlertDialog;

    private void showCloseAppAlertDialog() {


        AlertDialog.Builder builder = new AlertDialog.Builder(this);

        builder.setTitle(R.string.abort_identification_alert_title);
        builder.setMessage(R.string.abort_identification_alert_message);

        builder.setPositiveButton(R.string.no_alert_button, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });

        builder.setNegativeButton(R.string.yes_alert_button, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                if (checkIfNewVersionOfInitialization()) {
                    IdenfyController.exitCode = new ExitCode(1);
                    deleteCache(CameraPreviewActivity.this);
                    finish();
                    dialog.dismiss();
                } else {
                    deleteCache(CameraPreviewActivity.this);
                    IdenfyController.getInstance().mListener.onAutentification(AuthentificationResult.CANCEL);
                    finish();
                }
            }
        });
        closeAppAlertDialog = builder.create();
        closeAppAlertDialog.show();
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(getResources().getColor(R.color.idenfyColorPrimary));
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(getResources().getColor(R.color.idenfyColorAccent));
    }


    public boolean getCameraPermission() {
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            cameraPermissionWasRequested = true;
            requestCameraPermission();
            return false;
        } else {
            return true;
        }
    }

    private void requestCameraPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                Manifest.permission.CAMERA)) {
            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                    new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        } else {

            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.CAMERA},
                    REQUEST_PERMISSIONS_CAMERA
            );
        }
    }


    public static void deleteCache(Context context) {
        try {
            File dir = context.getCacheDir();
            deleteDir(dir);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    AppBarLayout appBarLayout;
    private void initRecyclerView() {
        recyclerView = findViewById(R.id.documentsRecyclerView);
        recyclerView.addItemDecoration(new DividerItemDecoration(this,
                DividerItemDecoration.VERTICAL));

        final Context context = CameraPreviewActivity.this;
        LinearLayoutManager manager = new LinearLayoutManager(this);
        recyclerView.setLayoutManager(manager);

        DocumentsRecyclerViewAdapter adapter = new DocumentsRecyclerViewAdapter(
                DocumentType.getValues(), this, context,
                (IdenfyController.getInstance().getSettings().getIdenfyFont(FontEnum.DEFAULT)));

        recyclerView.setAdapter(adapter);
    }

    public static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
            return dir.delete();
        } else if (dir != null && dir.isFile()) {
            return dir.delete();
        } else {
            return false;
        }
    }


    private boolean addCameraFragment() {
        Log.d("onPause", "adding");
        boolean isFragmentNew = false;

        Fragment fragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);

        if (fragment == null) {
            isFragmentNew = true;
            CameraNewFragment cameraNewFragment = new CameraNewFragment();
            getSupportFragmentManager().
                    beginTransaction().
                    replace(R.id.newMain, cameraNewFragment, CAMERA_NEW_FRAGMENT)
                    .commit();
        }
        return isFragmentNew;

    }


    public void selectDocument(DocumentType document) {

        this.selectedDocument = document;
        if (getCameraPermission()) {

            observeIfCanSetupCameraFragment(document);
            cameraViewModel.setDocumentType(document);

        } else {
            isDocumentItemPressed = false;
            if (wasPermissionRequested) {
                showsnackBar(getResources().getString(R.string.provide_permissions_manually));
            }
        }
    }

    private void restartIdentificationLogic() {
        cameraViewModel.clearUploadsFinished();
        cameraViewModel.clearRetakedSteps();
    }

    private void observeIfCanSetupCameraFragment(DocumentType document) {
        cameraViewModel.getSetDocumentTypeResponseMutableLiveData().observe(this, responseBodyResource -> {
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.LOADING) {

                } else if (responseBodyResource.status == Status.SUCCESS) {
                    restartIdentificationLogic();
                    cameraViewModel.setCurrentDocument(this.selectedDocument);
                    cameraViewModel.setDocumentInfo(setupInitialDocument(this.selectedDocument));
                    cameraViewModel.setIsBackFotoapparatCamera(true);
                    setupViewToGetPhoto(this.selectedDocument);

                } else if (responseBodyResource.status == Status.ERROR) {
                }

            }
        });

    }

    private DocumentWrapper setupInitialDocument(DocumentType document) {

        return new DocumentWrapper(document,
                true, false,
                false,
                true,
                false,
                false,
                false,
                true,
                false
                , false,
                true
                , true
        );
    }

    private void setupViewToGetPhoto(final DocumentType document) {
        cameraViewModel.setAddCameraFragment(true);
        isDocumentItemPressed = false;
    }

    public void removeAuthenticationResultFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        Fragment camera = new CameraNewFragment();
        if (fragment != null) {
            getSupportFragmentManager().beginTransaction().remove(fragment).commit();
        }
    }

    public void removeAuthenticationResultFragmentAddCameraFragment() {
        Fragment fragment = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        Fragment camera = new CameraNewFragment();
        if (fragment != null) {
            getSupportFragmentManager().beginTransaction().replace(R.id.newMain, camera, CAMERA_NEW_FRAGMENT).commit();
        }
    }


    private boolean isIdentificationRestartReady() {
        return cameraViewModel.authneticationResultResponse.getValue() != null &&
                cameraViewModel.authneticationResultResponse.getValue().data != null &&
                cameraViewModel.authneticationResultResponse.getValue().status != Status.LOADING &&
                cameraViewModel.authneticationResultResponse.getValue().data.getProcessingStatus() != null &&
                cameraViewModel.authneticationResultResponse.getValue().data.getProcessingStatus().
                        equalsIgnoreCase("FINISHED");
    }

    @Override
    public void onBackPressed() {

        Fragment fragmentAuth = getSupportFragmentManager().findFragmentByTag(AUTH_FRAGMENT);
        Fragment cameraFragment = getSupportFragmentManager().findFragmentByTag(CAMERA_NEW_FRAGMENT);
        Fragment splashScreenFragment = getSupportFragmentManager().findFragmentByTag(SPLASH_SCREEN_FRAGMENT);
        FragmentManager fragmentManager = getSupportFragmentManager();
        if (cameraFragment == null && fragmentAuth == null && splashScreenFragment == null) {
            showCloseAppAlertDialog();
        } else if (cameraFragment != null && splashScreenFragment == null) {
            showRestartAuhenticationDialog();
        } else if (isIdentificationRestartReady()) {
            showRestartAuhenticationDialog();
        }
    }

    private void setApplicationLanguage(String newLanguage) {
        Resources activityRes = getResources();
        Configuration activityConf = activityRes.getConfiguration();
        Locale newLocale = new Locale(newLanguage);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            activityConf.setLocale(newLocale);
        }

        activityRes.updateConfiguration(activityConf, activityRes.getDisplayMetrics());

        Resources applicationRes = getApplicationContext().getResources();
        Configuration applicationConf = applicationRes.getConfiguration();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            applicationConf.setLocale(newLocale);
        }
        applicationRes.updateConfiguration(applicationConf,
                applicationRes.getDisplayMetrics());
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_PERMISSIONS_CAMERA) {
            if (permissions.length > 0) {
                if (permissions[0].equals(Manifest.permission.CAMERA)
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mReturningWithResult = true;

                } else {
                    wasPermissionRequested = true;
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                                Manifest.permission.CAMERA)) {
                            ActivityCompat.requestPermissions(CameraPreviewActivity.this,
                                    new String[]{Manifest.permission.CAMERA},
                                    REQUEST_PERMISSIONS_CAMERA);
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onAuthenticationResultFragmentClosed(boolean closed) {
        removeAuthenticationResultFragment();

    }

    @Override
    public void onCameraNewFragmentClosed(boolean wasSucess) {
        onBackPressed();
    }

    @Override
    public void onFragmentInteraction(Uri uri) {

    }

    @Override
    public void onRetakeStepsList(Boolean value) {
        if (cameraViewModel.retakeDocumentsList.getValue() != null && cameraViewModel.retakeDocumentsList.getValue().size() >= 1) {
            DocumentType document = cameraViewModel.retakeDocumentsList.getValue().get(0);
            if (document == DocumentType.FACE_PHOTO) {
                cameraViewModel.setIsBackFotoapparatCamera(false);
            } else {
                cameraViewModel.setIsBackFotoapparatCamera(true);
            }
            cameraViewModel.processUploadCompletion.postValue(Resource.loading(null));
            cameraViewModel.setDocumentInfo(setupInitialDocument(document));
            removeAuthenticationResultFragmentAddCameraFragment();
        }
    }

    @Override
    public void onClick(DocumentType type) {
        {
            if (cameraViewModel.isRecyclerViewEnabled) {
                if (!isDocumentItemPressed) {
                    isDocumentItemPressed = true;
                    CameraPreviewActivity.this.selectDocument(type);
                }
            }
        }

    }
}

