package com.idenfy.idenfySdk.Networking;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.idenfySdk.BuildConfig;

import java.util.concurrent.TimeUnit;

import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public interface RetrofitFactory {
    static APIService create() {
        Gson gson = new GsonBuilder()
                .setLenient()
                .create();
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

        String hostname = "ivs.idenfy.com";
        CertificatePinner certificatePinner = new CertificatePinner.Builder()
                .add(hostname, BuildConfig.ROOT_PIN)
               .add(hostname, BuildConfig.INTERMEDIATE_PIN)
                .add(hostname, BuildConfig.LEAF_PIN)
//                .add(hostname, "sha256/fbe3018031f9586bcbf41727e417b7d1c45c2f47f93be372a17b96b50757d5a2=")
//                .add(hostname, "sha256/7f4296fc5b6a4e3b35d3c369623e364ab1af381d8fa7121533c9d6c633ea2461=")
//                .add(hostname, "sha256/36abc32656acfc645c61b71613c4bf21c787f5cabbee48348d58597803d7abc9=")
//                .add(hostname, "sha256/f7ecded5c66047d28ed6466b543c40e0743abe81d109254dcf845d4c2c7853c5=")
//                .add(hostname, "sha256/2b071c59a0a0ae76b0eadb2bad23bad4580b69c3601b630c2eaf0613afa83f92=")
                .build();
        OkHttpClient client = new OkHttpClient.Builder()
                .addInterceptor(interceptor)
                .certificatePinner(certificatePinner)
                .connectTimeout(150, TimeUnit.SECONDS)
                .writeTimeout(150, TimeUnit.SECONDS)
                .readTimeout(150, TimeUnit.SECONDS)
                .build();
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl("https://ivs.idenfy.com/")
                .addConverterFactory(GsonConverterFactory.create(gson))
                .client(client)
                .build();
        return retrofit.create(APIService.class);
    }
}