package com.idenfy.idenfySdk.Networking;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.idenfySdk.BuildConfig;

import java.util.concurrent.TimeUnit;

import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public interface RetrofitFactory {
    static APIService create() {
        Gson gson = new GsonBuilder()
                .setLenient()
                .create();
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

        String hostname = "ivs.idenfy.com";
        CertificatePinner certificatePinner = new CertificatePinner.Builder()
                .add(hostname, BuildConfig.ROOT_PIN)
               .add(hostname, BuildConfig.INTERMEDIATE_PIN)
                .add(hostname, BuildConfig.LEAF_PIN)
//                .add(hostname, "sha256/ba021461474df35749c5d7e70a7f90ebcb36f9318b4257494b8db371bf6e51d4")
//                .add(hostname, "sha256/7641b07ae705be127cf08c68d501e86f35dd2dcf5ed2879a4a28eee86e53ccd4")
//                .add(hostname, "sha256/b8b66bf0ae57fd25213fa4da38c6d7a6d4a69dee10292cd94e0bf895d4f5fa2d")
//                .add(hostname, "sha256/afadf2eb346e93f37981bba33f7a11944cede28d7e5479bd077d9295d7c412c5")
                .build();
        OkHttpClient client = new OkHttpClient.Builder()
                .addInterceptor(interceptor)
                .certificatePinner(certificatePinner)
                .connectTimeout(150, TimeUnit.SECONDS)
                .writeTimeout(150, TimeUnit.SECONDS)
                .readTimeout(150, TimeUnit.SECONDS)
                .build();
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl("https://ivs.idenfy.com/")
                .addConverterFactory(GsonConverterFactory.create(gson))
                .client(client)
                .build();
        return retrofit.create(APIService.class);
    }
}