package com.idenfy.idenfySdk.Networking;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;


import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError;
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse;

import static com.idenfy.idenfySdk.Networking.Status.ERROR;
import static com.idenfy.idenfySdk.Networking.Status.LOADING;
import static com.idenfy.idenfySdk.Networking.Status.SUCCESS;


public class Resource<T> {
    @NonNull
    public final Status status;

    @Nullable
    public final String message;

    @Nullable
    public final IdenfyError idenfyError;

    @Nullable
    public final T data;

    public Resource(@NonNull Status status, @Nullable T data, @Nullable String message, @Nullable IdenfyError idenfyError) {
        this.status = status;
        this.data = data;
        this.message = message;
        this.idenfyError = idenfyError;
    }

    public static <T> Resource<T> success(@Nullable T data) {
        return new Resource<>(SUCCESS, data, null, null);
    }

    public static <T> Resource<T> error(@Nullable T data) {
        return new Resource<>(ERROR, data, null, null);
    }
    public static <T> Resource<T> error(String msg, @Nullable T data) {
        return new Resource<>(ERROR, data, msg, null);
    }


    public static <T> Resource<T> error(Throwable error) {
        return new Resource<>(ERROR, null, "throwable", null);
    }

    public static <T> Resource<T> error(String msg) {
        return new Resource<>(ERROR, null, msg, null);
    }

    public static <T> Resource<T> error(IdenfyError idenfyError) {
        return new Resource<>(ERROR, null, null, idenfyError);
    }

    public static <T> Resource<T> error(String msg, Throwable throwable) {
        return new Resource<>(ERROR, null, msg, null);
    }


    public static <T> Resource<T> error(@Nullable T data, IdenfyErrorResponse idenfyErrorResponse) {
        return new Resource<>(ERROR, data, idenfyErrorResponse.getMessage(), null);
    }

    public static <T> Resource<T> loading(@Nullable T data) {
        return new Resource<>(LOADING, data, null, null);
    }
}
