package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.UI.CustomViews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraDisplayHelpers;
import com.idenfy.idenfySdk.UI.UIHelpers.CameraViewSize;
import com.idenfy.idenfySdk.UI.UIHelpers.CustomFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.DpToPixelConverter;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.CameraViewModel;
import com.idenfy.idenfySdk.helpers.enums.DocumentType;
import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.configuration.UpdateConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.log.LoggersKt;
import io.fotoapparat.parameter.FocusMode;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.parameter.camera.CameraParameters;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.result.FocusResult;
import io.fotoapparat.result.WhenDoneListener;
import io.fotoapparat.selector.LensPositionSelectorsKt;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;
import io.fotoapparat.view.FeedbackCircleView;
import io.fotoapparat.view.FocusView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.LensPositionSelectorsKt.front;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

/**
 * A simple {@link Fragment} subclass.
 * create an instance of this fragment.
 */
public class CameraNewFragment extends Fragment {

    public static final String TAG = CameraNewFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    CustomFrameProcessor.OnPictureListener onPictureListener;
    private View customFocusView;
    private AppCompatImageButton takePictureButton;
    private CustomFrameProcessor frameProcessor;
    private ImageView imageView;
    private View rootView;
    private ImageView imageViewFullScreenResult;
    private ImageView imageViewResult;
    private Button retakeButton;
    private Button nextButton;
    ImageView backImage;
    TextView backTextView;

    private CameraConfiguration cameraConfiguration;
    private TextView imageViewResultTitle;
    private RelativeLayout customShapes;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();
    Runnable focusRunnable = new Runnable() {
        @Override
        public void run() {
            if(fotoapparat!=null)
            fotoapparat.getCurrentParameters().whenDone(cameraParameters -> {
                if (cameraParameters != null)
                    if(cameraParameters.getFocusMode().equals(FocusMode.Auto.INSTANCE)) {
                        if(fotoapparat!=null) {
                            fotoapparat.updateConfiguration(
                                    UpdateConfiguration.builder().focusMode(
                                            firstAvailable(continuousFocusPicture(), continuousFocusVideo())).build());
                            canFocus.set(true);
                        }
                    }
            });
        }
    };
    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    private boolean isBackCamera = true;
    DocumentType currentDocumentType;
    private long BUTTON_DELAY_FOR_UX = 200;
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;
    private final int rectangeMargin = 5;


    public interface OnCameraClosedFragment {
        // TODO: Update argument type and name
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public interface On {
        // TODO: Update argument type and name
        public void onFragmentClosed(boolean closed);
    }

    public CameraNewFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (getActivity() != null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            setFotoapparatCameraSettins(frameProcessor);
        }
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
        cameraViewModel.getIsBackFotoapparatCamera().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean isBack) {
                if (isBack != null) {

                    isBackCamera = isBack;

                    CameraNewFragment.this.setCameraSettings();
                }
            }
        });
        if (cameraViewModel.getIsBackFotoapparatCamera().getValue() != null) {
            isBackCamera = cameraViewModel.getIsBackFotoapparatCamera().getValue();
            CameraNewFragment.this.setCameraSettings();
        }
    }


    private void setCameraSettings() {
        if (fotoapparat != null) {
            fotoapparat.switchTo(isBackCamera ? LensPositionSelectorsKt.back() :
                    LensPositionSelectorsKt.front(), cameraConfiguration);
        }
    }

    private void setFotoapparatCameraSettins(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    private void initializeUI(View rootView) {
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.showedDocumentTitle);
        imageViewResultTitle = rootView.findViewById(R.id.showedDocumentTitle1);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        imageView = rootView.findViewById(R.id.imageView);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult);
        retakeButton = rootView.findViewById(R.id.recreateButton);
        imageViewResult = rootView.findViewById(R.id.imageViewResult);
        nextButton = rootView.findViewById(R.id.nextButton);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        customFocusView = rootView.findViewById(R.id.custom_focus);

    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.fragment_camera_preview, container, false);

        initializeUI(rootView);

        return rootView;
    }

    private void observeDocumentType() {
        cameraViewModel.getDocumentTypeMutableLiveData().observe(this, new Observer<DocumentType>() {
            @Override
            public void onChanged(@Nullable DocumentType response) {

                if (response != null) {
                    setupDocumentTitle(response);
                    CameraNewFragment.this.setupDocumentView(response);

                }
            }
        });
    }

    ConstraintLayout imageViewResultConstraintLayout;

    private void setupDocumentTitle(DocumentType response) {
        Integer titleId;
        currentDocumentType = response;
        titleId = CameraNewFragment.this.setupTitles(response);
        if (documentTitleTutorial != null)
            documentTitleTutorial.setText(titleId);
    }

    private void observeUI() {
        cameraViewModel.getDocumentTutorialTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });
        cameraViewModel.getImageViewResultTitleColorMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String color) {
                if (color != null) {
                }
            }
        });

        cameraViewModel.getImageViewResultTitleMutableLiveData().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                if (imageViewResultTitle != null)
                    imageViewResultTitle.setText(s);
            }
        });
        cameraViewModel.getImageViewResult().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {

                if (response != null) {
                    if (imageViewResult != null) {
                        imageViewResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });
        cameraViewModel.getImageViewResultFullSize().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewFullScreenResult != null) {
                        imageViewFullScreenResult.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                    }
                }
            }
        });


        cameraViewModel.getRecreateButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    retakeButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getShowImageLayoutVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageInfoLayout != null)
                        imageInfoLayout.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getDocumentTutorialTitleVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    if (imageViewResultTitle != null)
                        imageViewResultTitle.setVisibility(response ? View.INVISIBLE : View.VISIBLE);
                    if (documentTitleTutorial != null)
                        documentTitleTutorial.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getNextButtonVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    View view = getCustomShape();
                    if (view == null) {
                        return;
                    }
                    if (view instanceof CustomViewHolder) {
                        CustomViewHolder customViewHolder = (CustomViewHolder) view;
                        if (customViewHolder.getShouldDrawRectangle()) {
                            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                                    response ? R.color.idenfyCameraBackArrowResultsColor :
                                            R.color.idenfyCameraBackArrowPreviewColor));
                            customViewHolder.changeTransparentBackgroundVisibility(response ? false : true);
                            customViewHolder.invalidate();
                        } else if (customViewHolder.getShouldDrawOval()) {
                            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                                    R.color.idenfyCameraBackArrowPreviewColor));
                        }
                    }
                    nextButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
                }
            }
        });
        cameraViewModel.getActionButtonVisibility().observe(this, new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCameraViewVisibility().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    cameraView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }


    public void setupDocumentView(@Nullable DocumentType document) {
        if (document != DocumentType.FACE_PHOTO) {
            if(customFocusView!=null)
                customFocusView.setEnabled(true);
            if (imageViewResultTitle != null)

                imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraResultsTitle));
            rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                @SuppressLint("NewApi")
                @SuppressWarnings("deprecation")
                @Override
                public void onGlobalLayout() {

                    if (rootView != null) {
                        int width = rootView.getWidth();
                        int height = rootView.getHeight();
                        RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, document != null ? document.getProportions() : 30f / 19f);
                        if (visibleArea == null) {
                            setupImageView(document);
                        } else {
                            final double xPositionRatio = visibleArea.left / width;
                            final double yPositionRatio = visibleArea.top / height;
                            if (imageView != null)
                                setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, document);
                        }

                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                            rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                        } else {
                            rootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                        }
                    }
                }
            });
        } else {

            if (imageViewResultTitle != null)
                imageViewResultTitle.setTextColor(ContextCompat.getColor(Objects.requireNonNull(getActivity()), R.color.idenfyCameraInformationTitle));
            int width = rootView.getWidth();
            int height = rootView.getHeight();
            if(customFocusView!=null)
                customFocusView.setEnabled(true);
            RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, document != null ? document.getProportions() : 30f / 19f);
            if (visibleArea == null) {
                setupImageView(document);
            } else {
                final double xPositionRatio = visibleArea.left / width;
                final double yPositionRatio = visibleArea.top / height;
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, document);
            }
        }
    }


    private void setupImageViewWithScalledImage(final double xPositionRatio, final double yPositionRatio,
                                                DocumentType documentType) {
        if (documentType == DocumentType.ID_CARD_FRONT || documentType == DocumentType.PASSPORT || documentType == DocumentType.ID_CARD_BACK) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
            final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            int horizontalMargin = (int) (parent.getWidth() * xPositionRatio);
            int verticalMargin = (int) (parent.getHeight() * yPositionRatio);
            params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            imageView.setLayoutParams(params);

            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                determineValuesForDocument(parentWidth, parentHeight, horizontalMargin, verticalMargin);
                customViewHolder.setValuesForRectangle(rectangleLeft,
                        rectangleTop,
                        rectangleRight,
                        rectangleBottom);
                customViewHolder.invalidate();
            }
            setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth);
        }

    }

    private void setupValuesForCropping(int verticalMargin, int horizontalMargin, int parentHeight, int parentWidth) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin;
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2;
        widthOfImage = parentWidth;
        xCoordinateOfWidthStart = 0;
    }

    private void determineValuesForDocument(int parentWidth, int parentHeight, int horizontalMargin, int verticalMargin) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        if (this.rectangleLeft > this.rectangleRight) {
            int c = this.rectangleLeft;
            int k = this.rectangleRight;
            this.rectangleRight = c;
            this.rectangleLeft = k;
        }
    }

    private View getCustomShape() {
        if (customShapes != null)
            if (!(customShapes.getChildAt(0) == null)) {
                return customShapes.getChildAt(0);
            }
        return null;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD);
            backTextView.setTypeface(typeface);
            imageViewResultTitle.setTypeface(typeface);
            documentTitleTutorial.setTypeface(typeface);
            nextButton.setTypeface(typeface);
            retakeButton.setTypeface(typeface);
        }
        setupFocus();
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();


        cameraView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {


            }
        });

    }

    private void observeButtonsAvailability() {
        cameraViewModel.getNextButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null) {
                    customFocusView.setEnabled(!response);
                    nextButton.setEnabled(response);

                }
                else
                    customFocusView.setEnabled(true);
            }
        });
        cameraViewModel.getRecreateButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    retakeButton.setEnabled(aBoolean);
            }
        });
        cameraViewModel.getTakePictureButtonAvailability().observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }



    private void setupFocus() {
        customFocusView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(canFocus.get()) {
                    if(fotoapparat!=null) {
                        canFocus.set(false);
                        fotoapparat.getCurrentParameters().whenDone(new WhenDoneListener<CameraParameters>() {
                            @Override
                            public void whenDone(@org.jetbrains.annotations.Nullable CameraParameters cameraParameters) {
                                if (cameraParameters != null)
                                    if(!cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                        if(fotoapparat!=null) {
                                            fotoapparat.updateConfiguration(
                                                    UpdateConfiguration.builder().focusMode(
                                                            firstAvailable(autoFocus())).build());
                                            fotoapparat.focus().whenDone(new WhenDoneListener<FocusResult>() {
                                                @Override
                                                public void whenDone(@org.jetbrains.annotations.Nullable FocusResult focusResult) {
                                                }
                                            });
                                            if(autoFocusHandler!=null && focusRunnable!=null)
                                            autoFocusHandler.postDelayed(focusRunnable, 3000);
                                    }
                                    }
                                    else if(cameraParameters.component2().equals(FocusMode.Auto.INSTANCE))
                                    {
                                        if(fotoapparat!=null) {
                                            fotoapparat.focus();
                                            if(autoFocusHandler!=null && focusRunnable!=null)
                                            autoFocusHandler.postDelayed(focusRunnable, 2500);
                                        }
                                    }

                            }
                        });
                    }
                }
            }
        });
//        customFocusView.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                if (canFocus.get()) {
//                    canFocus.set(false);
//                    if (fotoapparat != null) {
//                        fotoapparat.focus();
//                        fotoapparat.autoFocus();
//                        fotoapparat.updateConfiguration(
//                                UpdateConfiguration.builder().focusMode(
//                                        firstAvailable(autoFocus(), fixed())).build());
//                        autoFocusHandler.postDelayed(focusRunnable, 5000);
//                    }
//                }
//            }
//        });
    }

    private void setupImageView(DocumentType documentType) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
        final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
        int horizontalMargin = (int) (parent.getWidth());
        int verticalMargin = (int) (parent.getHeight());
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        imageView.setLayoutParams(params);
        if (documentType == DocumentType.FACE_PHOTO) {
            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                customViewHolder.drawOval();
                customViewHolder.invalidate();
            }
        }


    }

    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                takePictureHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (getActivity() != null) {
                            takePicture();
                        }
                    }

                }, BUTTON_DELAY_FOR_UX);

            }
        });


    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new CustomFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (cameraView != null) {
            requireActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    show(BitmapPhotoCropper.
                            cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                    currentDocumentType), currentDocumentType);


                }
            });


        }
    }

    public void show(final Bitmap bitmap, DocumentType type) {

//        if(IdenfyController.getInstance().getSettings().getCustomBackgroundPath()!=-1){
//          //  imageInfoLayout.setBackgroundDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_checked));
//        }
        cameraViewModel.setShowImageLayoutVisibility(true);
        cameraViewModel.setImageViewResultTitleMutableLiveData(type);
        if (type == DocumentType.FACE_PHOTO) {
            if (imageViewFullScreenResult != null) {
                cameraViewModel.setImageViewResultFullSize(true);
                imageViewFullScreenResult.setImageBitmap(bitmap);
            }
        } else {
            cameraViewModel.setImageViewResult(true);
            if (imageViewResult != null) {
                ViewGroup.LayoutParams params = imageViewResult.getLayoutParams();
                params.width = rectangleRight - rectangleLeft;
                params.height = rectangleBottom - rectangleTop;
                imageViewResult.setLayoutParams(params);
                imageViewResult.setImageBitmap(bitmap);
            }
        }
        cameraViewModel.setDocumentTutorialTitleVisibility(false);
        cameraViewModel.setActionButtonVisibility(false);
        cameraViewModel.setRecreateButtonVisibility(true);
        cameraViewModel.setNextButtonAvailability(true);
        cameraViewModel.setRecreateButtonAvailability(true);
        cameraViewModel.setNextButtonVisibility(true);


        retakeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                recreateButtonHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (!bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                        recreateImage();
                    }

                }, BUTTON_DELAY_FOR_UX);

            }
        });

        nextButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(true);
                nextButtonHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        nextStep(bitmap);
                    }

                }, BUTTON_DELAY_FOR_UX);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    public void nextStep(Bitmap bitmap) {
        cameraViewModel.setupNewDocument(bitmap);
    }


    public void recreateImage() {
        cameraViewModel.changeDocument(currentDocumentType, true);
    }

    private Integer setupTitles(DocumentType documentType) {
        Integer titleName = -1;
        switch (documentType) {
            case PASSPORT:
                titleName = R.string.document_type_text;
                break;
            case ID_CARD_FRONT:
                titleName = R.string.document_type_id_card_front;
                break;
            case ID_CARD_BACK:
                titleName = R.string.document_type_id_card_back;
                break;
            case FACE_PHOTO:
                titleName = R.string.document_face_photo;
                break;
        }
        return titleName;
    }


    @Override
    public void onPause() {
        super.onPause();

    }

    @Override
    public void onStop() {
        super.onStop();
        if (frameProcessor != null) {
            frameProcessor = null;
        }
        if (fotoapparat != null) {
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (fotoapparat != null) {
                        fotoapparat.stop();
                        fotoapparat = null;
                    }

                }
            }, 300);
        }


    }

    @Override
    public void onStart() {
        super.onStart();
        Activity activity = getActivity();
        if (isAdded() && activity != null) {

            if (frameProcessor == null)
                frameProcessor = new CustomFrameProcessor(requireActivity());
            if (fotoapparat != null) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (fotoapparat != null)
                            fotoapparat.start();
                    }
                }, 200);
            } else {
                fotoapparatSetupHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        setupCamera();

                    }
                }, 200);
            }

        }
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        backTextView = null;
        backImage = null;
        imageViewFullScreenResult = null;
        imageViewResult = null;
        imageInfoLayout = null;
        cameraView = null;
        rootView = null;
        imageView = null;
        customFocusView = null;
        documentTitleTutorial = null;
        imageViewResultTitle = null;
        nextButton = null;
        retakeButton = null;
        takePictureButton = null;
        if (customShapes != null) {

            for (int i = 0; i < customShapes.getChildCount(); i++) {
                if (customShapes.getChildAt(i) != null) {
                    customShapes.removeViewAt(i);
                }
            }
            customShapes = null;
        }
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }

    public void setupCamera() {

        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            fotoapparat = Fotoapparat
                    .with(getActivity())
                    .into(cameraView)
                    .previewScaleType(ScaleType.CenterCrop)
                    .previewResolution(highestResolution())
                    .lensPosition(isBackCamera ? back() : front())
                    .focusMode(firstAvailable(
                            continuousFocusPicture(),
                            continuousFocusVideo(),
                            autoFocus(),
                            fixed()
                    ))
                    .photoResolution(ResolutionSelectorsKt.highestResolution())
                    .frameProcessor(new CustomFrameProcessor(getActivity()))
                    .logger(
                            LoggersKt.logcat()
                    )
                    .cameraErrorCallback(new CameraErrorListener() {
                        @Override
                        public void onError(@NonNull CameraException e) {
                        }
                    })
                    .build();


            fotoapparat.start();


        }
    }

    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);

    }


}
