package com.idenfy.idenfySdk.UI.CountriesSelectionView;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfySdk.R;

import java.util.ArrayList;
import java.util.List;


public class CountriesRecyclerViewAdapter extends RecyclerView.Adapter<CountriesRecyclerViewAdapter.ViewHolder> {
    private List<Country> countriesList;
    private onItemClickListener onClickListener;

    public interface onItemClickListener {
        void onClick(Country type);
    }

    public void addAll(List<Country> response) {
        this.countriesList = response;
    }

    public void setCountriesList(List<Country> filteredList) {
        this.countriesList = filteredList;
        notifyDataSetChanged();
    }

    public final String TAG = getClass().getSimpleName();

    public CountriesRecyclerViewAdapter(Context context, final onItemClickListener listener) {
        this.countriesList = new ArrayList<>();
        onClickListener = listener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // create a new view
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_country_drop, parent, false);


        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {


        Country country = countriesList.get(position);
        if (country != null) {
            holder.mNameView.setText(country.getName());


            holder.mImageView.setImageResource(country.getResId());
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onClickListener.onClick(country);
                }
            });
        }

    }

    @Override
    public int getItemCount() {
        if (countriesList != null)
            return countriesList.size();
        return 0;
    }

    //ViewHolder
    class ViewHolder extends RecyclerView.ViewHolder {
        public ImageView mImageView;
        public TextView mNameView;
        public TextView mCodeView;

        ViewHolder(View itemView) {
            super(itemView);
            mImageView = itemView.findViewById(R.id.image);
            mNameView = itemView.findViewById(R.id.country_name);
        }
    }
}
