package com.idenfy.idenfySdk.CoreSdkInitialization;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.idenfy.idenfySdk.helpers.enums.FontEnum;
import com.idenfySdk.R;

public class IdenfySettings implements Parcelable {

    public boolean optionalResultsChecking = false;
    private String selectedCountry;
    private Typeface font;
    private @Nullable
    String token;
    private @Nullable
    Boolean handleResultsChecking = false;

    private @Nullable
    String selectedSdkCustomLocale = null;

    private @Nullable
    boolean isNewWayOfIdentification = true;
    private String customFontPath;
    private String predefinedIssuingCountry = null;
    private Integer customBackgroundPath = -1;
    private Integer customResultsViewSpinner = null;


    private boolean customIdentificationLayout = false;

    protected IdenfySettings(Parcel in) {
        optionalResultsChecking = in.readByte() != 0;
        selectedCountry = in.readString();
        token = in.readString();
        byte tmpHandleResultsChecking = in.readByte();
        handleResultsChecking = tmpHandleResultsChecking == 0 ? null : tmpHandleResultsChecking == 1;
        selectedSdkCustomLocale = in.readString();
        isNewWayOfIdentification = in.readByte() != 0;
        customFontPath = in.readString();
        predefinedIssuingCountry = in.readString();
        if (in.readByte() == 0) {
            customBackgroundPath = null;
        } else {
            customBackgroundPath = in.readInt();
        }
        if (in.readByte() == 0) {
            customResultsViewSpinner = null;
        } else {
            customResultsViewSpinner = in.readInt();
        }
        customIdentificationLayout = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (optionalResultsChecking ? 1 : 0));
        dest.writeString(selectedCountry);
        dest.writeString(token);
        dest.writeByte((byte) (handleResultsChecking == null ? 0 : handleResultsChecking ? 1 : 2));
        dest.writeString(selectedSdkCustomLocale);
        dest.writeByte((byte) (isNewWayOfIdentification ? 1 : 0));
        dest.writeString(customFontPath);
        dest.writeString(predefinedIssuingCountry);
        if (customBackgroundPath == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(customBackgroundPath);
        }
        if (customResultsViewSpinner == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeInt(customResultsViewSpinner);
        }
        dest.writeByte((byte) (customIdentificationLayout ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IdenfySettings> CREATOR = new Creator<IdenfySettings>() {
        @Override
        public IdenfySettings createFromParcel(Parcel in) {
            return new IdenfySettings(in);
        }

        @Override
        public IdenfySettings[] newArray(int size) {
            return new IdenfySettings[size];
        }
    };

    public boolean isCustomIdentificationLayout() {
        return customIdentificationLayout;
    }

    public void setCustomIdentificationLayout(boolean customIdentificationLayout) {
        this.customIdentificationLayout = customIdentificationLayout;
    }

    public String getCustomFontPath() {
        return customFontPath;
    }


    @Nullable
    public boolean isNewWayOfIdentification() {
        return isNewWayOfIdentification;
    }

    public void setNewWayOfIdentification(@Nullable boolean newWayOfIdentification) {
        isNewWayOfIdentification = newWayOfIdentification;
    }

    public Typeface getIdenfyFont(FontEnum fontEnum) {
        if (this.font != null) {
            return this.font;
        }

        return fontEnum.getTypeface();
    }

    public void setFont(String font) {

        this.customFontPath = font;
    }

    public void setIssuingCountry(String issuingCountry) {
        this.predefinedIssuingCountry = issuingCountry;
    }

    public String getIssuingCountry() {
        return this.predefinedIssuingCountry;
    }


    @Nullable
    public Boolean getHandleResultsChecking() {
        return handleResultsChecking;
    }

    public IdenfySettings(@NonNull String token, @NonNull Context context) {
        this.token = token;
    }

    @Nullable
    public String getToken() {
        return token;
    }


    public void setCustomLocale(String locale) {
        selectedSdkCustomLocale = locale;
    }

    public String getCustomLocale() {

        return selectedSdkCustomLocale;
    }

    public String getSelectedCountry() {
        return selectedCountry;
    }

    public void setSelectedCountry(@NonNull String selectedCountry) {
        this.selectedCountry = selectedCountry;
    }

    void setHandleResultsChecking(boolean optionalHandeling) {
        this.handleResultsChecking = optionalHandeling;
    }

    private void setCustomBackgroundPath(Integer integer) {
        this.customBackgroundPath = integer;
    }


    @Override
    public String toString() {
        return "IdenfySettings{" +
                ", selectedCountry='" + selectedCountry + '\'' +
                ", font=" + font +
                ", token='" + token + '\'' +
                ", handleResultsChecking=" + handleResultsChecking +
                '}';
    }

    public void setCustomTypeface(Typeface idenfyFont) {

        if (idenfyFont != null)
            font = idenfyFont;
    }

    public Integer getCustomBackgroundPath() {
        return customBackgroundPath;
    }

    public Integer getCustomResultsViewSpinner() {
        return this.customResultsViewSpinner;
    }

    public void setCustomResultsSpinner(int spinnerResourceId) {
        this.customResultsViewSpinner = spinnerResourceId;
    }
}
